/***************************************************************************
*																		   *
* Implementacin de los algoritmos:										   *			
*																		   *	
* NMIFS (Normalized Mutual Information Feature Selection)				   *
* [Tesmer & Estevez '08]                                                   *
*												                           *
* MIFS  (Mutual Informacin Feature Selection)                             *
* [Battiti '94] 	   													   *
* IMIFS (Improved Mutual Informacin Feature Selection)					   * 	
* [Kwak & Choi '99] 													   *
																		   *
****************************************************************************
* (c) 2002 Pedro Ortega												       *
* peortega@dcc.uchile.cl												   *
* 01/2002																   *
*																		   *
* Modificacion Michel Tesmer 											   *
* micheltesmer@gmail.com												   *
* 04/2003																   *	
***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <memory.h>
#include "fifoqueues.h"
#include "loadmod.h"
#include "minfomodr.h"
#include "mifsselectionr.h"


/* Constantes del programa */
#define BETA  0.7f			/* Constante de Penalizacin  */
#define REPORTE_NO 0		/* Imprime reporte simple */
#define I_WORD '\0'
#define STD_OUTP "resultados.txt"	/* Archivo de salida por default */

/* Modificacion MTT */
#define	CRITERION	0.3f		/* Criterio de continuidad para caracteristicas
								   en la funcion "discreteMeasureFeature" */

/* Nombre de los criterios de seleccion */
#define ALG_AMIFS_TIME_SERIE_NAME		"AMIFS_TIME_SERIE"
#define ALG_MIFS_NAME					"MIFS"
#define ALG_IMIFS_NAME					"IMIFS"
#define ALG_AMIFS_NAME					"AMIFS"
#define ALG_AMIFS_NORM_NAME				"AMIFS_NORM"
#define ALG_TMIFS2_NAME					"TMIFS2"
#define ALG_TMIFS3_NAME					"TMIFS3"
#define ALG_TMIFS4_NAME					"TMIFS4"
#define ALG_MIFSMODPO_NAME				"MIFSMODPO"
#define ALG_AMIFS_NORM_TIME_SERIE_NAME	"AMIFS_NORM_TIME_SERIE"

/* Opcion de los criterios de seleccioin para el programa */
#define ALG_AMIFS_TIME_SERIE		0
#define ALG_MIFS					1
#define ALG_IMIFS					2
#define ALG_AMIFS					3
#define ALG_AMIFS_NORM				4
#define ALG_TMIFS2					5
#define ALG_TMIFS3					6
#define ALG_TMIFS4					7
#define ALG_MIFSMODPO	 			8
#define ALG_AMIFS_NORM_TIME_SERIE	9


/******************************************************/

void uso()
{
	printf("\n+-------------------------------------------------------+\n");
	printf("| MIFS  - Mutual Information Feature Selection          |\n");
	printf("+-------------------------------------------------------+\n\n");
	printf("Algoritmos para la seleccion de caracteristicas relevantes,\n");
	printf("segun el criterio de Informacion Mutua.\n");
	printf("\nUso:\tmifsmain -a <AlgType> -c <NClass> -k <NFeature>\n");
	printf("                 -e <ClassFile> -d <DataFile> -f <FeatureTypeFile>\n");
 	printf("                 -o <OutFile> -r <ReportType> -b <Beta> -g <GenesFile>\n\n\n");

	printf("-a <AlgType>        : Switch para seleccionar el algoritmo de seleccion\n");
	printf("                      <AlgType> puede ser:\n");
	printf("                        0 %s\n", ALG_AMIFS_TIME_SERIE_NAME);
	printf("                        1 %s\n", ALG_MIFS_NAME);
	printf("                        2 %s\n", ALG_IMIFS_NAME);
	printf("                        3 %s\n", ALG_AMIFS_NAME);
	printf("                        4 %s\n", ALG_AMIFS_NORM_NAME);
	printf("                        5 %s\n", ALG_TMIFS2_NAME);
	printf("                        6 %s\n", ALG_TMIFS3_NAME);
	printf("                        7 %s\n", ALG_TMIFS4_NAME);
	printf("                        8 %s\n", ALG_MIFSMODPO_NAME);
	printf("                        9 %s\n\n", ALG_AMIFS_NORM_TIME_SERIE_NAME);
	printf("-c <NClass>         : Numero de clases.\n\n");
	printf("-k <NFeature>       : Numero de caracteristicas que se desea escoger.\n\n");
	printf("-e <ClassFile>      : Archivo con etiquetas. La etiqueta es un numero entero\n");
	printf("                      dentro de [1..Nclases] que indica a que clase pertenece.\n\n");
	printf("-d <DataFile>       : Archivo de ejemplos.\n\n");
	printf("-f <FeatureTypeFile>: Archivo con tipo de cada caracteristica\n");
 	printf("                      (continua o discreta)\n\n");		/* Modificacion MTT */
	printf("-o <OutFile>        : Archivo de salida del metodo de seleccion (Reporte).\n");
	printf("                      Valor por defecto: \"%s\".\n\n", STD_OUTP);
	printf("-r <ReportType>     : Tipo de reporte en archivos de salida.\n");
	printf("                        0 Ranking de caracteristicas\n");
	printf("                        1 Ranking de caracts + detalle de seleccion\n");
	printf("                        2 Matriz de MI entre caracteristicas (\"matrix_MI.txt\")\n");
	printf("                        3 Matriz de MI normalizada (\"matrix_QM.txt\")\n");
	printf("                        4 Ranking + detalle de seleccion + matriz MI\n");
	printf("                        5 Ranking + matriz MI normalizada (QM)\n\n");
	printf("                        6 Ranking de caracts + Matriz de redundancia entre caracteristicas (\"matrix_MI.txt\")\n");
	printf("-b <Beta>           : Parametro Beta.\n\n");
	printf("-g <GenesFile>      : Imprimir genotipos en <GenesFile>.\n");
	printf("                      No hace nada por defecto.\n");
}


/**************************************************************/

/* Parsea el vector de argumentos y retorna la opcin */

int getoption(int option, char **argv)
{
	if (argv[option][0] == '-')
		return argv[option][1];
	else
		return I_WORD;
}

/**************************************************************/

int main(int argc, char** argv)
{
	float *X, *H;			
	int  *Ix, sel, c;
	FifoQueue FSet, CSet;
	int *C;
	int i, j, n, m, f;
	char *alg_name;
	char *genotipo;
	int *FeatType;				/* Modificacion MTT */
	float *measure;
	FILE *fp_measure;
	
	char *ClssFileName;			/* Nombre del archivo de clases o etiquetas */
	char *DataFileName;			/* Nombre del archivo con caracteristicas */
	char *FeatFileName;			/* Modificacion MTT */
	char *OutpFileName;			/* Nombre del archivo de salida */
	char *GenFileName;			/* Nombre del archivo con tiras de caracteristicas seleccionadas */

	FILE *OutpFilePtr;			/* Archivo de salida */
	FILE *GenFilePtr;			/* Archivo con tiras de caracteristicas seleccionadas */
	
	int   Reporte;				/* 0 -> no hay reporte, 1-> hay reporte */
	float beta;					/* constante de penalizacion */
	int   algoritmo;			/* puede valer ALG_AMIFS_TIME_SERIE, ALG_MIFS, ALG_IMIFS,
                                   ALG_AMIFS, ALG_TMIFS2, ALG_TMIFS3, ALG_TMIFS4
                                   o ALG_MIFSMODPO */

	FSet = MakeFifoQueue();
	CSet = MakeFifoQueue();
	
	/* Setear los valores por defecto que   */
	/* rigen el comportamiento del programa */

	OutpFileName = STD_OUTP;
	GenFileName  = NULL;
	Reporte      = REPORTE_NO;
	beta         = BETA;
	algoritmo    = ALG_MIFS;
	alg_name     = ALG_MIFS_NAME;

	c = sel = 0;

	/* Parsear la lnea de comando */
	for (i=1; i<argc; ++i)
	{
		switch(getoption(i, argv))
		{
		case I_WORD:
			uso();
			system("pause");
			return 0;
		case 'a':
			sscanf(argv[++i], "%d", &algoritmo);
			switch(algoritmo)
			{
			case ALG_AMIFS_TIME_SERIE:
				alg_name = ALG_AMIFS_TIME_SERIE_NAME;
				break;
			case ALG_MIFS:
				alg_name = ALG_MIFS_NAME;
				break;	
			case ALG_IMIFS:
				alg_name = ALG_IMIFS_NAME;
				break;
			case ALG_AMIFS:
				alg_name = ALG_AMIFS_NAME;
				break;
			case ALG_AMIFS_NORM:
				alg_name = ALG_AMIFS_NORM_NAME;
				break;
			case ALG_TMIFS2:
				alg_name = ALG_TMIFS2_NAME;
				break;
			case ALG_TMIFS3:
				alg_name = ALG_TMIFS3_NAME;
				break;
			case ALG_TMIFS4:
				alg_name = ALG_TMIFS4_NAME;
				break;
			case ALG_MIFSMODPO:
				alg_name = ALG_MIFSMODPO_NAME;
				break;
			case ALG_AMIFS_NORM_TIME_SERIE:
				alg_name = ALG_AMIFS_NORM_TIME_SERIE_NAME;
				break;
			}
			break;
		case 'c':
			sscanf(argv[++i], "%d", &c);
			break;
		case 'k':
			sscanf(argv[++i], "%d", &sel);
			break;
		case 'e':
			ClssFileName = argv[++i];
			break;
		case 'd':
			DataFileName = argv[++i];
			break;
		case 'f':									/* Modificacion MTT */
			FeatFileName = argv[++i];
			break;
		case 'o':
			OutpFileName = argv[++i];
			break;
		case 'r':									/* Modificacion MTT */
			Reporte = atoi(argv[++i]);
			break;
		case 'b':
			sscanf(argv[++i], "%f", &beta);
			break;
		case 'g':
			GenFileName = argv[++i];
			break;
		default:
			break;
		}
	}

	if (!c || !sel)
	{
		uso();
		return 0;
	}
	

	/* Preparar los datos */
		
	/* Reporte */
	printf("\nCargando el archivo de etiquetas:\n");

	/* Leer etiquetas */
	CSet = readMatrix(ClssFileName, &n, &m);
	if (CSet == NULL || m != 1)
	{
		fprintf(stderr, "Error al leer las etiquetas!\n");
		return 0;
	}

	/* Memoria vector caracts y clases */
	X = (float *) malloc(sizeof(float) * (n+1));
	C = (int *) malloc(sizeof(int) * (n+1));

	/* Cuantificacion de Etiquetas */
	X = (float *) GetObj(CSet);
	for(i=0; i<=n; ++i)
	{
		if( (algoritmo == ALG_AMIFS_TIME_SERIE) || (algoritmo == ALG_AMIFS_NORM_TIME_SERIE) )
		{
			quantifyRepeat(X, C, n);
  		}
		else
		{
			C[i] = (int) X[i];
  		}
	}
	

	/* Reporte */
	printf("\nCargando el archivo de ejemplos:\n");

	/* Leer ejemplos */
	FSet = readMatrix(DataFileName, &n, &f);

	/* Modificacion MTT */
	FeatType = readDataVector(FeatFileName, f);

	
	if (FSet == NULL)
	{
		fprintf(stderr, "Error al leer las caractersticas!\n");
		return 0;
	}

	/* Analisis de continuidad de caracteristicas */
	/*
	measure = (float *) malloc(sizeof(float) * (f+1));
	fp_measure = fopen("measure.txt", "w");
	fprintf(fp_measure, "Medida de continuidad de caracteristicas\n\n");
	fprintf(fp_measure, "Archivo: %s\n\n", DataFileName);
	for (i=1; i <= f; ++i)
	{
		X = (float *) GetObj(FSet);
		if(FeatType[i-1] == 1)
			measure[i] = discreteMeasureFeature(X, n);
		else
			measure[i] = 1000;			
    	
		PutObj(FSet, (void *) X);
		fprintf(fp_measure, "f%2d\t%5.5f\n", i, measure[i]);
 	}
	*/
	/* Reporte */
	printf("Dando formato a los datos (Cuantificacion y Entropia).\n ");
	fflush(stdout);

	H  = (float *) malloc(sizeof(float) * (f+1));
	for (i=1; i<=f; ++i)
	{
		Ix = (int *) malloc(sizeof(int) * (n+1));
		X  = (float *) GetObj(FSet);
		
		/* Modificacion MTT */
		if (FeatType[i-1] == 0)				/* 0 -> Caracteristica Discreta */
		{
			quantifyRepeat(X, Ix, n);
			H[i] = entropyDiscrete(Ix, n);
			PutObj(FSet, (void *) Ix);
		}
		else								/* 1 -> Caracteristica Continua */
		{
			/* Entropia mediante histograma */
			//H[i] = entropy(X, n);

			/* Cuantificacion de Caracteristicas */
			quantifyRepeat(X, Ix, n);
			/* Entropia mediante Fraser */
			H[i] = entropyFraser(Ix, n);
			PutObj(FSet, (void *) Ix);
		}	
	}

	if (LengthFifoQueue(FSet) < sel)
	{
		fprintf(stderr, "No hay suficientes caractersticas!\n");
		return 0;
	}

	/* Aplicar MIFS */

	/* Reporte */
	printf("\nAplicando %s:\n", alg_name);

	/* Aplicar algoritmo MIFS */
	/* Modificacion MTT */
	FSet = mifs(FSet, C, H, n, c, sel, beta, algoritmo, OutpFileName,
 				DataFileName, ClssFileName, alg_name, Reporte, FeatType);
 	
	/* Preparar los datos para imprimir el Genotipo */
	if( (Reporte != 2) && (Reporte != 3) )
	{
 		if (GenFileName != NULL)
		{
			if ((GenFilePtr = fopen(GenFileName, "w")) == NULL)
			{
				fprintf(stderr, "No se pudo escribir en el archivo de genotipos!\n");
				GenFileName = NULL; /* Desactivar la opcion de escritura de genotipos */
			}
			else
			{	
   				/* crear espacio para el genotipo */	
				genotipo = (char *) malloc(sizeof(char) * (f+1)); 
				memset(genotipo, '0', f+1);
				genotipo[f] = '\0';
				fprintf(GenFilePtr, "\nArchivo de Datos:     %s\n", DataFileName);
				fprintf(GenFilePtr, "Archivo de Etiquetas: %s\n\n", ClssFileName);
				fprintf(GenFilePtr, "Beta: %2.2f\n\n", beta);
				fprintf(GenFilePtr, "Resultados: Genotipos obtenidos por %s\n", alg_name);
				fprintf(GenFilePtr, "------------------------------------------------------------------\n");
			}
		}
		
		/* imprimir los genotipos */
		for (i=0; i<sel; ++i)
		{
			Ix = (int *) GetObj(FSet);
			if (GenFileName != NULL)
			{
				genotipo[Ix[0]-1] = '1';
				fprintf(GenFilePtr, "%-3d: %s\n", i+1, genotipo);
			}
			
		}
		
		/* terminar archivo de genotipos */
		if (GenFileName != NULL)
		{
			fprintf(GenFilePtr, "------------------------------------------------------------------\n");
			fclose(GenFilePtr);
		}
	}
	
	/* Modificacion MTT */
	free(FeatType);
	free(measure);
	//fclose(fp_measure);
	system("pause");
	return 0;
}


/**************************************************************/
