/**************************************
*                                     *
* counter.c                           *
*                                     *
***************************************
*                                     *
* Implementa un contador de progreso  *
* en pantalla.                        *
*                                     *
***************************************
* (c) 2002 Pedro Ortega               *
* peortega@dcc.uchile.cl              *
**************************************/

#include <stdio.h>
#include <stdlib.h>
#include "counter.h"


counter nuevoContador(unsigned long total, FILE *pantalla)
{
    counter c;
    c = (counter) malloc(sizeof(*c));
    c->pantalla = pantalla;
    c->total    = total;
    c->actual   = 0;
    c->ultimo_p = 0;

    fprintf(c->pantalla, "\n ...10...20...30...40...50...60...70...80...90..100\n ");
    return c;
}

void destruirContador(counter c)
{
    while (100.0f > 100.0f * c->actual / c->total)
    {
        fprintf(c->pantalla, ".");
        fflush(c->pantalla);
        c->actual++;
    }
    fprintf(c->pantalla, ".\n");
    free(c);
}

void incContador(counter c)
{
    c->actual++;
    while (c->ultimo_p + 2.0f < 100.0f * c->actual / c->total)
    {
        fprintf(c->pantalla, ".");
        fflush(c->pantalla);
        c->ultimo_p = (int)(100.0f * c->actual / c->total);
    }
}
