/**************************************
*                                     *
* load.c                              *
*                                     *
***************************************
*                                     *
* Lee una matriz desde un archivo y   *
* la guarda en una fifoqueue de       *
* arreglos float por columnas.        *
*                                     *
***************************************
* (c) 2002 Pedro Ortega               *
* peortega@dcc.uchile.cl              *
*									  *
* Modificacion Michel Tesmer		  *
* mtesmer@ing.uchile.cl				  *
* 04/2003							  *
**************************************/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "fifoqueues.h"
#include "loadmod.h"
#include "counter.h"
#include "memoria.h"

/**************************************************************/

FifoQueue readMatrix(char *file, int *filas, int *cols)
{
	counter contador; /* Reporte */

	int  m, n, i, j;
	FILE          *fp;
	char           buf[BIGBUF    + 1];
	char          *tok;
	FifoQueue      Set;
	float         *X;

	/* inicializar */
	m = n = 0;
	/* abrir el archivo */
	if((fp = fopen(file, "r")) == NULL)
		return NULL;

	/* Reporte */
	fprintf(stderr, "\n- Determinando el tamao de la matriz: ");

	/* Determinar el tamao de la matriz */
	if (fgets(buf, BIGBUF + 1, fp) != NULL)
	{
		m++;
		if(strtok(buf, " \t\r\n") != NULL)
			n++;
		while(strtok(NULL, " \t\r\n") != NULL)
			n++;
		while(fgets(buf, BIGBUF + 1, fp) != NULL)
			m++;
	}

	/* Reporte */
	fprintf(stderr, "%d x %d\n", m, n);

	/* cerrar el archivo */
	fclose(fp);


	/* grabar el tamao de la matriz */
	*filas = m;
	*cols  = n;

	/* Reporte */
	fprintf(stderr, "- Cargando...\n\n");
    contador = nuevoContador(m*n, stderr);

	/* Cargarlo */
	if (n > 0 && m > 0)
	{
		/* crear los espacios */
		Set = MakeFifoQueue();
		for (j=0; j<n; ++j)
		{
			X = (float *) malloc(sizeof(float) * (m + 1));
			X[0] = (float) j+1; 	/* guardar en la primera posicin el */
						/* nmero de la col. del vector      */
			PutObj(Set, (void *) X);
		}


		/* leer la matriz del archivo */
		fp = fopen(file, "r");
		for (i=1; i<=m; ++i)
		{
			fgets(buf, BIGBUF + 1, fp);
			tok = strtok(buf, " \t\n");
			for (j=1; j<=n; ++j)
			{
				/* Reporte */
                incContador(contador);

				X = (float *) GetObj(Set);
				sscanf(tok, "%f", &X[i]);
				PutObj(Set, (void *) X);
				tok = strtok(NULL, " \t\n");
			}
		}
		fclose(fp);
        destruirContador(contador);
	}
	else
		return NULL;

	/* Reporte */
	fprintf(stderr, ".\n\n");

	return Set;
}

/**************************************************************/

/* Modificacion MTT */

float **readDataBase(char *filename, int nrow, int ncol)
{
	int i, j;
	float **base;
	char *tok, buffer[BIGBUF];
	FILE *fp;

	if ((fp = fopen(filename, "r")) == NULL)
		exit;

	base = matrizFloat(nrow, ncol);

	/* lectura del archivo */
	fp = fopen(filename, "r");
	for (i=0; i < nrow; ++i)
	{
		fgets(buffer, BIGBUF, fp);
		tok = strtok(buffer, " \t\n");
		for (j=0; j < ncol; ++j)
		{
			sscanf(tok, "%f", &base[i][j]);
			tok = strtok(NULL, " \t\n");
		}
	}
	fclose(fp);
	return base;
}

/*********************************************************************/

int *readDataVector(char *filename, int ncol)
{
	int i;
	int *vect;
	char *tok, buffer[BIGBUF];
	FILE *fp;

	vect = vectorInt(ncol);

	if ((fp = fopen(filename, "r")) == NULL)
		exit;

	/* lectura del archivo */
	fgets(buffer, BIGBUF, fp);
	tok = strtok(buffer, " \t\n");
	for (i=0; i < ncol; ++i)
	{
		sscanf(tok, "%d", &vect[i]);
		tok = strtok(NULL, " \t\n");
	}

	fclose(fp);
	return vect;
}

/*********************************************************************/
