
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "cromosoma.h"
#include "poblacion.h"

#define MAXLINE		256

/**********************************************************************/

poblacion nuevaPoblacion(int tamano, int largo)
{
	int i;
	poblacion p;
	
	p = (poblacion) malloc(sizeof(*p));
	p->tamano = tamano;
	p->largo  = largo;
	p->individuos = (cromosoma *) malloc(tamano * sizeof(cromosoma));
	for (i=0; i<tamano; ++i)
		p->individuos[i] = nuevoCromosoma(largo);
		
	return p;
}

/**********************************************************************/

poblacion nuevaPoblacionRankingAMIFS(int tamano, int largo, int *ranking,
                                     float pctje_pop, float pctje_bits)
{
	int i;
 	float Np;
	poblacion p;
	
	p = (poblacion) malloc(sizeof(*p));
	p->tamano = tamano;
	p->largo  = largo;
	p->individuos = (cromosoma *) malloc(tamano * sizeof(cromosoma));
	
	Np = (pctje_pop * (float)tamano);
	if( (Np - (int)Np) < 0.5f )
		Np = (int)Np;
	else
		Np = (int)Np + 1;
		
	for (i=0; i < (int)Np; ++i)
		p->individuos[i] = nuevoCromosomaRankingAMIFS(largo, ranking, pctje_bits);
	
	for (i=(int)Np; i < tamano; ++i)
		p->individuos[i] = nuevoCromosoma(largo);
		
	return p;
}

/**********************************************************************/

poblacion nuevaPoblacionFromLastSimulation(char *fpop_name, int genIter,
                                           int tamano, int largo)
{
	int i, j;
	int point;
	FILE *fpop;
	char *buffer;
	poblacion p;
	
	buffer = (char *) malloc(MAXLINE * sizeof(char)); 
 	/* posicion en el archivo de ultima poblacion guardada */
	point  = (genIter-1)*tamano + (genIter-1);
	
	p = (poblacion) malloc(sizeof(*p));
	p->tamano = tamano;
	p->largo  = largo;
	p->individuos = (cromosoma *) malloc(tamano * sizeof(cromosoma));
	
	fpop = fopen(fpop_name, "r");
 	for(i=0; i < point; i++)
 		fgets(buffer, MAXLINE, fpop);
 	
	for(i=point; i < (point+tamano); i++)
	{
		p->individuos[i-point] = nuevoCromosomaFromLastPopulation(fpop, largo);
 	}
 	
	free(buffer);
	fclose(fpop);	
	return p;
}

/**********************************************************************/

void destruirPoblacion(poblacion p)
{
	int i;
	for (i=0; i<p->tamano; ++i)
		destruirCromosoma(leerIndividuo(p, i));
	free(p);
}
/**********************************************************************/

void copiarPoblacion(poblacion d, poblacion f)
{
	int i;
    d->largo = f->largo;
    d->tamano = f->tamano;
	for (i=0; i<f->tamano; ++i)
		copiarCromosoma(leerIndividuo(d, i), leerIndividuo(f, i));
}
/**********************************************************************/

poblacion duplicarPoblacion(poblacion f)
{
	poblacion d;
	
	d = nuevaPoblacion(f->tamano, f->largo);
	copiarPoblacion(d, f);
	return d;
}
/**********************************************************************/

void mezclarPoblacion(poblacion p)
{
    int i, j, k;
    cromosoma c;

    for (k=0; k<p->tamano * 2; ++k)
    {

        i = rand() % p->tamano;
        j = rand() % p->tamano;
        c = leerIndividuo(p, i);
        leerIndividuo(p, i) = leerIndividuo(p, j);
        leerIndividuo(p, j) = c;
    }
}
/**********************************************************************/

void imprimirPoblacion(poblacion p, FILE *fp)
{
    char *buffer;
    int i;

    buffer = (char *) malloc(sizeof(char) * (p->largo + 1));
    for (i=0; i<p->tamano; ++i)
    {
        cromosoma2string(leerIndividuo(p, i), buffer);
        fprintf(fp, "%s\n", buffer);
    }
    fprintf(fp, "\n");
    free(buffer);
}
/**********************************************************************/

void evaluarPoblacion(poblacion p, float (*func_fitness)(cromosoma c, 
					  float *var, int nvar, int preci, float liminf, 
					  float limsup), float *var, int nvar, int preci,
					  float liminf, float limsup)
{
	int i;
	for (i=0; i<p->tamano; ++i)
	{
		leerFitness(leerIndividuo(p, i)) = func_fitness(leerIndividuo(p, i), var,
														nvar, preci, liminf, limsup);
	}
}
/**********************************************************************/

void isBestHijo(float fitnessInd, float clasiRateIndE, float clasiRateIndV,
               int NfitEvalBest, int NinputInd, cromosoma c, float *fitnessBestAux,
               float *clasiRateBestAuxE, float *clasiRateBestAuxV,
               int *NfitEvalBestAux, int *NinputBestAux, char *cromoBestAux)
{               
	if( fitnessInd > (*fitnessBestAux) )
	{
		(*fitnessBestAux)    = fitnessInd;
		(*clasiRateBestAuxE) = clasiRateIndE;
		(*clasiRateBestAuxV) = clasiRateIndV;
		(*NfitEvalBestAux)   = NfitEvalBest;
		(*NinputBestAux)     = NinputInd;
		cromosoma2string(c, cromoBestAux);
    }
}

/**********************************************************************/

void evaluarPoblacionFeatureSelection(poblacion p, float (*func_fitness)
                    (cromosoma c, float **Input_E, float **Target_E, float **Input_V,
                    float **Target_V, float **Weight_IH, float **Weight_HO,
                    int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                    int Epochs, int valStep, float Epsi, float minError,
                    float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                    float *clasiRateE, float *clasiRateV, int *targetIdxE,
                    int *targetIdxV, float *qele, char *SimId, float costRatio,
                    int *NewNinput),
                    float **Input_E, float **Target_E, float **Input_V,
                    float **Target_V, float **Weight_IH, float **Weight_HO,
                    int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                    int Epochs, int valStep, float Epsi, float minError,
                    float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                    float *clasiRateE, float *clasiRateV, int *targetIdxE,
                    int *targetIdxV, float *qele, char *SimId, float costRatio,
                    int *NewNinput, float *fitnessBestGen, float *clasiRateBestGenE,
                    float *clasiRateBestGenV, int *NfitEvalBest, int *NinputBestGen,
                    char *cromoBestGen)
{
	int i;
	float clasiRateEi, clasiRateVi;

	for (i=0; i < p->tamano; ++i)
	{
		leerFitness(leerIndividuo(p, i)) = func_fitness(leerIndividuo(p, i), Input_E,
                  Target_E, Input_V, Target_V, Weight_IH, Weight_HO, Ntrain, Nval,
                  Ninput, Nhidden, Noutput, Epochs, valStep, Epsi, minError,
                  lambdaMax, lambdaMin, SseE, SseV, clasiRateE, clasiRateV,
                  targetIdxE, targetIdxV, qele, SimId, costRatio, NewNinput);

        clasiRateEi  = ( 100 * ((*clasiRateE) / (float)Ntrain) );
		clasiRateVi  = ( 100 * ((*clasiRateV) / (float)Nval) );
		
		isBestHijo(leerFitness(leerIndividuo(p, i)), clasiRateEi, clasiRateVi,
                   0, *NewNinput, leerIndividuo(p, i), fitnessBestGen,
                   clasiRateBestGenE, clasiRateBestGenV, NfitEvalBest,
                   NinputBestGen, cromoBestGen);
	}
}

/**********************************************************************/


