/*******************************************************************************
*																			   *	
*		Feature Selection by Genetic Algorithms and Mutual Information		   *	
*						Neural Net used "bpqgausql.h"						   *	
*																			   *
*								Michel Tesmer Tur							   *	
*							  mtesmer@ing.uchile.cl							   *	
*								    01/02/2004								   *	
*																			   *	
*******************************************************************************/


#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <float.h>
#include "memoria.h"
#include "matrix.h"
#include "cromosoma.h"
#include "poblacion.h"
#include "report.h"
#include "gamifs_fitness.h"
#include "crossover.h"
#include "mutacion.h"
#include "algoritmos_nichos.h"

/* Tipo de problema */
/* (TEST_PROBLEM -> Paridad 3, Breiman, Hypercube, Gaussian)
   (BENCHMARK -> otros feature selection problems) */

//#define TEST_PROBLEM
#define BENCHMARK


#ifdef TEST_PROBLEM
/* Nombre del archivo con las combinaciones de caracts optimas dispuestas como filas */
#define FNAME_TEST  	"test1_optimos.txt"
/* Funcion de de busqueda de optimos en la poblacion */
/* (isOptimoTest) (isOptimoCubo) (isOptimoMonks)o (isOptimoOneSolutionProblem) */	
#define FUNC_OPTIMUM    isOptimoTest       	
#define NOPTIMOS	    8						/* Numero de optimos (combinaciones) */
#define NFEATURES_TEST	9					    /* Largo de las combinaciones */
#define SAVEPOP_STEP	2						/* step para guardar la poblacion */
#define FPOP			"population_save"		/* Poblacion genotipica en generaciones */
#define FNICHOS			"ind_x_nichos"			/* Individuos por nichos en generaciones */
#endif

/* Constantes */
#define VAL_STEP			10
#define COST_RATIO			0.1f

/* Parametros por defecto */
#define I_WORD 				'\0'
#define SIZEPOP_DEF			100
#define MAXGEN_DEF			100
#define PCROSS_DEF			1.0f
#define PMUT_DEF			0.0f
#define EPOCHS_DEF			200
#define EPSI_DEF			0.005f

/* Nombre tipos de GA (Deterministic Crowding o GAMIFS) */
#define GA_DETCROWD_NAME	"Deterministic Crowding"
#define GA_GAMIFS_NAME		"GAMIFS"

/* Opcion tipos de GA */
#define GA_DETCROWD			0
#define GA_GAMIFS			1

/* Nombre tipos de inicializacion poblacion */
#define INI_ALEAT_NAME		"Inicializacion Aleatoria"
#define INI_RANK_NAME		"Inicializacion por Ranking AMIFS"

/* Opcion tipos de inicializacion poblacion */
#define INI_ALEAT			0
#define INI_RANK			1

/* Nombre tipos de seleccion */
#define SEL_PERMUT_NAME		"seleccionPermutacion"
#define SEL_ELIT_NAME		"seleccionElitista"

/* Opcion tipos de seleccion */
#define SEL_PERMUT			0
#define SEL_ELIT			1

/* Nombre tipos de crossover */
#define CROSS_BINO_NAME		"crossoverBinomial"
#define CROSS_UNIF_NAME		"crossoverUniforme"
#define CROSS_1P_NAME		"crossoverUnPunto"
#define CROSS_2P_NAME		"crossoverDosPuntos"

/* Opcion tipos de crossver */
#define CROSS_BINO			0
#define CROSS_UNIF			1
#define CROSS_1P			2
#define CROSS_2P			3

/* Nombre tipos de mutacion */
#define NOMUT_NAME			"No Mutation"
#define MUT_AMIFS_NAME		"mutacionAMIFS"
#define MUT_RANKAMIFS_NAME	"mutacionRankingAMIFS"
#define MUT_RANKMI_NAME	    "mutacionRankingMI"

/* Opcion tipos de mutacion */
#define NOMUT				0
#define MUT_AMIFS     		1
#define MUT_RANKAMIFS		2
#define MUT_RANKMI			3

#define FRAC_FIT_MUT		0.1f

/* Nombre de archivos de salida */
#define F_SETTINGS			"settings"
#define F_POPEVOL			"population_evol"
#define F_FITNESS			"fitnessBest_evol"
#define F_CROSSOVER			"crossover_evol"
#define F_MUTATION			"mutation_evol"
#define F_MUT_EFF			"mutation_eff"
#define F_STATUS			"status"

#define MAXNAME				150
#define INPUT_BIAS			1
#define HIDDEN_BIAS			1


/******************************************************/

void uso()
{
	printf("\n+---------------------------------------------------------+\n");
	printf("|          GAMIFS - Genetic Algorithm guided by           |\n");
    printf("|          Mutual Information Feature Selection           |\n");
	printf("|                                                         |\n");
	printf("|                   Michel Tesmer Tur                     |\n");
	printf("|                      01/02/2004                         |\n");
	printf("+---------------------------------------------------------+\n\n");
	
	printf("\nUso:\tgamifsbpq -a <GAType> -i <SimId> -b <Basename> -e <Ntrain>\n");
 	printf("                  -v <Nval>   -p <Ntest> -u <Ninput>   -h <Nhidden>\n");
  	printf("                  -o <Noutput> -c <Epochs> -s <Epsi> -z <SizePop>\n");
	printf("                  -g <MaxGen> -I <IniType> -P <PctjePop> -B <PctjeBits>\n");
    printf("                  -l <SelType> -x <CrossType> -r <Pcross> -m <MutType>\n");
	printf("                  -F <FracFitMut> -t <Pmut> -D <Pbbadd> -L <Pbbirrel>\n");
    printf("                  -R <CostRatio>  -k <FileRanking> -f <FileMiMatrix>\n");
	printf("                  -C <FileMIClases> -E <FileEntropy>\n\n");

	printf("-a <GAType>        : Tipo de Algoritmo Genetico\n");
	printf("                     <GAType> puede ser:\n");
	printf("                        0 Deterministic Crowding\n");
	printf("                        1 GAMIFS\n\n");
    printf("-i <SimId>         : Numero de 3 digitos identificador de la simulacion\n\n");
 	printf("-b <Basename>      : Nombre raiz del dataset (Ej. sonar_)\n\n");
 	printf("-e <Ntrain>        : Numero de ejemplos de entrenamiento\n\n");
 	printf("-v <Nval>          : Numero de ejemplos de validacion\n\n");
 	printf("-p <Ntest>         : Numero de ejemplos de test\n\n");
 	printf("-u <Ninput>        : Numero de unidades en la capa de entrada\n\n");
 	printf("-h <Nhidden>       : Numero de unidades en la capa oculta\n\n");
 	printf("-o <Noutput>       : Numero de unidades en la capa de salida\n\n");
	printf("-c <Epochs>        : Numero de epocas de entrenamiento\n\n");
	printf("-s <Epsi>          : Parametro de regularizacion del alg. BPQ\n\n");
	printf("-z <SizePop>       : Tamano de la poblacion del GA\n\n");
	printf("-g <MaxGen>        : Numero de generaciones del GA\n\n");
	printf("-I <IniType>       : Tipo de Inicializacion poblacion\n");
	printf("                     <IniType> puede ser:\n");
	printf("                        0 Aleatoria\n");
	printf("                        1 por Ranking AMIFS\n\n");
	printf("-P <PctjePop>      : Pctje poblacion inicializada por ranking [0,1]\n\n");
	printf("-B <PctjeBits>     : Pctje bits inicializados por ranking [0,1]\n\n");
	printf("-l <SelType>       : Tipo de Seleccion\n");
	printf("                     <SelType> puede ser:\n");
	printf("                        0 Permutacion\n");
	printf("                        1 Elitista\n\n");
	printf("-x <CrossType>     : Tipo de Crossover\n");
	printf("                     <CrossType> puede ser:\n");
	printf("                        0 Binomial\n");
	printf("                        1 Uniforme\n");
	printf("                        2 Un punto\n");
	printf("                        3 Dos puntos\n\n");
	printf("-r <Pcross>        : Probabilidad de crossover\n\n");
	printf("-m <MutType>       : Tipo de mutacion\n");
	printf("                     <MutType> puede ser:\n");
	printf("                        0 No mutacion\n");
	printf("                        1 Mutacion AMIFS\n");
	printf("                        2 Mutacion Ranking AMIFS\n");
	printf("                        3 Mutacion Ranking MI\n\n");
	printf("-F <FracFitMut>    : Fraccion de individuos que se mutaran\n");
	printf("-t <Pmut>          : Probabilidad de mutacion\n");
	printf("-D <Pbbadd>        : Probabilidad de agregar una caract\n");
	printf("-L <Pbbirrel>      : Probabilidad de eliminar una caract irrelevante\n");
	printf("-R <CostRatio>     : Penalizacion del N de entradas en Fitness\n");
	printf("-k <FileRanking>   : Archivo con ranking de caracts entregado por AMIFS\n");
	printf("-f <FileMIMatrix>  : Archivo con matriz de MI entre caracts (redundancia)\n");
	printf("-C <FileMIClases>  : Archivo con MI Clase-Caract\n");
	printf("-E <FileEntropy>   : Archivo con entropia de las caracts\n\n");
}

/**************************************************************/

/* Parsea el vector de argumentos y retorna la opci� */
int getoption(int option, char **argv)
{
	if (argv[option][0] == '-')
		return argv[option][1];
	else
		return I_WORD;
}

/**************************************************************/

int main(int argc, char **argv)
{
  
    /*********** Variables del GA ***********/
    int   GAType;				/* (0 -> DetCrowd) (1 -> GAMIFS) */
    char  *GAName;              /* Nombre del tipo de algoritmo genetico */
    char  SimId[5];				/* Identificador de la simulacion */
    int   SizePop;				/* Tamano de la poblacion */
    int   MaxGen; 				/* Generaciones del GA */
    int   SelType;   			/* Tipo de seleccion */
    char *SelName;		    	/* Nombre de la seleccion */
    int   CrossType;			/* Tipo de crossover */
    char *CrossName;			/* Nombre del crossover */
    void (*func_crossover)(cromosoma a, cromosoma b, cromosoma *c, cromosoma *d, float pbb);
    float Pcross;				/* Pbb de crossover */
    int   MutType;				/* Tipo de mutacion */
    char *MutName;   			/* Nombre de la mutacion */
    int (*func_mutacion)(cromosoma c, int *ranking, float **MIMatrix,
                         float *MIClases, float *Entropy, float *PbbMutVector,
                         float Pbbadd, float Pbbirrel, int *genmut);
    float fracFitMut;           /* Si fitness individuo > (fracFitMuT * MaxFit) -> Mutacion */              	
    float **mut_eff;
    float Pmut; 				/* Pbb de mutacion */
    float costRatio;			/* Parametro de regulacion del fitness */
    
    poblacion p;
    int i, j;
	time_t ti, tf;
	
	#ifdef TEST_PROBLEM
		char *fpop_name;
		char *fnichos_name;
		FILE *fpop;
		FILE *fnichos;
		int savepop_idx;
 		int **optimos;			/* Optimos del problema (NOPTIMOS x NFEATURES_TEST) */
	#endif
    /*********** Fin variables GA **********/
    
    /********** Variables para inicializacion  poblacion MI **********/
    int IniType;				/* Tipo de inicializacion poblacion */
    char *IniName;
    float pctje_pop;
    float pctje_bits;  
    /********** Fin variables inicializacion MI **********/
    
    /********** Variables para informacion mutua **********/
    char  *franking;
    char  *fMIMatrix;
    char  *fMIClases;
    char  *fEntropy;
    int   *ranking;
    float **MIMatrix;
    float *MIClases;
    float *Entropy;
    float *PbbMutVector;
    float Pbbadd;
    float Pbbirrel;
    /********** Fin variables informacion mutua **********/
        
    /********* Variables de la red neuronal *********/           	
    char  *Basename;			/* Nombre raiz del dataset (Ej. Sonar_) */
    int   Ntrain;				/* Numero ejemplos Entrenamiento */
    int   Nval;					/* Numero ejemplos Validacion */
    int   Ntest;  				/* Numero ejemplos Test */
    int   Ninput;				/* Numero entradas de la red */
    int   Nhidden;				/* Numero de unidades ocultas */
    int   Noutput;				/* Numero de salidas */
    int   Epochs;				/* Epocas de entrenamiento */	
    float Epsi;					/* Parametro de regularizacion del alg. BPQ */
    float **Input_E;			/* Matriz con conjunto de entrenamiento */
    float **Target_E;			/* Matriz con target de entrenamiento */
    float **Input_V;			/* Matriz con conjunto de validacion */
    float **Target_V;			/* Matriz con target de validacion */
    float **Input_P;			/* Matriz con conjunto de prueba */
    float **Target_P;			/* Matriz con target de prueba */
    float **Weight_IH;			/* Matriz de pesos Input -> Hidden */
    float **Weight_HO;			/* Matriz de pesos Hidden -> Output */
    
    int   NewNinput;			/* N de entradas seleccionadas por el GA */
    
    int   valStep     = VAL_STEP;		/* pasos entre validacion */
    float minError    = FLT_EPSILON;	/* Umbral para diferencia de errores */
    float lambdaMax   = 10.0f;			/* lambda maximo */
    float lambdaMin   = FLT_EPSILON;	/* lambda minimo */
    
    float SseE       = 0.0f;    /* Training SSE */
    float SseV       = 0.0f;	/* Validation SSE */
    float clasiRateE = 0.0f;	/* classification rate in training set */
    float clasiRateV = 0.0f;	/* classification rate in validation set */
    int   *targetIdxE;			/* Index of the target active neuron in train set*/
    int   *targetIdxV;			/* Index of the target active neuron in val set */
    float *qele;
    /********* Fin variables red neuronal **********/   
      
    /* Declaracion nombres archivos de salida */
    char *fsettings_name;
    char *fpop_evol_name;
    char *ffit_evol_name;
    char *fcross_evol_name;
    char *fmut_evol_name;
    char *fmut_eff_name;
    char *fstatus_name;
    /* Fin declaracion nombres archivos de salida */  
      
    /* Status de la simulaci� */
    int genIter = -1;  
      
    /* Declaracion punteros a archivos de salida */
    FILE *fsettings;
    FILE *fpop_evol;
    FILE *ffit_evol;
    FILE *fcross_evol;
    FILE *fmut_evol;
    FILE *fmut_eff;
    FILE *fstatus;
    /* Fin declaracion punteros archivos de salida */ 
    
    /* Variables para generacion de reportes */
    int bestGen;
    int NinputBestGen = 0;
    int NinputBestAll;
    int NfitEvalBest = 0;
    int NfitEvalBestAll;
    char *cromoBestGen;
    char *cromoBestAll;
    float fitnessBestGen = 0.0f;
    float fitnessBestAll = 0.0f;
    float clasiRateBestGenE = 0.0f;
    float clasiRateBestGenV = 0.0f;
    float clasiRateBestAllE, clasiRateBestAllV;
    int fitIncCross, fitIncMut;
    float fitDifCross, fitDifMut;
    int TotMut;
    mut_eff = matrizFloat(4, 3);
    /* Fin variables de reporte */      
        
    /* Setear valores por defecto */
    GAType    = GA_GAMIFS;
    GAName    = (char *) malloc(MAXNAME * sizeof(char));
    strcpy(GAName, GA_GAMIFS_NAME);
    IniType    = INI_ALEAT;
    IniName    = (char *) malloc(MAXNAME * sizeof(char));
    strcpy(IniName, INI_ALEAT_NAME);
    SizePop   = SIZEPOP_DEF;
    MaxGen    = MAXGEN_DEF;
    Epochs    = EPOCHS_DEF;
    Epsi      = EPSI_DEF;
    SelType   = SEL_PERMUT;
	SelName   = (char *) malloc(MAXNAME * sizeof(char));
	strcpy(SelName, SEL_PERMUT_NAME);
	CrossType = CROSS_BINO;
	CrossName = (char *) malloc(MAXNAME * sizeof(char));
	strcpy(CrossName, CROSS_BINO_NAME); 
    func_crossover = crossoverBinomial;
    Pcross    = PCROSS_DEF; 
    MutType   = NOMUT;
    MutName   = (char *) malloc(MAXNAME * sizeof(char));
    strcpy(MutName, NOMUT_NAME);
    func_mutacion = mutacionAMIFS;
    fracFitMut = FRAC_FIT_MUT; 
 	Pmut	  = PMUT_DEF;  
 	Ntest     = 0;
 	costRatio = COST_RATIO;
 	Basename  = (char *) malloc(MAXNAME * sizeof(char));
    /* Fin seteo valores por defecto */          
             
    /****************** Parsear la l�ea de comando *****************/
	for (i=1; i < argc; ++i)
	{
		switch(getoption(i, argv))
		{
		case I_WORD:
			uso();
			system("pause");
			return 0;
		case 'a':
			sscanf(argv[++i], "%d", &GAType);
			switch(GAType)
			{
			case GA_DETCROWD:
				strcpy(GAName, GA_DETCROWD_NAME);
				break;	
			case GA_GAMIFS:
				strcpy(GAName, GA_GAMIFS_NAME);
				break;
			}
			break;
		case 'I':
			sscanf(argv[++i], "%d", &IniType);
			switch(IniType)
			{
			case INI_ALEAT:
				strcpy(IniName, INI_ALEAT_NAME);
				break;	
			case INI_RANK:
				strcpy(IniName, INI_RANK_NAME);
				break;
			}
			break;
		case 'P':
			sscanf(argv[++i], "%f", &pctje_pop);
			break;
		case 'B':
			sscanf(argv[++i], "%f", &pctje_bits);
			break;
		case 'i':
			strcpy(SimId, argv[++i]);
			break;
		case 'b':
			strcpy(Basename, argv[++i]);
			break;
		case 'e':
			sscanf(argv[++i], "%d", &Ntrain);
			break;	
		case 'v':
			sscanf(argv[++i], "%d", &Nval);
			break;
   		case 'p':
			sscanf(argv[++i], "%d", &Ntest);
			break;
		case 'u':
			sscanf(argv[++i], "%d", &Ninput);
			break;
		case 'h':
			sscanf(argv[++i], "%d", &Nhidden);
			break;	
    	case 'o':
			sscanf(argv[++i], "%d", &Noutput);
			break;
    	case 'c':
			sscanf(argv[++i], "%d", &Epochs);
			break;
		case 's':
			sscanf(argv[++i], "%f", &Epsi);
			break;
		case 'z':
			sscanf(argv[++i], "%d", &SizePop);
			break;
		case 'g':
			sscanf(argv[++i], "%d", &MaxGen);
			break;
		case 'l':
			sscanf(argv[++i], "%d", &SelType);
			switch(SelType)
			{
			case SEL_PERMUT:
				strcpy(SelName, SEL_PERMUT_NAME);
				break;	
			case SEL_ELIT:
				strcpy(SelName, SEL_ELIT_NAME);
				break;
			}
			break;
		case 'x':
			sscanf(argv[++i], "%d", &CrossType);
			switch(CrossType)
			{
			case CROSS_BINO:
				strcpy(CrossName, CROSS_BINO_NAME);
				func_crossover = crossoverBinomial;
				break;	
			case CROSS_UNIF:
				strcpy(CrossName, CROSS_UNIF_NAME);
				func_crossover = crossoverUniforme;
				break;	
			case CROSS_1P:
				strcpy(CrossName, CROSS_1P_NAME);
				func_crossover = crossoverUnPunto;
				break;
			case CROSS_2P:
				strcpy(CrossName, CROSS_2P_NAME);
				func_crossover = crossoverDosPuntos;
				break;
			}
			break;
		case 'r':
			sscanf(argv[++i], "%f", &Pcross);
			break;
		case 'm':
			sscanf(argv[++i], "%d", &MutType);
			switch(MutType)
			{
			case MUT_AMIFS:
				strcpy(MutName, MUT_AMIFS_NAME);
				func_mutacion = mutacionAMIFS;
				break;	
			case MUT_RANKAMIFS:
				strcpy(MutName, MUT_RANKAMIFS_NAME);
				func_mutacion = mutacionRankingAMIFS;
				break;
			case MUT_RANKMI:
				strcpy(MutName, MUT_RANKMI_NAME);
				func_mutacion = mutacionRankingMI;
				break;
			}
			break;
		case 'F':
			sscanf(argv[++i], "%f", &fracFitMut);
			break;
		case 't':
			sscanf(argv[++i], "%f", &Pmut);
			break;
		case 'D':
			sscanf(argv[++i], "%f", &Pbbadd);
			break;
		case 'L':
			sscanf(argv[++i], "%f", &Pbbirrel);
			break;
		case 'R':
			sscanf(argv[++i], "%f", &costRatio);
			break;
		case 'k':
			franking = (char *) malloc(MAXNAME * sizeof(char));
			strcpy(franking, argv[++i]);
			break;
		case 'f':
			fMIMatrix = (char *) malloc(MAXNAME * sizeof(char));
			strcpy(fMIMatrix, argv[++i]);
			break;
		case 'C':
			fMIClases = (char *) malloc(MAXNAME * sizeof(char));
			strcpy(fMIClases, argv[++i]);
			break;
		case 'E':
			fEntropy = (char *) malloc(MAXNAME * sizeof(char));
			strcpy(fEntropy, argv[++i]);
			break;
		default:
			break;
		}
	}
    /****************** Fin parseo linea de comando ***************/      
             
    /* Presentacion del programa */
    printf("\n+---------------------------------------------------------+\n");
	printf("|          GAMIFS - Genetic Algorithm guided by           |\n");
    printf("|          Mutual Information Feature Selection           |\n");
	printf("|                                                         |\n");
	printf("|                   Michel Tesmer Tur                     |\n");
	printf("|                      01/02/2004                         |\n");
	printf("+---------------------------------------------------------+\n\n");
    /* Fin presentacion programa */ 
    
    /* Inicializacion de semilla */
    seed();       
                     
    /******************* Cargando bases de patrones y targets ***************/
    printf("\nCargando patrones...\n");
    
    /* Entrenamiento */
    Input_E  = loadBase(Basename, Ntrain, Ninput, 'e');
    Target_E = loadTarget(Basename, Ntrain, Noutput, 'e');   
           
    /* Validacion */                                                           
    Input_V  = loadBase(Basename, Nval, Ninput, 'v');
    Target_V = loadTarget(Basename, Nval, Noutput, 'v'); 
    
    /* Prueba */
    if(Ntest > 0)
    {                                                           
    	Input_P  = loadBase(Basename, Nval, Ninput, 'p');
        Target_P = loadTarget(Basename, Nval, Noutput, 'p');          
    }
    
    /* Reserva de memoria */
    Weight_IH    = matrizFloat( (Ninput+INPUT_BIAS), Nhidden );
    Weight_HO    = matrizFloat( (Nhidden+HIDDEN_BIAS), Noutput );
    targetIdxE   = vectorInt(Ntrain);
    targetIdxV   = vectorInt(Nval);
    cromoBestGen = (char *) malloc((Ninput+1) * sizeof(char));
    cromoBestAll = (char *) malloc((Ninput+1) * sizeof(char));
    strcpy(cromoBestGen, "0");
    /* Fin reserva de memoria */

    /* Inicializacion de vector de indices de clases en target*/
    for(i=0; i < Ntrain; i++)
		for(j=0; j < Noutput; j++)
			if(Target_E[i][j] == 1)
				targetIdxE[i] = j;
				
	for(i=0; i < Nval; i++)
		for(j=0; j < Noutput; j++)
			if(Target_V[i][j] == 1)
				targetIdxV[i] = j;
    /* Fin inicializacion vector indices de clases en target */                  
    
    /*********************** Fin cargar patrones *********************/ 
  
    /* Nombre de archivos de salida */
    fsettings_name   = buildFileName(F_SETTINGS, SimId);
    fpop_evol_name   = buildFileName(F_POPEVOL, SimId);
    ffit_evol_name   = buildFileName(F_FITNESS, SimId);
    fcross_evol_name = buildFileName(F_CROSSOVER, SimId);
    fmut_evol_name   = buildFileName(F_MUTATION, SimId);
    fmut_eff_name    = buildFileName(F_MUT_EFF, SimId);
    fstatus_name     = buildFileName(F_STATUS, SimId);
    /* Fin nombre de archivos de salida */
    
    /* Status de la simulacion anterior */
    #ifdef TEST_PROBLEM
    	fstatus = fopen(fstatus_name, "r");
	    fscanf(fstatus, "%d", &genIter);
	    fclose(fstatus);
    #endif
    /* Fin status simulacion anterior */
    
    #ifdef BENCHMARK
    	fsettings   = fopen(fsettings_name, "w");  
    	fpop_evol   = fopen(fpop_evol_name, "w");
	    ffit_evol   = fopen(ffit_evol_name, "w");
    	fcross_evol = fopen(fcross_evol_name, "w");
	    fmut_evol   = fopen(fmut_evol_name, "w");
    	fmut_eff    = fopen(fmut_eff_name, "w");
    #endif
  
    /************************ Inicio GA **************************/
    p = NULL; 
	
	/* Mutacion por informacion mutua */
	if(MutType != NOMUT)
	{	
		ranking  = vectorInt(Ninput);
		MIMatrix = matrizFloat(Ninput, Ninput);
		MIClases = vectorFloat(Ninput);
		Entropy  = vectorFloat(Ninput);
		PbbMutVector = vectorFloat(Ninput);
		loadRanking(franking, ranking, Ninput);
		loadMatrix(fMIMatrix, MIMatrix, Ninput, Ninput);
		loadVectorFloat(fMIClases, MIClases, Ninput);
		loadVectorFloat(fEntropy, Entropy, Ninput);
		
		if(MutType != 1)
		{
			//pbbMutacionLineal(ranking, PbbMutVector, 0.98, 0.1, Ninput);
			//pbbMutacionExponencial(ranking, PbbMutVector, Pb, Pw, Ninput);
			pbbMutacionExponencialPartes(ranking, PbbMutVector, 1.0f, 0.5f, 0.15f, Ninput);
		}
 	}
 	else if(IniType == 1)			/* Inicializacion poblacion por ranking AMIFS */
 	{
  		ranking  = vectorInt(Ninput);
  		loadRanking(franking, ranking, Ninput);
  	}
       
    /* Tiempo de inicio de la simulacion */
	(void) time(&ti);

	/* Creando poblacion */
	if(genIter <= 0)
	{
		if(IniType == 0)
		{
			p = nuevaPoblacion(SizePop, Ninput);
		}
		else
		{
			p = nuevaPoblacionRankingAMIFS(SizePop, Ninput, ranking, pctje_pop,
	                                       pctje_bits);
	 	}
 	}
 	else if(genIter == MaxGen)
 	{
 		printf("\nSimulacion %s Finalizada (Generacion %d)\n\n", SimId, MaxGen);
 		system("pause");
 		return 0;
  	}
	
	#ifdef TEST_PROBLEM
  	if((genIter > 0) && (genIter < MaxGen))
  	{
  		fpop_name = buildFileName(FPOP, SimId);
   		p = nuevaPoblacionFromLastSimulation(fpop_name, genIter, SizePop, Ninput);
   	}
 	#endif
	
 	#ifdef TEST_PROBLEM	
	fpop_name    = buildFileName(FPOP, SimId);
    fpop         = fopen(fpop_name, "a");
    fnichos_name = buildFileName(FNICHOS, SimId);
    fnichos      = fopen(fnichos_name, "a");
    if(genIter == 0)
    {
    	savepop_idx = SAVEPOP_STEP;
	}
 	else
 	{
    	savepop_idx = (genIter + 1);
	}
 	optimos      = loadOptimos(FNAME_TEST, NOPTIMOS, NFEATURES_TEST);
	#endif

	printf("\nEvaluando poblacion inicial...\n");
	evaluarPoblacionFeatureSelection(p, gamifsFitness, Input_E, Target_E, Input_V,
                  Target_V, Weight_IH, Weight_HO, Ntrain, Nval, Ninput, Nhidden,
                  Noutput, Epochs, valStep, Epsi, minError, lambdaMax, lambdaMin,
                  &SseE, &SseV, &clasiRateE, &clasiRateV, targetIdxE, targetIdxV,
                  qele, SimId, costRatio, &NewNinput, &fitnessBestGen,
                  &clasiRateBestGenE, &clasiRateBestGenV, &NfitEvalBest,
                  &NinputBestGen, cromoBestGen);   
              
    isBestAll(fitnessBestGen, clasiRateBestGenE, clasiRateBestGenV, NfitEvalBest,
              NinputBestGen, cromoBestGen, i, &fitnessBestAll, &clasiRateBestAllE,
              &clasiRateBestAllV, &NfitEvalBestAll, &NinputBestAll, cromoBestAll,
              &bestGen);                                                                                    

    /************** Loop de evolucion del GA *****************/
    printf("\nCorriendo Algoritmo Genetico...\n\n");
    
    if(genIter <= 0)
    {
    	printf("Gen=%3d FitB=%4.3f PctE=%7.3f PctV=%7.3f Nf=%3d\n", 0, fitnessBestGen,
            	clasiRateBestGenE, clasiRateBestGenV, NinputBestGen);    
   	}
   	else
   	{
   		printf("Gen=%3d FitB=%4.3f PctE=%7.3f PctV=%7.3f Nf=%3d\n", genIter,
                fitnessBestGen, clasiRateBestGenE, clasiRateBestGenV, NinputBestGen);
    }
    
    #ifdef BENCHMARK
    	genIter = 0;
   	#endif

    for(i=(genIter+1); i <= MaxGen; i++)
    {
    	if(GAType == 0)
     	{
     		DeterministicCrowdingFeatureSelection(p, gamifsFitness, func_crossover, 
					 distanciaHammingFeatureSelection, Input_E, Target_E, Input_V,
                     Target_V, Weight_IH, Weight_HO, Ntrain, Nval, Ninput, Nhidden,
                     Noutput, Epochs, valStep, Epsi, minError, lambdaMax, lambdaMin,
                     &SseE, &SseV, &clasiRateE, &clasiRateV, targetIdxE, targetIdxV,
                     qele, SimId, costRatio, &NewNinput, Pcross, &fitnessBestGen,
                     &clasiRateBestGenE, &clasiRateBestGenV, &NfitEvalBest,
                     &NinputBestGen, cromoBestGen, &fitIncCross, &fitDifCross);
         }
         else
         {
         	DeterministicCrowdingGAMIFS(p, gamifsFitness, func_crossover, 
					 func_mutacion, distanciaHammingFeatureSelection, Input_E,
                     Target_E, Input_V, Target_V, Weight_IH, Weight_HO, Ntrain,
                     Nval, Ninput, Nhidden, Noutput, Epochs, valStep, Epsi,
                     minError, lambdaMax, lambdaMin, &SseE, &SseV, &clasiRateE,
                     &clasiRateV, targetIdxE, targetIdxV, qele, SimId, costRatio,
                     &NewNinput, MutType, &fitnessBestGen, &clasiRateBestGenE,
                     &clasiRateBestGenV, &NfitEvalBest, &NinputBestGen,
                     cromoBestGen, &fitIncCross, &fitDifCross, &fitIncMut,
                     &fitDifMut, &TotMut, SelType, ranking, MIMatrix, MIClases,
                     Entropy, PbbMutVector, Pbbadd, Pbbirrel, fracFitMut, mut_eff);
         }  
         
        /* Tiempo final de la simulacion */
		(void) time(&tf);                       
        
        /* Mejor individuo de la generacion es mejor que el mejor global? */
        isBestAll(fitnessBestGen, clasiRateBestGenE, clasiRateBestGenV, NfitEvalBest,
                  NinputBestGen, cromoBestGen, i, &fitnessBestAll,
                  &clasiRateBestAllE, &clasiRateBestAllV, &NfitEvalBestAll,
                  &NinputBestAll, cromoBestAll, &bestGen);
                  
        /* Abrir archivos de salida */
        #ifdef TEST_PROBLEM
        	fsettings   = fopen(fsettings_name, "w");  
	    	fpop_evol   = fopen(fpop_evol_name, "a");
		    ffit_evol   = fopen(ffit_evol_name, "a");
	    	fcross_evol = fopen(fcross_evol_name, "a");
		    fmut_evol   = fopen(fmut_evol_name, "a");
	    	fmut_eff    = fopen(fmut_eff_name, "a");
		    fstatus     = fopen(fstatus_name, "w");
		#endif
		
		/* Fitness, best, worst, avg, std -> archivo de salida */		
		estadisticasPoblacionFeatureSelection(p, fpop_evol, i);

		/* Escritura de archivo de evolucion del fitness */
		writeOutFileFitness(ffit_evol, i, NinputBestGen, fitnessBestGen,
                            clasiRateBestGenE, clasiRateBestGenV, NfitEvalBest,
                            cromoBestGen);
                   
        /* Escritura de archivo de evolucion del crossover */                                      
        writeOutFileCrossover(fcross_evol, i, fitIncCross, fitDifCross, SizePop);
      
        /* Escritura de archivo de eficiencia de la mutacion */                                      
        writeOutFileMutacionEff(fmut_eff, i, fitIncMut, fitDifMut, TotMut, mut_eff);
        
     	/* Escritura de archivo de settings */
     	#ifdef TEST_PROBLEM
     		writeOutFileSettings(fsettings, SimId, ti, tf, Basename, Ntrain,
        			Nval, Ninput, Nhidden, Noutput, Epochs, Epsi, MaxGen, SizePop,
                    GAName, IniName, pctje_pop, pctje_bits, SelName, Pcross, MutName,
                    Pmut, fracFitMut, Pbbadd, Pbbirrel, bestGen, fitnessBestAll,
                    clasiRateBestAllE, clasiRateBestAllV, NfitEvalBestAll,
                    NinputBestAll, cromoBestAll);
        #endif

		/* Guardar poblacion para problemas de test */
		#ifdef TEST_PROBLEM
			if (i == savepop_idx)
			{	
				guardarPoblacionFeatureSelection(p, i, FUNC_OPTIMUM, optimos,
                                                 NOPTIMOS, NFEATURES_TEST, fpop,
                                                 fnichos);
				savepop_idx += SAVEPOP_STEP;
				fprintf(fstatus, "%d", i);
			}
		
			fclose(fsettings);
	    	fclose(fpop_evol);
		    fclose(ffit_evol);
		    fclose(fcross_evol);
		    fclose(fmut_evol);
		    fclose(fmut_eff);
	    	fclose(fstatus);
    	#endif

		/* Despliegue en pantalla de evolucion de  la poblacion */
		/* Gen - FitBest - PctBestE - PctBestV - NinputBest */
		printf("Gen=%3d FitB=%4.3f PctE=%7.3f PctV=%7.3f Nf=%3d\n", i, fitnessBestGen,
                clasiRateBestGenE, clasiRateBestGenV, NinputBestGen);
    }
    printf("\n");
    /***************************** Fin Loop *******************************/
    
    #ifdef BENCHMARK
    	writeOutFileSettings(fsettings, SimId, ti, tf, Basename, Ntrain,
        			Nval, Ninput, Nhidden, Noutput, Epochs, Epsi, MaxGen, SizePop,
                    GAName, IniName, pctje_pop, pctje_bits, SelName, Pcross, MutName,
                    Pmut, fracFitMut, Pbbadd, Pbbirrel, bestGen, fitnessBestAll,
                    clasiRateBestAllE, clasiRateBestAllV, NfitEvalBestAll,
                    NinputBestAll, cromoBestAll);
    #endif 
					   
    /*********************** Fin GA *************************/                                                                                                                                  

    /* Liberacion de memoria */
    destruirPoblacion(p);
    free(Basename);
    free(SelName);
    free(CrossName);
    free(MutName);
    free(cromoBestGen);
    free(cromoBestAll);
    borrarMatrizFloat(Input_E, Ntrain);
    borrarMatrizFloat(Input_V, Nval);
    borrarMatrizFloat(Target_E, Ntrain);
    borrarMatrizFloat(Target_V, Nval);
    borrarMatrizFloat(Weight_IH, (Ninput+INPUT_BIAS));
    borrarMatrizFloat(Weight_HO, (Nhidden+HIDDEN_BIAS));
    borrarMatrizFloat(mut_eff, 4);
    free(targetIdxE);
    free(targetIdxV);
    free(fsettings_name);
    free(fpop_evol_name);
    free(ffit_evol_name);
    free(fcross_evol_name);
    free(fmut_evol_name);
    free(fmut_eff_name);
    free(fstatus_name);
    #ifdef BENCHMARK
    	fclose(fsettings);
	    fclose(fpop_evol);
		fclose(ffit_evol);
		fclose(fcross_evol);
		fclose(fmut_evol);
		fclose(fmut_eff);
    #endif
    if(MutType != NOMUT)
	{	
		free(ranking);
		borrarMatrizFloat(MIMatrix, Ninput);
		free(MIClases);
		free(Entropy);
		free(PbbMutVector);
		free(franking);
		free(fMIMatrix);
		free(fMIClases);
		free(fEntropy);
 	}
    #ifdef TEST_PROBLEM
    	fclose(fnichos);
    	fclose(fpop);
 		borrarMatrizInt(optimos, NOPTIMOS);
    #endif
    /* Fin Liberacion de memoria */

    system("pause");
  	return 0;
}
