/***********************************************************************
*                             "cromosoma.h"	   						   *
* Definicion de la estructura cromosoma y las operaciones sobre esta   *
***********************************************************************/

struct genotipo 						// Nuevo tipo de variable  
{										// genotipo
	int largo;
    unsigned *cromo;					                  
    float   fitness;                     
};							

typedef struct genotipo *cromosoma;		// puntero a la estrucutura 

/******************* Operaciones sobre cromosomas ******************/

/* pone en 1 el bit n del cromosoma c */
#define set1(c, n) ((c)->cromo[(n)] = 1) 

/* pone en 0 el bit n del cromosoma c */
#define set0(c, n) ((c)->cromo[(n)] = 0)

/* extrae el gen n del cromosoma c */		
#define leerGen(c, n)  ((c)->cromo[(n)])

/* Establece el fitness del cromosoma c en el valor f */
#define asignarFitness(c, f)	((c)->fitness = (f))

/* Lee el fitness del cromosoma c */
#define leerFitness(c)	((c)->fitness)

/* Lee el largo del cromosoma c */
#define leerLargo(c)	((c)->largo)

/* crear un cromosoma nuevo */
cromosoma nuevoCromosoma(int largo);

/* Crear un cromosoma nuevo con bits inicializados de acorde al ranking
   de caracts entregado por AMIFS. "pctje_bits" corresponde al porcentaje de
   bits del total que seran inicializados segun el ranking.
   (Ej. pctje_bits = 0.1, largo = 20, significa que el 10% de los bits
   (2 caracts del ranking) seran inicilizadas como 1. */
cromosoma nuevoCromosomaRankingAMIFS(int largo, int *ranking, float pctje_bits);

/* Copia cromosoma de la ultima poblacion guardada en la simulacion anterior */
cromosoma nuevoCromosomaFromLastPopulation(FILE *fpop, int largo);

/* destruir un cromosoma */
void destruirCromosoma(cromosoma c);

/* copiar un cromosoma f en d */
void copiarCromosoma(cromosoma d, cromosoma f);

/* duplicar un cromosoma */
cromosoma duplicarCromosoma(cromosoma f);

/* intercambia el gen n de los cromosomas a y b */
void swapGen(cromosoma a, cromosoma b, int n);

/* copia el contenido del cromosoma en una cadena de caracteres */
void cromosoma2string(cromosoma c, char *s);

/* Decodifica un cromosoma entregtando un vector con las variables */
void decode(cromosoma c, float *var, int nvar, int preci, float liminf,
			float limsup);

/* Calcula la distancia de Hamming entre 2 cromosomas */
float distanciaHamming(cromosoma a, cromosoma b, 
					   int nvar, int preci, float liminf, float limsup);

/* Calcula la distancia de Hamming entre 2 cromosomas para el problema de
   Seleccion de Caracteristicas*/					   
float distanciaHammingFeatureSelection(cromosoma a, cromosoma b);					   
 
/* Calcula la distancia entre 2 vectores como la generalizacion de la distancia Euclidiana */
float distanciaEuclidiana(cromosoma a, cromosoma b, int nvar, int preci, 
						  float liminf, float limsup);

/* Intercambia 2 elementos de cualquier tipo */
void swap(const void **a, const void **b);

/* Verifica si un individuo se encuentra en una vecindad a un punto (Verificacion de mantencion de nichos) */
int individuosPorNicho(float *var, float *puntos, float radio, int nvar);

/* Compara 2 cromosomas segun fitness para aplicar "qsort"*/
int compara(const void *x, const void *y);
