
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include "cromosoma.h"
#include "poblacion.h"

#define MAXNAME		100


/**********************************************************************/

void menu(int *algtype, int *seltype, int puntos, int nvar, float *optimos1, 
		  float **optimosn)
{
	int i, j;
	
	/* Inicio del Programa */

	printf("	 *********************************************************\n");
	printf("	 *						  	 *\n");
	printf("	 *         Toolbox de Algoritmos Geneticos en C          *\n");
	printf("	 *		           MYGA	     	                 *\n");
	printf("	 *	    desarrollado por Michel Tesmer Tur           *\n");
	printf("	 *		 micheltesmer@hotmail.com 	         *\n");
	printf("	 *		        28-08-2002	    	         *\n");
	printf("	 *							 *\n");
	printf("	 *********************************************************\n");

	printf("\n *******************************  IMPORTANTE  *******************************\n");
	printf("\n Seleccione al inicio del codigo las opciones y parametros que desea utilizar\n");
	printf("\n ****************************************************************************\n");

	printf("\n Seleccione el tipo de algoritmo que desea utilizar:\n\n");
	printf("	(1)  Algoritmo Genetico Simple\n");
	printf("	(2)  Sharing\n");
	printf("	(3)  Deterministic Crowding\n");
	printf("	>>");
	scanf("%d", algtype);

	if(*algtype == 1)
	{
		printf("\n Seleccione el metodo de seleccion que desea utilizar:\n\n");
		printf("	(1)  Ruleta\n");
		printf("	(2)  SUS\n");
		printf("	(3)  Torneo\n");
		printf("	(4)  Ranking / Ruleta\n");
		printf("	(5)  Ranking / SUS\n");
		printf("	>>");
		scanf("%d", seltype);
	}
	
	if(*algtype == 2)
	{
		printf("\n Seleccione el metodo de seleccion que desea utilizar:\n\n");
		printf("	(1)  Sharing / Ruleta\n");
		printf("	(2)  Sharing / SUS\n");
		printf("	(3)  Sharing / Ranking / Ruleta\n");
		printf("	(4)  Sharing / Ranking / SUS\n");
		printf("	(5)  Sharing / Torneo\n");
		printf("	>>");
		scanf("%d", seltype);
	}


	/* Puntos optimos */
	printf("\n\n A continuacion ingrese los puntos optimos\n");
	printf(" de la funcion que desea optimizar.\n\n");
	printf(" * Deben ser ingresadas todas las componentes   *\n");
	printf(" * de cada punto antes de ingresar el siguiente *\n");
	for(i=0; i<puntos; i++)
	{
		printf("\n Ingrese punto optimo %d:\n", i+1);
		if(nvar != 1)
		{
			for(j=0; j<nvar; j++)
			{
				printf(" Componente %d: ", j+1);
				scanf("%f", &(optimosn[i][j]));
			}
		}
		else
		{
			printf(" ");
			scanf("%f", &(optimos1[i]));
		}
	}
}

/**********************************************************************/

void estadisticasPoblacion(poblacion p, float *best, float *worst, 
						   float *avg, int probtype)
{
	int i;

	*best = leerFitness(leerIndividuo(p, 0));
	*worst  = leerFitness(leerIndividuo(p, 0));
	
	for (i=0; i<p->tamano; ++i)
	{
		*avg += leerFitness(leerIndividuo(p, i));
		if(probtype == 1)
		{
			if ( *best < leerFitness(leerIndividuo(p, i)) )
				*best = leerFitness(leerIndividuo(p, i));
			if ( *worst  > leerFitness(leerIndividuo(p, i)) )
				*worst = leerFitness(leerIndividuo(p, i));
		}
		else
		{
			if ( *best > leerFitness(leerIndividuo(p, i)) )
				*best = leerFitness(leerIndividuo(p, i));
			if ( *worst  < leerFitness(leerIndividuo(p, i)) )
				*worst = leerFitness(leerIndividuo(p, i));
		}
	}
	*avg /= p->tamano;
}

/**********************************************************************/

void guardarPoblacionNichos(poblacion p, float *var, float *ptos, 
							int sizepop, int nvar, int preci, float liminf, 
							float limsup, float radio, int puntos, int cont, 
							float **pop1, float ***popn, float *optimos1, 
							float **optimosn, int **nichos)
{
	int j, k, l, m;

	for(j=0; j<p->tamano; j++)
	{
		decode(leerIndividuo(p, j), var, nvar, preci, liminf, limsup);
		/* Se guarda el individuo de la poblacion */
		for(k=0; k<nvar; k++)
		{
			if(nvar != 1)
			{
				popn[j][k][cont] = var[k];
			}
			else
			{
				pop1[cont][j] = var[k];
			}
		}
		/* Calculo de individuos por nicho */
		for(l=0; l<puntos; l++)
		{
			for(m=0; m<nvar; m++)
			{
				if(nvar != 1)
				{
					ptos[m] = optimosn[l][m];
				}
				else
				{
					ptos[m] = optimos1[l];
				}
			}
			if(individuosPorNicho(var, ptos, radio, nvar))
				nichos[cont][l]++;
		}
	}
}

/**********************************************************************/

void archivosResultados(time_t ti, time_t tf, int tiempo, int fitness_func,
						int algtype, int seltype, int crosstype_func,
						int sizepop, int maxgen, int repeat, int preci,
						float pcross, float pmut, float *bestvector, 
						float *worstvector, float *avgvector, int nvar,
						float **pop1, float ***popn, int puntos, int **nichos)

{
	int i, j, k;
	FILE *out0, *out1, *out2, *out3;

	out0 = fopen("settings.txt", "w");
	out1 = fopen("estadisticas.txt", "w");
	out2 = fopen("poblacion.txt", "w");
	out3 = fopen("nichos.txt", "w");

	/* Escritura de archivo con settings */
	fprintf(out0, "Settings de la Simulacion\n\n");
	fprintf(out0, "Tiempo inicial:\t\t\t%s", ctime(&ti));
	fprintf(out0, "Tiempo final:\t\t\t%s", ctime(&tf));
	fprintf(out0, "Tiempo total [s]:\t\t%d\n", tiempo);
	
	if (fitness_func == 1)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion Esfera");
	else if (fitness_func == 2)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion Sombrero Mexicano");
	else if (fitness_func == 3)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion Rosenbrock's Valley (Banana)");
	else if (fitness_func == 4)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion de Ackley");
	else if (fitness_func == 5)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion de Bohachevsky");
	else if (fitness_func == 6)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion de Rastrigin");
	else if (fitness_func == 7)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion de Schafer");
	else if (fitness_func == 8)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion de Schwefel");
	else if (fitness_func == 9)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion de Seno Atenuado con peaks de anchos iguales");
	else if (fitness_func == 10)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion de Seno Atenuado con peaks de anchos distintos");
	else if (fitness_func == 11)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion Peaks");
	else if (fitness_func == 12)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion Basins");
	else if (fitness_func == 13)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion de Griewangk");
	else if (fitness_func == 14)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion Foxholes de Schekel");
	else if (fitness_func == 15)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion Six Hump Camel Back");
	else if (fitness_func == 16)
		fprintf(out0, "Funcion de fitness:\t\t%s\n", "Funcion de Himmelblau");
	

	if (algtype == 3)
		fprintf(out0, "Tipo de algoritmo:\t\t%s\n", "Deterministic Crowding");
	else if (algtype == 1 && seltype == 1)
		fprintf(out0, "Tipo de algoritmo:\t\t%s\n", "SGA / Ruleta");
	else if (algtype == 1 && seltype == 2)
		fprintf(out0, "Tipo de algoritmo:\t\t%s\n", "SGA / SUS");
	else if (algtype == 1 && seltype == 3)
		fprintf(out0, "Tipo de algoritmo:\t\t%s\n", "SGA / Torneo");
	else if (algtype == 1 && seltype == 4)
		fprintf(out0, "Tipo de algoritmo:\t\t%s\n", "SGA / Ranking / Ruleta");
	else if (algtype == 1 && seltype == 5)
		fprintf(out0, "Tipo de algoritmo:\t\t%s\n", "SGA / Ranking / SUS");
	else if (algtype == 2 && seltype == 1)
		fprintf(out0, "Tipo de algoritmo:\t\t%s\n", "Sharing / Ruleta");
	else if (algtype == 2 && seltype == 2)
		fprintf(out0, "Tipo de algoritmo:\t\t%s\n", "Sharing / SUS");
	else if (algtype == 2 && seltype == 3)
		fprintf(out0, "Tipo de algoritmo:\t\t%s\n", "Sharing / Ranking / Ruleta");
	else if (algtype == 2 && seltype == 4)
		fprintf(out0, "Tipo de algoritmo:\t\t%s\n", "Sharing / Ranking / SUS");
	else if (algtype == 2 && seltype == 5)
		fprintf(out0, "Tipo de algoritmo:\t\t%s\n", "Sharing / Torneo");


	if (crosstype_func == 1)
		fprintf(out0, "Tipo de crossover:\t\t%s\n", "Crossover de Un Punto");
	else if (crosstype_func == 2)
		fprintf(out0, "Tipo de crossover:\t\t%s\n", "Crossover de Dos Puntos");
	else if (crosstype_func == 3)
		fprintf(out0, "Tipo de crossover:\t\t%s\n", "Crossover Uniforme");
	else if (crosstype_func == 4)
		fprintf(out0, "Tipo de crossover:\t\t%s\n", "Crossover Binomial");

	fprintf(out0, "Tamano de la poblacion:\t\t%d\n", sizepop);
	fprintf(out0, "Numero de generaciones:\t\t%d\n", maxgen);
	fprintf(out0, "Numero de repeticiones:\t\t%d\n", repeat);
	fprintf(out0, "Precision por variable [bits]:\t%d\n", preci);
	fprintf(out0, "Probabilidad de crossover:\t%5.4f\n", pcross);
	fprintf(out0, "Probabilidad de mutacion:\t%5.4f\n", pmut);


	/* Impresion de estadisticas de la poblacion */
	for (i=0; i<maxgen; ++i)
	{
		if(i == 0)
		{
			fprintf(out1, "Estadisticas de la Poblacion\n\n");
			fprintf(out1, "Gen\tMejor\t\tPeor\t\tPromedio\n\n");
		}
		fprintf(out1, "%d\t%f\t%f\t%f\n", i+1, bestvector[i], worstvector[i], avgvector[i]);
	}
	
	/* Impresion de poblaciones */
	for(i=0; i<3; i++)
	{
		if(i == 0)
		{
			fprintf(out2, "Poblacion\n\n");
			for(j=0; j<nvar; j++)
			{	
				if(j == 0)
					fprintf(out2, "Gen\tX%d\t\t", j+1);
				else
					fprintf(out2, "X%d\t\t", j+1);
			}
			fprintf(out2, "\n\n");
		}
		for(j=0; j<sizepop; j++)
		{
			fprintf(out2, "%d\t", j+1);
			for(k=0; k<nvar; k++)
			{
				if(nvar != 1)
				{
					fprintf(out2, "%f\t", popn[j][k][i]);
				}
				else
				{
					fprintf(out2, "%f\t", pop1[i][j]);
				}
			}
			fprintf(out2, "\n");
		}
		fprintf(out2, "\n");
	}

	/* Impresion de individuos por nichos */
	for(i=0; i<3; i++)
	{
		if(i == 0)
		{
			fprintf(out3, "Numero de Individuos por Nicho\n\n");
			for(j=0; j<puntos; j++)
				fprintf(out3, "Nicho.%d\t", j+1);
			fprintf(out3, "\n\n");
		}
		for(j=0; j<puntos; j++)
			fprintf(out3, "%d\t", nichos[i][j]);
		fprintf(out3, "\n\n");
	}

	fclose(out0);
	fclose(out1);
	fclose(out2);
	fclose(out3);
}


/******************************************************************************/
/************************** Feature Selection Routines ************************/
/******************************************************************************/

char *buildFileName(char *rootname, char *extention)
{
	char *filename;

	filename = (char *) malloc(MAXNAME * sizeof(char));
	strcpy(filename, rootname);
	strcat(filename, ".");
	strcat(filename, extention);
	
	return filename;
}

/**********************************************************************/

int isOptimoTest(cromosoma c, int **optimos, int Noptimos, int nFeatRelev)
{
	int i, j, flag, nirrel;
	char *s;
	
	nirrel = c->largo - nFeatRelev;
	
	/* Comprobacion  bits irrelevantes = 0 */
  	for(j=0; j < nirrel; j++)
   	{
       	if( leerGen(c, j) != 0 )
       	{
       		return -1000;
    	}	
   	}
	
	/* Comprobacion bits relevantes = algun optimo */
	for(i=0; i < Noptimos; i++)
  	{
  		flag = 1;
  		for(j=nirrel; j < (c->largo); j++)
  		{
  			if( leerGen(c, j) != (unsigned)optimos[i][j-nirrel] )
			{
				flag = 0;
				break;
   			}	
    	}
    	
      	if(flag == 1)
   		{
       		s = (char *) malloc((c->largo+1) * sizeof(char));
       		cromosoma2string(c, s);
           	free(s);
       		return i;	
    	}
    }
    
    return -1000;
}

/**********************************************************************/

int isOptimoCubo(cromosoma c, int **optimos, int Noptimos, int nFeatRelev)
{
	int i, j, flag;
	char *s;
	
	/* Comprobacion  bits irrelevantes = 0 */
  	for(j=nFeatRelev; j < (c->largo); j++)
   	{
       	if( leerGen(c, j) != 0 )
       	{
       		return -1000;
    	}	
   	}
	
	/* Comprobacion bits relevantes = algun optimo */
	for(i=0; i < Noptimos; i++)
  	{
  		flag = 1;
  		for(j=0; j < nFeatRelev; j++)
  		{
  			if( leerGen(c, j) != (unsigned)optimos[i][j] )
			{
				flag = 0;
				break;
   			}	
    	}
    	
      	if(flag == 1)
   		{
       		s = (char *) malloc((c->largo+1) * sizeof(char));
       		cromosoma2string(c, s);
           	free(s);
       		return i;	
    	}
    }
    
    return -1000;
}

/**********************************************************************/

int isOptimoMonks(cromosoma c, int **optimos, int Noptimos, int nFeatRelev)
{
	int i, j, flag;
	char *s;
	
	/* Comprobacion  bits irrelevantes = 0 */
  	for(j=nFeatRelev; j < (c->largo); j++)
   	{
       	if( leerGen(c, j) != 0 )
       	{
       		return -1000;
    	}	
   	}
	
	/* Comprobacion bits relevantes = algun optimo */
	for(i=0; i < Noptimos; i++)
  	{
  		flag = 1;
  		for(j=0; j < nFeatRelev; j++)
  		{
  			if( leerGen(c, j) != (unsigned)optimos[i][j] )
			{
				flag = 0;
				break;
   			}	
    	}
    	
      	if(flag == 1)
   		{
       		s = (char *) malloc((c->largo+1) * sizeof(char));
       		cromosoma2string(c, s);
       		printf("\nOptimo: %s\n", s);
           	free(s);
       		return i;	
    	}
    }
    
    return -1000;
}

/**********************************************************************/

int isOptimoOneSolutionProblem(cromosoma c, int **optimos, int Noptimos,
                               int nFeatRelev)
{
	int j, flag;
	char *s;
	
	/* Comprobacion  bits irrelevantes = 0 */
  	for(j=nFeatRelev; j < (c->largo); j++)
   	{
       	if( leerGen(c, j) != 0 )
       	{
       		return -1;
    	}	
   	}
	
	/* Comprobacion bits relevantes = algun optimo */
  	flag = 1;
  	for(j=0; j < nFeatRelev; j++)
  	{
  		if( leerGen(c, j) != (unsigned)optimos[0][j] )
		{
			flag = 0;
			break;
   		}	
    }
    
    if(flag == 1)
   	{
   		s = (char *) malloc((c->largo+1) * sizeof(char));
   		cromosoma2string(c, s);
    	free(s);
    	return 0;	
    }
    else
    {
    	return -1;
    }
    
}

/**********************************************************************/

void estadisticasPoblacionFeatureSelection(poblacion p, FILE *fpop_evol, int gen)
{
	int i;
	float best, worst, avg, std;

	best  = leerFitness(leerIndividuo(p, 0));
	worst = leerFitness(leerIndividuo(p, 0));
	avg   = 0.0f;
	
	for (i=0; i < p->tamano; ++i)
	{
        if( best < leerFitness(leerIndividuo(p, i)) )
        	best = leerFitness(leerIndividuo(p, i));
		
        if( worst  > leerFitness(leerIndividuo(p, i)) )
        	worst = leerFitness(leerIndividuo(p, i));
			
		avg += leerFitness(leerIndividuo(p, i));
	}
	
	avg /= p->tamano;
	
	std = 0.0f;
	for(i=0; i < p->tamano; i++)
		std += ( (leerFitness(leerIndividuo(p, i)) - avg) *
                 (leerFitness(leerIndividuo(p, i)) - avg) );

	std = (float)sqrt( std / (p->tamano - 1) );
	
	/* Escritura de archivo de salida */
	fprintf(fpop_evol, "%3d %5.4f %5.4f %5.4f %5.4f\n", gen, best, worst, avg, std);
}

/**********************************************************************/

void guardarPoblacionFeatureSelection(poblacion p, int gen, int (*func_optimum)
                                      (cromosoma c, int **optimos, int Noptimos,
                                      int Nfeatures), int **optimos, int Noptimos,
                                      int Nfeatures, FILE *fpop, FILE *fnichos)
{
	int i, j, idx, nichostot;
	int *nichos;
	
	nichos = (int *) malloc(Noptimos * sizeof(int));
	for(i=0; i < Noptimos; i++)
		nichos[i] = 0;
		
	/* Guardar poblacion */
	for(i=0; i < p->tamano; i++)
	{
		/* Guardar poblacion */
		for(j=0; j < (leerIndividuo(p, i)->largo - 1); j++)
		{
			fprintf(fpop, "%d ", leerGen(leerIndividuo(p, i), j));	
		}
		fprintf( fpop, "%d\n", leerGen(leerIndividuo(p, i),
                                       leerIndividuo(p, i)->largo-1) );
                                       
        /* Individuos por nicho */
        idx = func_optimum(leerIndividuo(p, i), optimos, Noptimos, Nfeatures);
        if(idx >= 0)
        	nichos[idx]++;
                                                                         	
	}
	fprintf(fpop, "\n");
	
	/* Escritura de archivo de nichos */
	nichostot = 0;
	fprintf(fnichos, "%3d ", gen);
	for(i=0; i < Noptimos; i++)
	{
		fprintf(fnichos, "%3d ", nichos[i]);
		nichostot += nichos[i];
	}
	fprintf(fnichos, "%3d\n", nichostot);

	free(nichos);
}

/**********************************************************************/

void isBestAll(float fitnessBestGen, float clasiRateBestGenE, float clasiRateBestGenV,
               int NfitEvalBest, int NinputBestGen, char *cromoBestGen, int gen,
               float *fitnessBestAll, float *clasiRateBestAllE, float *clasiRateBestAllV,
               int *NfitEvalBestAll, int *NinputBestAll, char *cromoBestAll,
               int *bestGen)
{
	if( fitnessBestGen > (*fitnessBestAll) )
	{
		(*fitnessBestAll)    = fitnessBestGen;
		(*clasiRateBestAllE) = clasiRateBestGenE;
		(*clasiRateBestAllV) = clasiRateBestGenV;
		(*NfitEvalBestAll)   = NfitEvalBest;
		(*NinputBestAll)     = NinputBestGen;
		strcpy(cromoBestAll, cromoBestGen);
		(*bestGen)           = gen;
    }
}

/**********************************************************************/

void writeOutFileSettings(FILE *fset, char SimId[], time_t ti, time_t tf,
                 char *Basename, int Ntrain, int Nval, int Ninput, int Nhidden,
                 int Noutput, int Epochs, float Epsi, int MaxGen, int SizePop,
                 char *GAName, char *IniName, float pctje_pop, float pctje_bits,
                 char *SelName, float Pcross, char *MutName, float Pmut,
                 float fracFitMut, float Pbbadd, float Pbbirrel, int bestGen,
                 float fitnessBest, float clasiRateBestE, float clasiRateBestV,
                 int NfitEvalBest, int NinputBest, char *cromoBest)
{
	/* Escritura de archivo con settings */
	fprintf(fset, "Feature Selection by using GAMIFS\n\n");
	fprintf(fset, "Settings de la Simulacion %s\n\n", SimId);
	fprintf(fset, "[Tiempo inicial] \t\t %s", ctime(&ti));
	fprintf(fset, "[Tiempo final] \t\t %s", ctime(&tf));
	fprintf(fset, "[Tiempo total (s)] \t %d\n", (int)(tf-ti));
	fprintf(fset, "[Tiempo total (hrs.)] \t %f\n", (float)(((int)(tf-ti)) / 3600));
	fprintf(fset, "[Nombre de la base] \t %s\n", Basename);
	fprintf(fset, "[Patrones entrenamiento] %d\n", Ntrain);
	fprintf(fset, "[Patrones validacion] \t %d\n", Nval);
	fprintf(fset, "[Arquitectura NN] \t %d-%d-%d\n", Ninput, Nhidden, Noutput);
	fprintf(fset, "[Epocas] \t\t\t %d\n", Epochs);
	fprintf(fset, "[Epsi] \t\t\t %f\n", Epsi);
	fprintf(fset, "[N generaciones GA] \t %d\n", MaxGen);
	fprintf(fset, "[Tamano poblacion] \t %d\n", SizePop);
	fprintf(fset, "[Tipo GA] \t\t\t %s\n", GAName);
	fprintf(fset, "[Tipo Init Pop] \t\t %s\n", IniName);
	if( strcmp(IniName, "Inicializacion por Ranking AMIFS") == 0 )
	{
		fprintf(fset, "[Pctje Poblacion] \t %f\n", pctje_pop);
  		fprintf(fset, "[Pctje Bits] \t\t %f\n", pctje_bits);	
 	}
	fprintf(fset, "[Funcion fitness] \t Brill et. al.\n");
	fprintf(fset, "[Tipo seleccion] \t\t %s\n", SelName);
	fprintf(fset, "[Tipo crossover] \t\t crossoverBinomial\n");
	fprintf(fset, "[Tipo mutacion] \t\t %s\n", MutName);
	if( strcmp(MutName, "No Mutation") != 0 )
	{
		fprintf(fset, "[Pctje Pob. Mutada] \t %f\n", fracFitMut);
		fprintf(fset, "[Pbb Agregar Caract] \t %f\n", Pbbadd);
		fprintf(fset, "[Pbb Elim. Caract] \t %f\n", 1-Pbbadd);
		fprintf(fset, "[Pbb Elim. Irrel.] \t %f\n", Pbbirrel);
		fprintf(fset, "[Pbb Elim. Red.] \t\t %f\n", 1-Pbbirrel);	
 	}
	fprintf(fset, "[Pbb crossover] \t\t %f\n", Pcross);
	fprintf(fset, "[Pbb mutacion] \t\t %f\n", Pmut);
	fprintf(fset, "Mejor individuo: \t\t %d\n", bestGen);
	fprintf(fset, "[Pctje clasificaciones] %7.3f %7.3f\n", clasiRateBestE,
	               clasiRateBestV);
	fprintf(fset, "[N entradas] \t\t %d\n", NinputBest);
	fprintf(fset, "[N fitness eval.] \t %d\n", NfitEvalBest);
	fprintf(fset, "[Cromosoma] \t\t %s\n", cromoBest);
}

/**********************************************************************/

void writeOutFileFitness(FILE *ffit, int gen, int NinputBestGen,
                 float fitnessBestGen, float clasiRateBestGenE,
                 float clasiRateBestGenV, int NfitEvalBest, char *cromoBestGen)
{
	fprintf(ffit, "%3d %3d %5.4f %7.3f %7.3f %4d %s\n", gen, NinputBestGen,
                   fitnessBestGen, clasiRateBestGenE, clasiRateBestGenV,
                   NfitEvalBest, cromoBestGen);                 
}
                 
/**********************************************************************/

void writeOutFileCrossover(FILE *fcross, int gen, int fitIncCross,
                           float fitDifCross, int SizePop)
{
	fprintf( fcross, "%3d %3d %6.4f %4.3f\n", gen, fitIncCross, fitDifCross,
                     (100 * ((float)fitIncCross / (float)SizePop)) );
}

/**********************************************************************/

void writeOutFileMutacion(FILE *fmut, int gen, int fitIncMut, float fitDifMut,
                          int TotMut)
{
	if(TotMut == 0)
	{
		fprintf(fmut, "%3d %3d %3d %6.4f %4.3f\n", gen, TotMut, 0, 0.0f, 0.0f);	
 	}
 	else
 	{
	 	fprintf( fmut, "%3d %3d %3d %6.4f %4.3f\n", gen, TotMut, fitIncMut,
                        fitDifMut, (100 * ((float)fitIncMut / (float)TotMut)) );
    }
}

/**********************************************************************/

void writeOutFileMutacionEff(FILE *fmut, int gen, int fitIncMut, float fitDifMut,
                             int TotMut, float **mut_eff)
{
	if(TotMut == 0)
	{
		fprintf(fmut, "%3d %3d %3d %6.4f %5.3f ", gen, TotMut, 0, 0.0f, 0.0f);	
		fprintf(fmut, "%3d %3d %6.4f %5.3f ", TotMut, 0, 0.0f, 0.0f);
		fprintf(fmut, "%3d %3d %6.4f %5.3f ", TotMut, 0, 0.0f, 0.0f);
		fprintf(fmut, "%3d %3d %6.4f %5.3f\n", TotMut, 0, 0.0f, 0.0f);
 	}
 	else
 	{
	 	fprintf( fmut, "%3d %3d %3d %6.4f %5.3f ", gen, TotMut, fitIncMut,
                        fitDifMut, (100 * ((float)fitIncMut / (float)TotMut)) );
                        
        if(mut_eff[1][2] == 0)
        {
        	fprintf(fmut, "%3d %3d %6.4f %5.3f ", 0, 0, 0.0f, 0.0f);
        }
        else
        {                
        	fprintf( fmut, "%3d %3d %6.4f %5.3f ", (int)mut_eff[1][2],
                           (int)mut_eff[1][0], mut_eff[1][1],
                           (100 * ((float)mut_eff[1][0] / (float)mut_eff[1][2])) );
         }
        
        if(mut_eff[2][2] == 0)
        {
        	fprintf(fmut, "%3d %3d %6.4f %5.3f ", 0, 0, 0.0f, 0.0f);
        }
        else
        {       
        	fprintf( fmut, "%3d %3d %6.4f %5.3f ", (int)mut_eff[2][2],
                           (int)mut_eff[2][0], mut_eff[2][1],
                           (100 * ((float)mut_eff[2][0] / (float)mut_eff[2][2])) );
        }
        
        if(mut_eff[3][2] == 0)
        {
        	fprintf(fmut, "%3d %3d %6.4f %5.3f\n", 0, 0, 0.0f, 0.0f);
        }
        else
        {                                       
        	fprintf( fmut, "%3d %3d %6.4f %5.3f\n", (int)mut_eff[3][2],
                           (int)mut_eff[3][0], mut_eff[3][1],
                           (100 * ((float)mut_eff[3][0] / (float)mut_eff[3][2])) );
        }
    }
}

/**********************************************************************/


