/***********************************************************************
*								random.h							   *
*			Funciones de generacin de numeros aleatorios              *
* Funciones modificadas de la version para C del SGA de D. Goldberg	   * 	
* y funciones tomadas de Numerical Recipes in C.					   *	
***********************************************************************/				


/***********************************************************************
* Genera la semilla para la rutina de numeros aleatorios como la hora  *
* actual del reloj del procesador.									   *	
***********************************************************************/
void seed();

/* Generador de numeros aleatorios Programa de Caballero */
//float ran2(long *idum);

/* Genera un float aleatoria [0,1] */
float ran3();

/***********************************************************************
* Generador de numeros aleatorios ran3                                 *
* Tomado de Numerical recipes in C de Press et al.                     *
*                                                                      *
* Esta funcion genera numeros aleatorios con distribucion uniforme	   *	
* en el rango [0.0, 1.0].  La rutina puede convertirse completamente   * 
* a artimetica flotante declarando mj, mk, ma[] como float,			   *
* y definiendo mbig y mseed como 4000000 y 1618033, respectivamente.   *                                                                                                         
***********************************************************************/
//float ran4();

/* Generation of random bits: Numerical Recipes, p.226 */
int irbit2();

/* random integer between low and high */
int rndint(int lo, int hi);

/* real random number between specified limits */
float rndreal(float lo , float hi);

/* Flip a biased coin - true if heads */
int flip(float prob);

/* Genera una permutacion aleatoria de N enteros entre [0, n-1] */
int *randPerm(int n);

/* Inicializa una matriz aleatoriamente en el intervalo [-0.5, 0.5] */
void initFloatMatrixRnd(float **matrix, int nrow, int ncol);


