/***********************************************************************
*                             "poblacion.h"	   						   *
* Definicion de la estructura poblacion y las operaciones sobre esta   *
***********************************************************************/


struct population
{
	int tamano;
	int largo;
	cromosoma *individuos;
};

typedef struct population *poblacion;

/* retornar el individuo i de la poblacion p */
#define leerIndividuo(p, i) ((p)->individuos[(i)])

/* retornar el cromosoma (genes) del individuo i de la poblacion p */
#define leerCromosomaDeIndividuo(p, i) (((p)->individuos[(i)])->cromo)

/* retornar el gen j del cromosoma del individuo i de la poblacion p */
#define leerGenDeCromosomaDeIndividuo(p, i, j) (((p)->individuos[(i)])->cromo[(j)])

/* crear una nueva poblacion */
poblacion nuevaPoblacion(int tamano, int largo);

/* Crear una nueva poblacion con bits inicializados de acorde al ranking
   de caracts entregado por AMIFS. "pctje_pop" corresponde al porcentaje de
   la poblacion cuyos cromosomas seran inicializados de acorde al ranking.
   "pctje_bits" corresponde al porcentaje de bits del total que seran
   inicializados segun el ranking.
   (Ej. pctje_pop = 0.2, pctje_bits = 0.1, largo = 20, significa que el 20% de
   los individuos de la poblacion seran inicializados con el 10% de los bits
   (2 caracts del ranking) como 1. */
poblacion nuevaPoblacionRankingAMIFS(int tamano, int largo, int *ranking,
                                     float pctje_pop, float pctje_bits);
                              
/* Crear poblacion partiendo de la ultima poblacion generada
   en la simulacion anterior */                                            
poblacion nuevaPoblacionFromLastSimulation(char *fpop_name, int genIter,
                                           int tamano, int largo);

/* destruir una poblacion */
void destruirPoblacion(poblacion p);

/* copiar la poblacion f en d */
void copiarPoblacion(poblacion d, poblacion f);

/* duplicar la poblacion f */
poblacion duplicarPoblacion(poblacion f);

/* mezcla la poblacion p aleatoriamente */
void mezclarPoblacion(poblacion p);

/* imprimir la poblacion en pantalla */
void imprimirPoblacion(poblacion p, FILE *fp);

/* Calcular el fitness para la poblacion */
void evaluarPoblacion(poblacion p, float (*func_fitness)(cromosoma c, 
					  float *var, int nvar, int preci, float liminf, 
					  float limsup), float *var, int nvar, int preci,
					  float liminf, float limsup);
					  
/* Compara si el "c" de la poblacion es el mejor de la generacion y lo copia */                                      
void isBestHijo(float fitnessInd, float clasiRateIndE, float clasiRateIndV,
               int NfitEvalBest, int NinputInd, cromosoma c, float *fitnessBestAux,
               float *clasiRateBestAuxE, float *clasiRateBestAuxV,
               int *NfitEvalBestAux, int *NinputBestAux, char *cromoBestAux);					  

/* Calcular el fitness para la poblacion en el problema de Seleccion
   de Caracteristicas mediante GA y NN */
void evaluarPoblacionFeatureSelection(poblacion p, float (*func_fitness)
                    (cromosoma c, float **Input_E, float **Target_E, float **Input_V,
                    float **Target_V, float **Weight_IH, float **Weight_HO,
                    int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                    int Epochs, int valStep, float Epsi, float minError,
                    float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                    float *clasiRateE, float *clasiRateV, int *targetIdxE,
                    int *targetIdxV, float *qele, char *SimId, float costRatio,
                    int *NewNinput),
                    float **Input_E, float **Target_E, float **Input_V,
                    float **Target_V, float **Weight_IH, float **Weight_HO,
                    int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                    int Epochs, int valStep, float Epsi, float minError,
                    float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                    float *clasiRateE, float *clasiRateV, int *targetIdxE,
                    int *targetIdxV, float *qele, char *SimId, float costRatio,
                    int *NewNinput, float *fitnessBestGen, float *clasiRateBestGenE,
                    float *clasiRateBestGenV, int *NfitEvalBest, int *NinputBestGen,
                    char *cromoBestGen);
                    
				
       	  
