
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <string.h>
#include "memoria.h"

#define MAXNAME		256
#define BIGBUF		4096


/******************************************************************************/

float **loadBase(char *Basename, int Nexamples, int Nfeatures, char option)
{
	int i, j;
	float **Base, x;
	char *nameaux;
	FILE *fp;
	
	nameaux = (char *) malloc(MAXNAME * sizeof(char));
	Base    = matrizFloat(Nexamples, Nfeatures);
	
	strcpy(nameaux, Basename);
	/* Bifurcacion dependiendo de option */
	if(option == 'e')
	{
		strcat(nameaux, "ti.dat");
		if( (fp = fopen(nameaux, "r")) == NULL )
		{
			printf("\nError abriendo archivo de entrenamiento(Funcion loadBase)\n");
 			system("pause");
 			return 0;
  		}
 	}	
	else if(option == 'v')
	{
		strcat(nameaux, "vi.dat");
		if( (fp = fopen(nameaux, "r")) == NULL )
		{
			printf("\nError abriendo archivo de validacion(Funcion loadBase)\n");
 			system("pause");
 			return 0;
  		}
 	}
 	else if(option == 'p')
	{
		strcat(nameaux, "testi.dat");
		if( (fp = fopen(nameaux, "r")) == NULL )
		{
			printf("\nError abriendo archivo de test(Funcion loadBase)\n");
 			system("pause");
 			return 0;
  		}
 	}
 	else
 	{
 		printf("\nError en opcion de archivo a cargar (Funcion loadBase)\n");
 		system("pause");
 		return 0;
  	}
   
   	/* Lectura de archivo */
	for (i=0; i < Nexamples; ++i)
	{
		for (j=0; j < Nfeatures; ++j)
		{
			fscanf(fp, "%f", &x);
			Base[i][j] = x;
		}
	}
	
	fclose(fp);
	free(nameaux);
	return Base;
}

/************************************************************************/

float **loadTarget(char *Basename, int Nexamples, int Nclass, char option)
{
	int i, j;
	float **Target, x;
	char *nameaux;
	FILE *fp;
	
	nameaux = (char *) malloc(MAXNAME * sizeof(char));
	Target  = matrizFloat(Nexamples, Nclass);
	
	strcpy(nameaux, Basename);
	/* Bifurcacion dependiendo de option */
	if(option == 'e')
	{
		strcat(nameaux, "to.dat");
		if( (fp = fopen(nameaux, "r")) == NULL )
		{
			printf("\nError abriendo archivo de entrenamiento(Funcion loadBase)\n");
 			system("pause");
 			return 0;
  		}
 	}	
	else if(option == 'v')
	{
		strcat(nameaux, "vo.dat");
		if( (fp = fopen(nameaux, "r")) == NULL )
		{
			printf("\nError abriendo archivo de validacion(Funcion loadBase)\n");
 			system("pause");
 			return 0;
  		}
 	}
 	else if(option == 'p')
	{
		strcat(nameaux, "testo.dat");
		if( (fp = fopen(nameaux, "r")) == NULL )
		{
			printf("\nError abriendo archivo de test(Funcion loadBase)\n");
 			system("pause");
 			return 0;
  		}
 	}
 	else
 	{
 		printf("\nError en opcion de archivo a cargar (Funcion loadBase)\n");
 		system("pause");
 		return 0;
  	}
   
   	/* Lectura de archivo */
	for (i=0; i < Nexamples; ++i)
	{
		for (j=0; j < Nclass; ++j)
		{
			fscanf(fp, "%f", &x);
			Target[i][j] = x;
		}
	}
	
	fclose(fp);
	free(nameaux);
	return Target;
}

/************************************************************************/

int **loadOptimos(char *filename, int Noptimos, int Nfeatures)
{
	int i, j, x;
	int **optimos;
	FILE *fp;
	
	optimos = matrizInt(Noptimos, Nfeatures);
	fp = fopen(filename, "r");
	
	for (i=0; i < Noptimos; ++i)
	{
		for (j=0; j < Nfeatures; ++j)
		{
			fscanf(fp, "%d", &x);
			optimos[i][j] = x;
		}
	}
	
	fclose(fp);
	return optimos;
}

/************************************************************************/

void loadMatrix(char *filename, float **matrix, int Nrow, int Ncol)
{
	int i, j;
    float x;
	FILE *fp;
	
	fp = fopen(filename, "r");
	for (i=0; i < Nrow; ++i)
	{
		for (j=0; j < Ncol; ++j)
		{
			fscanf(fp, "%f", &x);
			matrix[i][j] = x;
		}
	}
	fclose(fp);
}

/************************************************************************/

void loadRanking(char *filename, int *ranking, int Nfeatures)
{
	int i, feat;
	char *linea;
	FILE *fp;
	
	linea = (char *) malloc(MAXNAME * sizeof(char));

	fp = fopen(filename, "r");
	while(fgets(linea, MAXNAME, fp) != NULL)
	{
		if( linea[0] == '-' )
		{
			fgets(linea, MAXNAME, fp);
			break;
		}
	}
	
	for(i=0; i < Nfeatures; i++)
	{
		fscanf(fp, "%d", &feat);
		ranking[i] = (feat - 1);
 	}

	fclose(fp);
	free(linea);
}

/************************************************************************/

void loadVectorFloat(char *filename, float *vector, int Nfeatures)
{
	int i;
    float x;
	FILE *fp;
	
	fp = fopen(filename, "r");
	for (i=0; i < Nfeatures; ++i)
	{
		fscanf(fp, "%f", &x);
		vector[i] = x;
	}
	fclose(fp);
}

/************************************************************************/

