/***********************************************************************
*                             "gamifs_fitness.h"					   *
*	   	   Funcion de Fitness para Seleccion de caracteristicas        *
***********************************************************************/

/* Reconstruye la base de entrenameinto de la red neuronal en base a las
   caracteristicas seleccionadas por el GA */
void rebuildBase(cromosoma c, int Ntrain, int Nval, int Ninput, int Nhidden, 
                 float **Input_E, float **Input_V, float **NewInput_E,
                 float **NewInput_V, float **Weight_IH, float **NewWeight_IH);

/* Fitness Function = Clasification Rate in Validation Set */
float gamifsFitness(cromosoma c, float **Input_E, float **Target_E, float **Input_V,
                    float **Target_V, float **Weight_IH, float **Weight_HO,
                    int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                    int Epochs, int valStep, float Epsi, float minError,
                    float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                    float *clasiRateE, float *clasiRateV, int *targetIdxE,
                    int *targetIdxV, float *qele, char *SimId, float costRatio,
                    int *NewNinput);

/* Entrega en una matriz con las distintas combinaciones de caractes relevantes
   ordenadas en filas cada combinacion posible para el problema de Paridad 3*/
int **par3Optimos(char *filename, int Noptimos, int Nfeatures); 

