/************************************************************************
 *                                                                      *
 *                      GA - Genetic Algorithm                          *
 *                                                                      *
 *            By Rodrigo Caballero C. (rocaball@dim.uchile.cl),         *
 *                                                                      *
 *                        Universidad de Chile                          *
 *             Facultad de Ciencias Fisicas y Matematicas               *
 *                Departamento de Ingenieria Electrica                  *
 *                          Santiago, CHILE.                            *
 *                                1997                                  *
 *                                                                      *
 ************************************************************************/

/************************************************************************
 *  file :  alloca.h							*
 *									*
 *  purpose:    Allocation functions                                    *
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stddef.h>
#include <malloc.h>
#include <time.h>
#include <float.h>

void nerror(error_text)
char error_text[];
{
	printf("NM run time error\n");
	printf("%s\n",error_text);
	printf("...now exiting\n");
	exit(1);
}

double *dvector(d1)
int d1;
{
	double *m;

	m = (double *) calloc(d1, sizeof(double ));
	if(!m) nerror("allocation failure 1 in dvector()" );
	return m;
}

float *fvector(d1)
int d1;
{
        float *m;

        m = (float *) calloc(d1, sizeof(float ));
        if(!m) nerror("allocation failure 1 in fvector()" );
        return m;
}


int *ivector(d1)
int d1;
{
	int *m;

	m = (int *) calloc(d1, sizeof(int ));
	if(!m) nerror("allocation failure 1 in ivector()" );
	return m;
}


double **dmatrix(d1,d2)
int d1, d2;
{
	double **m;
	int h;
	m = (double **) calloc(d1, sizeof(double *));
	if(!m) nerror("allocation failure 1 in dmatrix()" );
	for(h=0; h < d1; h++)
	{
		m[h] = (double *) calloc(d2, sizeof(double ));
		if(!m[h]) nerror("allocation failure 2 in dmatrix()" );
	}
	return m;
}

void free_dmatrix(m,d1,d2)
double **m;
int d1, d2;
{
        int h;
        for(h=0; h < d1; h++)
        {
                free(m[h]);
        }
        free(m);
}


float **fmatrix(d1,d2)
int d1, d2;
{
        float **m;
        int h;
	m = (float **) calloc(d1, sizeof(float *));
        if(!m) nerror("allocation failure 1 in fmatrix()" );
        for(h=0; h < d1; h++)
        {
                m[h] = (float *) calloc(d2, sizeof(float ));
                if(!m[h]) nerror("allocation failure 2 in fmatrix()" );
        }
        return m;
}

void free_fmatrix(m,d1,d2)
float **m;
int d1, d2;
{
        int h;
        for(h=0; h < d1; h++)
        {
		free(m[h]);
        }
	free(m);
}

int **imatrix(d1,d2)
int d1, d2;
{
	int **m,h;

	m = (int **) calloc(d1, sizeof(int *));
	if(!m) nerror("allocation failure 1 in imatrix()" );
	for(h=0; h < d1; h++)
	{
		m[h] = (int *) calloc(d2, sizeof(int ));
		if(!m[h]) nerror("allocation failure 2 in imatrix()" );
	}
	return m;
}

void free_imatrix(m,d1,d2)
int **m;
int d1, d2;
{
        int h;
        for(h=0; h < d1; h++)
        {
                free(m[h]);
        }
        free(m);
}

float ***fcube(d1,d2,d3)
int d1, d2, d3;
{
        float ***m;
        int h,k;
 
        m = (float ***) calloc(d1, sizeof(float **));
        if(!m) nerror("allocation failure 1 in dcube()" );
        for(h=0; h < d1; h++)
        {
                m[h] = (float **) calloc(d2, sizeof(float *));
                if(!m[h]) nerror("allocation failure 2 in dcube()" );
                for(k=0; k < d2; k++)
                {
                        m[h][k] = (float *) calloc(d3, sizeof(float));
                        if(!m[h][k]) nerror("allocation failure 3 in fcube()" );
                }
        }
        return m;
}

void free_fcube(m,d1,d2,d3)
float ***m;
int d1, d2, d3;
{
        int h,k;
        for(h=0; h < d1; h++)
        {
                for(k=0; k < d2; k++)
                {
			free(m[h][k]);
                }
		free(m[h]);
        }
	free(m);
}


double ***dcube(d1,d2,d3)
int d1, d2,d3;
{
	double ***m;
	int h,k;

	m = (double ***) calloc(d1, sizeof(double **));
	if(!m) nerror("allocation failure 1 in dcube()" );
	for(h=0; h < d1; h++)
	{
		m[h] = (double **) calloc(d2, sizeof(double *));
		if(!m[h]) nerror("allocation failure 2 in dcube()" );
		for(k=0; k < d2; k++)
		{
			m[h][k] = (double *) calloc(d3, sizeof(double ));
			if(!m[h][k]) nerror("allocation failure 3 in dcube()" );
		}
	}
	return m;
}

int ***icube(d1,d2,d3)
int d1,d2,d3;
{
	int ***m,h,k;

	m = (int ***) calloc(d1, sizeof(int **));
	if(!m) nerror("allocation failure 1 in icube()" );
	for(h=0; h < d1; h++)
	{
		m[h] = (int **) calloc(d2, sizeof(int *));
		if(!m[h]) nerror("allocation failure 2 in icube()" );
		for(k=0; k < d2; k++)
		{
			m[h][k] = (int *) calloc(d3, sizeof(int ));
			if(!m[h][k]) nerror("allocation failure 3 in icube()" );
		}
	}
	return m;
}

double ****dtetra(d1,d2,d3,d4)
int d1,d2,d3,d4;
{
	double ****m;
	int h,k,i;

	m = (double ****) calloc(d1, sizeof(double ***));
	if(!m) nerror("allocation failure 1 in dtetra()" );
	for(h=0; h < d1; h++)
	{
		m[h] = (double ***) calloc(d2, sizeof(double **));
		if(!m[h]) nerror("allocation failure 2 in dtetra()" );
		for(k=0; k < d2; k++)
		{
			m[h][k] = (double **) calloc(d3, sizeof(double *));
			if(!m[h][k]) nerror("allocation failure 3 in dtetra()" );
			for(i=0; i< d3; i++)
			{
				m[h][k][i] = (double *) calloc(d4, sizeof(double ));
				if(!m[h][k][i]) nerror("allocation failure 4 in dtetra()" );
			}
		}
	}
	return m;
}

int ****itetra(d1,d2,d3,d4)
int d1,d2,d3,d4;
{
	int ****m,h,k,i;

	m = (int ****) calloc(d1, sizeof(int ***));
	if(!m) nerror("allocation failure 1 in itetra()" );
	for(h=0; h < d1; h++)
	{
		m[h] = (int ***) calloc(d2, sizeof(int **));
		if(!m[h]) nerror("allocation failure 2 in itetra()" );
		for(k=0; k < d2; k++)
		{
			m[h][k] = (int **) calloc(d3, sizeof(int *));
			if(!m[h][k]) nerror("allocation failure 3 in itetra()" );
			for(i=0; i< d3; i++)
			{
				m[h][k][i] = (int *) calloc(d4, sizeof(int ));
				if(!m[h][k][i]) nerror("allocation failure 4 in itetra()" );
			}
		}
	}
	return m;
}

