/***********************************************************************
*                             "report.h"	   						   *
*		 Rutinas de calculo de estadisticas y almacenamiento de		   *	
*						resultados de simulaciones					   *
***********************************************************************/

/* Menu de inicio del programa */
void menu(int *algtype, int *seltype, int puntos, int nvar, float *optimos1, 
		  float **optimosn);
		  
/* Calcula las estadisticas de la poblacion */
void estadisticasPoblacion(poblacion p, float *best, float *worst, 
						   float *avg, int probtype);
						   
/* Rutina que guarda la poblacion y los individuos por nicho en cierto instante */
void guardarPoblacionNichos(poblacion p, float *var, float *ptos, 
							int sizepop, int nvar, int preci, float liminf, 
							float limsup, float radio, int puntos, int cont,
							float **pop1, float ***popn, float *optimos1, 
							float **optimosn, int **nichos);
							
/* Escritura de archivos de salida */
void archivosResultados(time_t ti, time_t tf, int tiempo, int fitness_func,
						int algtype, int seltype, int crosstype_func,
						int sizepop, int maxgen, int repeat, int preci,
						float pcross, float pmut, float *bestvector, 
						float *worstvector, float *avgvector, int nvar,
						float **pop1, float ***popn, int puntos, int **nichos);
		  
		  
/******************************************************************************/		  
/************************* Feature Selection Routines *************************/		  
/******************************************************************************/

/* Agrega la extension a un archivo */
char *buildFileName(char *rootname, char *extention);

/* Entrega la posicion del optimo correspondiente en la matriz "optimos" si el
   individuo "c" es un optimo, -1000 sino. "optimos" es una matriz de que tiene
   los cromosomas optimos dispuestos como filas */
int isOptimoTest(cromosoma c, int **optimos, int Noptimos, int nFeatRelev);
							
/* Entrega la posicion del optimo correspondiente en la matriz "optimos" si el
   individuo "c" es un optimo, -1000 sino. "optimos" es una matriz de que tiene
   los cromosomas optimos dispuestos como filas */
int isOptimoCubo(cromosoma c, int **optimos, int Noptimos, int nFeatRelev);

/* Entrega la posicion del optimo correspondiente en la matriz "optimos" si el
   individuo "c" es un optimo, -1000 sino. "optimos" es una matriz de que tiene
   los cromosomas optimos dispuestos como filas */
int isOptimoMonks(cromosoma c, int **optimos, int Noptimos, int nFeatRelev);

/* Entrega la posicion del optimo correspondiente en la matriz "optimos" si el
   individuo "c" es un optimo, -1000 sino. "optimos" es una matriz de que tiene
   los cromosomas optimos dispuestos como filas */
int isOptimoOneSolutionProblem(cromosoma c, int **optimos, int Noptimos,
                               int nFeatRelev);
			   
/* Calcula las estadisticas de la poblacion para el problema de seleccion
   de caracteristicas y las guarda en un archivo */
void estadisticasPoblacionFeatureSelection(poblacion p, FILE *fpop_evol, int gen);						   
														
/* Rutina que guarda la poblacion y los individuos por nicho en una cierta generacion */
void guardarPoblacionFeatureSelection(poblacion p, int gen, int (*func_optimum)
                                      (cromosoma c, int **optimos, int Noptimos,
                                      int Nfeatures), int **optimos, int Noptimos,
                                      int Nfeatures, FILE *fpop, FILE *fnichos);

/* Compara si el mejor individuo de la generacion es el mejor global y lo copia */                                      
void isBestAll(float fitnessBestGen, float clasiRateBestGenE, float clasiRateBestGenV,
               int NfitEvalBest, int NinputBestGen, char *cromoBestGen, int gen,
               float *fitnessBestAll, float *clasiRateBestAllE, float *clasiRateBestAllV,
               int *NfitEvalBestAll, int *NinputBestAll, char *cromoBestAll,
               int *bestGen);
                                      
/* Escritura de archivo de settings */                                      
void writeOutFileSettings(FILE *fset, char SimId[], time_t ti, time_t tf,
                 char *Basename, int Ntrain, int Nval, int Ninput, int Nhidden,
                 int Noutput, int Epochs, float Epsi, int MaxGen, int SizePop,
                 char *GAName, char *IniName, float pctje_pop, float pctje_bits,
                 char *SelName, float Pcross, char *MutName, float Pmut,
                 float fracFitMut, float Pbbadd, float Pbbirrel, int bestGen,
                 float fitnessBest, float clasiRateBestE, float clasiRateBestV,
                 int NfitEvalBest, int NinputBest, char *cromoBest); 
                          
/* Escritura de archivo de evolucion del fitness del mejor individuo */                                      
void writeOutFileFitness(FILE *ffit, int gen, int NinputBestGen,
                         float fitnessBestGen, float clasiRateBestGenE,
                         float clasiRateBestGenV, int NfitEvalBest,
                         char *cromoBestGen);
                 
/* Escritura de archivo de evolucion del crossover */                                      
void writeOutFileCrossover(FILE *fcross, int gen, int fitIncCross,
                           float fitDifCross, int SizePop);
                 
/* Escritura de archivo de evolucion de la mutacion */                                      
void writeOutFileMutacion(FILE *fmut, int gen, int fitIncMut, float fitDifMut,
                          int TotMut);
                          
/* Escritura de archivo de eficiencia de la mutacion */
void writeOutFileMutacionEff(FILE *fmut, int gen, int fitIncMut, float fitDifMut,
                             int TotMut, float **mut_eff);                                                                                                                                                                                                                                                                                                                                                                                                           

					
