
#include <math.h>
#include <stdlib.h>
#include <time.h>

/* ran2 */
#define IM1	2147483563
#define IM2	2147483399
#define AM	(1.0/IM1)
#define IMM1	(IM1-1)
#define IA1	40014
#define IA2	40692
#define IQ1	53668
#define IQ2	52774
#define IR1	12211
#define IR2	3791
#define NTAB	32
#define NDIV	(1+IMM1/NTAB)
#define EPS	1.2e-7
#define RNMX 	(1.0-EPS)
/* END -- ran2 */

/**********************************************************************/

void seed()
{
	srand(time(NULL));
}

/**********************************************************************/

/* Numerical Recipes in C -- Ch7.1, pp282 */
/* Long period (>2E18) random number generator of L'Ecuyer with Bays-Durahm
shuffle ans added safeguards. Returns a uniform deviate between 0.0 and 1.0
(exclusive of the endpoint values). Call with idum a negative integer to
initialize; thereafter, do not alter idum between succesive deviates in a
sequence. RNMX should approximate the largest floating value that is less
than 1. */
//float ran2(long *idum)
//{
//	int j;
//	long k;
//	static long idum2=123456789;
//	static long iy=0;
//	static long iv[NTAB];
//	float temp;
//
//	if(*idum<=0)
//	{
//		if(-(*idum)<1) 
//			*idum=1;
//		else 
//			*idum=-(*idum);
//		idum2=(*idum);
//		for(j=NTAB+7;j>=0;j--)
//		{
//			k=(*idum)/IQ1;
//			*idum=IA1*(*idum-k*IQ1)-k*IR1;
//			if(*idum<0)
//				*idum+=IM1;
//			if(j<NTAB)
//				iv[j]=*idum;
//		}
//		iy=iv[0];
//	}
//	k=(*idum)/IQ1;
//	*idum=IA1*(*idum-k*IQ1)-k*IR1;
//	if(*idum<0)
//		*idum+=IM1;
//	k=idum2/IQ2;
//	idum2=IA2*(idum2-k*IQ2)-k*IR2;
//	if(idum2<0)
//		idum2+=IM2;
//	j=iy/NDIV;
//	iy=iv[j]-idum2;
//	iv[j]=*idum;
//	if(iy<1)
//		iy+=IMM1;
//	if((temp=AM*iy)>RNMX)
//		return RNMX;
//	else
//		return temp;
//}

/**********************************************************************/

float ran3()
{
	return ((float)rand() / (float)RAND_MAX);
}

/**********************************************************************/

//float ran4()
//{
//  static int inext, inextp;
//  static long ma[56];   /* The value 56 (range ma[1..55]) is special */          
//  static int iff = 0;	/* and should not be modified; see Knuth.    */
//  long mj, mk;
//  int i, ii, k;
//  long iseed;
//
//  iseed = -50*rand();  	
//  if (iseed<0 || iff==0) {    /* Initialization */
//    iff = 1;									
//    mj = MSEED - (iseed<0 ? -iseed : iseed);
//    mj %= MBIG;				/* Initialize ma[55] using the seed iseed */
//    ma[55] = mj;			/* and the large number MSEED */
//    mk = 1;
//    for (i=1; i<=54; i++) {		/* Now initizalize the rest of the */
//      ii = (21*i) % 55;			/* table, in a slightly random order, */ 
//      ma[ii] = mk;				/* with numbers that are not */
//      mk = mj - mk;				/* especially random. */
//      if (mk < MZ) mk += MBIG;
//      mj = ma[ii];
//    }
//    for (k=1; k<=4; k++)		/* We randomize them by "warming up */
//      for (i=1; i<=55; i++) {	/* the generator." */
//		ma[i] -= ma[1+(i+30) % 55];
//		if (ma[i]<MZ) ma[i] += MBIG;
//      }
//    inext = 0;     /* Prepare indices for our first generated number. */
//    inextp = 31;   /* The constant 31 is special; see Knuth */
//    iseed = 1;
//  }								/* Here is where we start, except on initialization */
//  if (++inext==56) inext = 1;   /* Initizalize inext and inextp, wrapping    */
//  if (++inextp==56) inextp = 1; /* arround 56 to 1.                          */
//  mj = ma[inext] - ma[inextp];  /* Generate new random number substractively */
//  if (mj<MZ) mj +=MBIG;         /* Make sure that it is in range.            */
//  ma[inext] = mj;               /* Store it                                  */
//  return (float)(mj*FAC);                /* and output the derived uniform deviate.   */
//}

/**********************************************************************/

#define IB1 1
#define IB2 2
#define IB5 16
#define IB18 131072
#define MASK (IB1+IB2+IB5)

int irbit2()
{
	unsigned long iseed = 10*rand();

	if(iseed & IB18)
	{
		iseed = ((iseed ^ MASK) <<1) | IB1;
		return 1;
	}
	else
	{
		iseed <<= 1;
		return 0;
	}
}
/**********************************************************************/

int rndint(int lo, int hi)
{
    int i;

    if(lo >= hi)
        i = lo;
    else
    {
        i = (int)((ran3() * (hi - lo + 1)) + lo);
        if(i > hi) i = hi;
    }
    return(i);
}
/**********************************************************************/

float rndreal(float lo , float hi)
{
    return((ran3() * (hi - lo)) + lo);
}
/**********************************************************************/

int flip(float prob)
{
    if(ran3() <= prob)
        return(1);
    else
        return(0);
}
/**********************************************************************/

int *randPerm(int n)
{
	int i, cont, *indexin, *indexout, idx;

	indexin = (int *) malloc(n * sizeof(int));
	indexout = (int *) malloc(n * sizeof(int));
	for(i=0; i < n; i++)
		indexin[i] = i;

	seed();

	cont = 0;
	while (cont < n)
	{
		idx	= (int) fmod((double)rand(), (double)n);
		if (irbit2 == 0)
		{
			while (indexin[idx] < 0)
			{
				if (idx < 0)
					idx = n-1;
				else
					idx--;
			}

			indexout[cont] = indexin[idx];
			indexin[idx] = -1;
			cont++;
		}
		else
		{
			while (indexin[idx] < 0)
			{
				if (idx > n-1)
					idx = 0;
				else
					idx++;
			}

			indexout[cont] = indexin[idx];
			indexin[idx] = -1;
			cont++;
		}
	}
	free(indexin);
	return indexout;
}

/**********************************************************************/

void initFloatMatrixRnd(float **matrix, int nrow, int ncol)
{
	int i, j;
	
	for(i=0; i < nrow; i++)
		for(j=0; j < ncol; j++)
			matrix[i][j] = (float)(ran3() - 0.5);
}

/**********************************************************************/
