
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "random.h"
#include "memoria.h"
#include "cromosoma.h"
#include "poblacion.h"


/**********************************************************************/

void pbbMutacionLineal(int *ranking, float *pbbMutVector, float Pb, float Pw,
                       int Nfeatures)
{
	int i;
	float m, n;
	
	m = (Pw - Pb) / ((float)Nfeatures - 1.0f);
	n = Pb;
	
	for(i=0; i < Nfeatures; i++)
	{
		pbbMutVector[ranking[i]] = (m * (float)i) + n;
	}
}

/**********************************************************************/

void pbbMutacionExponencial(int *ranking, float *pbbMutVector, float Pb, float Pw,
                            int Nfeatures)
{
	int i;
	float alfa, beta;
	
	beta = Pb;
 	alfa = (1.0f / ((float)Nfeatures - 1.0f)) * (float)log(Pb/Pw);
  
   	for(i=0; i < Nfeatures; i++)
   	{
		pbbMutVector[ranking[i]] = beta * (float)exp(-alfa * (float)i);
	}
}

/**********************************************************************/

void pbbMutacionExponencialPartes(int *ranking, float *pbbMutVector, float Pb,
                                  float Pm, float Pw, int Nfeatures)
{
	int i;
	float alfa, beta;
 	float y, m, n;

	/* Exponencial de 1ra mitad */
	beta = Pb;
	alfa = (1.0f / ((float)Nfeatures/2.0f - 1.0f)) * (float)log(Pb/Pm);
	m = (Pm - Pb) / ((float)Nfeatures/2.0f - 1.0f);
	n = Pb;
	for(i=0; i < (Nfeatures/2); i++)
	{
		pbbMutVector[ranking[i]] = beta * (float)exp(-alfa * (float)i);
		y = (m * (float)i) + n;
		pbbMutVector[ranking[i]] = y + (y - pbbMutVector[ranking[i]]);
	}

	/* Exponencial de 2da mitad */
	alfa = (1.0f / ((float)Nfeatures/2.0f)) * (float)log(Pm/Pw);
	beta = Pm * (float)exp(alfa * ((float)Nfeatures/2.0f - 1.0f));
	for(i=(Nfeatures/2); i < Nfeatures; i++)
	{
		pbbMutVector[ranking[i]] = beta * (float)exp(-alfa * (float)i);
	}
}

/**********************************************************************/

int mutacionAleatoriaCromosoma(cromosoma c, float pbb)
{
    int gen;
    
    gen = rndint( 0, (c->largo - 1) );
    
    if(ran3() <= pbb)
    {
	    if(leerGen(c, gen) == 1)
	    {
	    	set0(c, gen);
    	}
    	else 
    	{
			set1(c, gen);
        }
        return 1;
   }
   return 0;
}
/**********************************************************************/

int mutacionAMIFS(cromosoma c, int *ranking, float **MIMatrix, float *MIClases,
                  float *Entropy, float *PbbMutVector, float Pbbadd,
                  float Pbbirrel, int *genmut)
{
	int i, j;
	int Ns;
	float SumMI, Hs, Score, ScoreMax;
	int *idxs, idx;

	Ns = 0;
	ScoreMax = -1000000.0f;

 	for(i=0; i < leerLargo(c); i++)
		if(leerGen(c, i) == 1)
			Ns++;
	
	idxs = vectorInt(Ns);
	j = 0;
	for(i=0; i < leerLargo(c); i++)
	{
		if(leerGen(c, i) == 1)
		{
			idxs[j] = i;
			j++;
		}
	}
		
	/* Agregar o eliminar caract */
	if(ran3() < Pbbadd)				/* Agregar caract */
	{
		for(i=0; i < leerLargo(c); i++)
		{
			/* Calcular criterios de caracts no presentes en cromosoma */
  			if(leerGen(c, i) == 0)
			{	
   				SumMI = Hs = 0.0f;	
   				
				for(j=0; j < Ns; j++)
				{
					SumMI += MIMatrix[i][idxs[j]];
					/* Minima entropia entre ambas */
					if(Entropy[i] < Entropy[idxs[j]])
						Hs += Entropy[i];
					else
						Hs += Entropy[idxs[j]];
				}
    
          		/* Criterio */
       			Score = MIClases[i] - (SumMI / (Ns * Hs));
	       		/* Guardar la caract de mayor criterio */
	         	if(Score > ScoreMax)
    	      	{
        	  		ScoreMax = Score;
          			idx      = i;
           		}				
			}	
		}
		
		/* Modificar gen de cromosoma con caract agregada */
		set1(c, idx);
		(*genmut) = idx;
		free(idxs);
		return 1;
 	}
 	else							/* Eliminar caract */
 	{
 		if(ran3() < Pbbirrel)		/* Eliminar la caracts mas irrelevante */
 		{
 			idx   = idxs[0];
 			Score = MIClases[idxs[0]];
 			/* Encontrar la caract presente en el cromosoma mas irrelevante (minimo I(C,f)) */
 			for(i=1; i < Ns; i++)
			{
				if( MIClases[idxs[i]] < Score )
				{
					Score = MIClases[idxs[i]];
					idx   = idxs[i];
				}
   			}
      		
      		/* Modificar gen de cromosoma con caract eliminada */
			set0(c, idx);
			(*genmut) = idx;
   			free(idxs);
			return 2;
   		}
   		else						/* Eliminar la caracts mas redundante */
   		{
   			for(i=0; i < Ns; i++)
			{
				SumMI = 0.0f;
				/* Calcular redundancias */
				for(j=0; j < i; j++)
				{
					SumMI += MIMatrix[idxs[i]][idxs[j]];
   				}
   				
   				for(j=(i+1); j < Ns; j++)
				{
					SumMI += MIMatrix[idxs[i]][idxs[j]];
   				}
   				
	       		/* Guardar la caract de mayor redundancia */
	         	if(SumMI > ScoreMax)
    	      	{
        	  		ScoreMax = SumMI;
          			idx      = idxs[i];
           		}
   			}
   		
	  		/* Modificar gen de cromosoma con caract eliminada */
			set0(c, idx);
			(*genmut) = idx;
			free(idxs);
			return 3;
     	}
  	}
}

/**********************************************************************/

int mutacionRankingAMIFS(cromosoma c, int *ranking, float **MIMatrix,
                         float *MIClases, float *Entropy, float *PbbMutVector,
                         float Pbbadd, float Pbbirrel, int *genmut)
{
	int idxinc, idxdec;
	float Pbbmut;
	float aleat;
	
	idxinc = 0;
	idxdec = leerLargo(c) - 1;

	while(1)
	{
		/* No hubo mutacion */
		if(idxinc >= idxdec)
		{
			(*genmut) = -1;
			return 0;
		}
	
		/* Agregar caract bien rankeada */
		Pbbmut = PbbMutVector[ranking[idxinc]];
		aleat  = ran3();
		if( leerGen(c, ranking[idxinc]) == 0 )
  		{
  			if(aleat < Pbbmut)
  			{
     			set1(c, ranking[idxinc]);
     			(*genmut) = ranking[idxinc];
  				return 1;
		    }
		    else
		    {
		    	(*genmut) = -1;
		    	return 0;
      		}
    	}

       	/* Eliminar caract mal rankeada */
       	Pbbmut = (1 - PbbMutVector[ranking[idxdec]]);
       	aleat  = ran3();
   		if( leerGen(c, ranking[idxdec]) == 1 )
   		{	
   			if(aleat < Pbbmut)
   			{
   				set0(c, ranking[idxdec]);
   				(*genmut) = ranking[idxdec];
      			return 2;
      		}
		    else
		    {
		    	(*genmut) = -1;
		    	return 0;
      		}
       	}	
       	
       	/* Sino se agrego o elimino una caract se ven las siguientes del ranking */
       	idxinc++;
       	idxdec--;
 	}
}

/**********************************************************************/

int mutacionRankingMI(cromosoma c, int *ranking, float **MIMatrix,
                         float *MIClases, float *Entropy, float *PbbMutVector,
                         float Pbbadd, float Pbbirrel, int *genmut)
{
	int i, j;
	int idxinc, idxdec;
	float aleat, Pbbmut;
	float SumMI, ScoreMax;
	int Ns, *idxs, idx;
	
	idxinc = 0;
	idxdec = leerLargo(c) - 1;
	while(1)
	{
		/* No hubo mutacion */
		if(idxinc >= idxdec)
		{
			(*genmut) = -1;
			return 0;
		}
	
		/* Agregar caract bien rankeada */
		Pbbmut = PbbMutVector[ranking[idxinc]];
		aleat  = ran3();
		if( leerGen(c, ranking[idxinc]) == 0 )
  		{
  			if(aleat < Pbbmut)
  			{
     			set1(c, ranking[idxinc]);
     			(*genmut) = ranking[idxinc];
  				return 1;
		    }
		    else
		    {
		    	(*genmut) = -1;
		    	return 0;
      		}
    	}

    	/* Eliminar caract irrelevante o redundante */
    	if(ran3() < Pbbirrel)				/* Eliminar caract irrelevante */
    	{	
       		Pbbmut = (1 - PbbMutVector[ranking[idxdec]]);
       		aleat  = ran3();
 			if( leerGen(c, ranking[idxdec]) == 1 )
	   		{	
	   			if(aleat < Pbbmut)
	   			{
	   				set0(c, ranking[idxdec]);
	   				(*genmut) = ranking[idxdec];
	      			return 2;
	      		}
			    else
			    {
			    	(*genmut) = -1;
			    	return 0;
	      		}
	       	}
       	}
        else							/* Eliminar caract redundante */
        {
        	Ns = 0;
        	for(i=0; i < leerLargo(c); i++)
				if(leerGen(c, i) == 1)
					Ns++;
	
			idxs = vectorInt(Ns);
			j = 0;
 	        for(i=0; i < leerLargo(c); i++)
 	        {
 	   	    	if(leerGen(c, i) == 1)
    	        {
    	        	idxs[j] = i;
   	        		j++;
        		}
 		    }
		
			ScoreMax = -1000000.0f;
			for(i=0; i < Ns; i++)
			{
				SumMI = 0.0f;
				/* Calcular redundancias */
				for(j=0; j < i; j++)
				{
					SumMI += MIMatrix[idxs[i]][idxs[j]];
   				}
   				
   				for(j=(i+1); j < Ns; j++)
				{
					SumMI += MIMatrix[idxs[i]][idxs[j]];
   				}
	       		/* Guardar la caract de mayor redundancia */
	         	if(SumMI > ScoreMax)
    	      	{
        	  		ScoreMax = SumMI;
          			idx      = idxs[i];
           		}
   			}
   		
	  		/* Modificar gen de cromosoma con caract eliminada */
  			Pbbmut = (1 - PbbMutVector[idx]);
       		aleat  = ran3();
       		if(aleat < Pbbmut)
       		{
       			set0(c, idx);
       			(*genmut) = idx;
  			    free(idxs);
      		    return 3;
   		    }
   		    else
   		    {
   		    	(*genmut) = -1;
   		    	free(idxs);
		    	return 0;
         	} 
        }	
       	
       	/* Sino se agrego o elimino una caract se ven las siguientes del ranking */
       	idxinc++;
       	idxdec--;
 	}
}
 
/**********************************************************************/

void mutacionAleatoriaPoblacion(poblacion p, float pbb)
{
	int i;
	for(i=0; i<p->tamano; ++i)
        mutacionAleatoriaCromosoma(leerIndividuo(p, i), pbb);
}
/**********************************************************************/
