/***********************************************************************
*                             "matrix.h"	   						   *
*	           Funciones para manejo de bases de patrones              *	
***********************************************************************/

/* Carga un conjunto de patrones para entrenar una red neuronal
   a partir de su nombre raiz. La variable option identifica si es el conjunto
   de Entrenamiento (e), Validacion (v) o Prueba (p). Option puede tomar 
   el valor (e, v, p) */
float **loadBase(char *Basename, int Nexamples, int Nfeatures, char option);
				  
/* Carga el target de un conjunto de patrones para entrenar una red neuronal
   a partir de su nombre raiz. La variable option identifica si es el target
   de Entrenamiento (e), Validacion (v) o Prueba (p). Option puede tomar 
   el valor (e, v, p) */
float **loadTarget(char *Basename, int Nexamples, int Nclass, char option);

/* Carga en una matriz las soluciones optimas de un problema de seleccion
   de caracts. Estas estan representadas por tiras binarias, donde un "1"
   significa que la caratc es optima, "0" que no lo es. */
int **loadOptimos(char *filename, int Noptimos, int Nfeatures);

/* Carga en "matrix" una matriz de floats desde el archivo "filename".
   A "matrix"  ya se le ha asignado previamente memoria */
void loadMatrix(char *filename, float **matrix, int Nrow, int Ncol);

/* Carga desde el archivo (ej. resultados.txt) de salida del programa
   "mifsmain.c" el ranking de caracts entregado por el algoritmo y lo deja
   en "ranking". Se debe asignar previamente la memoria de "ranking".
   Los indices en el ranking varan entre [0,1,2,...,Nf-1], donnde Nf es 
   el numero total de caracts del problema */
void loadRanking(char *filename, int *ranking, int Nfeatures);

/* Carga desde un archivo un vector de floats. Se debe asignar previamente
   la memoria de "vector" */
void loadVectorFloat(char *filename, float *vector, int Nfeatures);

