/***********************************************************************
*                             "fitness.h"					           *
*						   Funciones de Fitness                        *
***********************************************************************/

/* 1 = Funcion Esfera */
float fitnessEsfera(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 2 = Funcion Sombrero Mexicano */
float fitnessMexicanHat(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 3 = Funcion Rosenbrock's Valley tambien conocida como Funcion Banana */
float fitnessBanana(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 4 = Funcion de Ackley */
float fitnessAckley(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 5 = Funcion de Bohachevsky */
float fitnessBohachevsky(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 6 = Funcion de Rastrigin */
float fitnessRastrigin(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 7 = Funcion de Schafer */
float fitnessSchafer(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 8 = Funcion de Schwefel */
float fitnessSchwefel(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 9 = Funcion Sinusoide Atenuada  con peaks distribuidos uniformemente */
float fitnessSenoAtenuadoUnif(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 10 = Funcion Sinusoide Atenuada  con peaks distribuidos no uniformemente */
float fitnessSenoAtenuadoNoUnif(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 11 = Funcion con 3 peaks de distinta altura y 2 cuencas de distinta profundidad */
float fitnessPeaks(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 12 = Funcion con 5 cuencas de distinta profundidad */
float fitnessBasins(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 13 = Funcion de Griewangk */
float fitnessGriewangk(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 14 = Funcion de Schekel con 25 peaks de distintas alturas */
float fitnessShekelFoxholes(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 15 = Funcion con 6 optimos. Dos de ellos globales */
float fitnessSixHumpCamelBack(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);

/* 16 = Funcion de Himmelblau */
float fitnessHimmelblau(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup);











