
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "cromosoma.h"
#include "memoria.h"

#define PI 3.1415929f

/**********************************************************************/

float fitnessEsfera(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	int i;
	float suma;

	suma = 0.0f;
	decode(c, var, nvar, preci, liminf, limsup);
	for(i=0; i<3; i++)
		suma += (float) (var[i]*var[i]);

	return (float)(suma);
}
/**********************************************************************/

float fitnessMexicanHat(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	float a1;
	
	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) (sqrt( (var[0]*var[0]) + (var[1]*var[1]) )); 

	return (float)(sin(a1) / a1);
}
/**********************************************************************/

float fitnessBanana(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	float a1, a2;
	
	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) (var[1] - (var[0]*var[0]));
	a2 = (float) ((1.0-var[0]) * (1.0-var[0]));

	return (float)( (100.0*(a1*a1)) + a2 );
}
/**********************************************************************/

float fitnessAckley(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	float a1, a2;
	
	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) sqrt( ((var[0]*var[0]) + (var[1]*var[1])) / 2 );
	a2 = (float) exp( (cos(2.0*PI*var[0]) + cos(2.0*PI*var[1])) / 2 ); 

	return (float)( 20.0 + exp(1) - (20.0*exp(-0.2f * a1)) - a2 );
}
/**********************************************************************/

float fitnessBohachevsky(cromosoma c, float *var, int nvar, int preci, 
						 float liminf, float limsup)
{
	float a1, a2, a3, a4;

	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float)(var[0]*var[0]);
	a2 = (float) (2.0 * (var[1]*var[1]));
	a3 = (float) cos(3.0 * PI * var[0]);
	a4 = (float) cos(4.0 * PI * var[1]);

	return (float)(a1 + a2 - (0.3*a3) - (0.4*a4) + 0.7); 
}
/**********************************************************************/

float fitnessRastrigin(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	float a1, a2;

	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) ((var[0]*var[0]) - (10.0*cos(2.0 * PI * var[0])));
	a2 = (float) ((var[1]*var[1]) - (10.0*cos(2.0 * PI * var[1])));

	return (float)( 20.0 + a1 + a2 );
}
/**********************************************************************/

float fitnessSchafer(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	float a1, a2;

	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) ( (var[0]*var[0]) + (var[1]*var[1]) );
	a2 = (float) ( sin(50.0 * pow(a1, 0.1)) );
	
	return (float)( pow(a1, 0.25) * (1.0 + (a2*a2)) );
}
/**********************************************************************/

float fitnessSchwefel(cromosoma c, float *var, int nvar, int preci, 
					  float liminf, float limsup)
{
	float a1, a2;

	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) (sin(sqrt(fabs(var[0]))));
	a2 = (float) (sin(sqrt(fabs(var[1]))));

	return (float)( -(var[0]*a1) - (var[1]*a2) );
}
/**********************************************************************/

float fitnessSenoAtenuadoUnif(cromosoma c, float *var, int nvar, int preci, 
						  float liminf, float limsup)
{
	float a1, a2, a3, a4;

	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) (-2.0 * log(2.0));
	a2 = (float) ((var[0] - 0.1) / 0.8);
	a3 = (float) (a2*a2);
	a4 = (float) sin(5.0 * PI * var[0]);
	
	return (float)( exp(a1 * a3) * pow(a4, 6.0) );
}
/**********************************************************************/

float fitnessSenoAtenuadoNoUnif(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	float a1, a2, a3, a4, a5;

	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) (-2.0 * log(2.0));
	a2 = (float) ((var[0] - 0.08) / 0.854);
	a3 = (float) (a2*a2);
	a4 = (float) (pow(var[0], 0.75) - 0.05);
	a5 = (float) sin(5.0 * PI * a4);
	
	return (float)( exp(a1 * a3) * pow(a5, 6.0) );
}
/**********************************************************************/

float fitnessPeaks(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	float a1, a2, a3, a4, a5;

	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) ((1.0-var[0]) * (1.0-var[0]));
	a2 = (float) ( exp( -(var[0]*var[0]) - ((var[1]+1.0)*(var[1]+1.0)) ) );
	a3 = (float) ( (var[0]/5.0) - pow(var[0], 3.0) - pow(var[1], 5.0) );
	a4 = (float) ( exp( -(var[0]*var[0]) - (var[1]*var[1]) ) );
	a5 = (float) ( exp( -((var[0]+1.0)*(var[0]+1.0)) - (var[1]*var[1]) ) );
	
	return (float)( (3.0*a1*a2) - (10.0*a3*a4) - (a5/3.0) );
}
/**********************************************************************/

float fitnessBasins(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	float **ce, *r, *d, a1, a2, a3, a4, a5, a6, a7;

	ce = matrizFloat(5, 2);
	r = vectorFloat(5);
	d = vectorFloat(5);

	ce[0][0] = 2.0;
	ce[0][1] = 8.0;
	ce[1][0] = 3.0;
	ce[1][1] = 4.0;
	ce[2][0] = 5.0;
	ce[2][1] = 7.0;
	ce[3][0] = 7.0;
	ce[3][1] = 8.5;
	ce[4][0] = 7.0;
	ce[4][1] = 4.0;

	r[0] = 1.5;
	r[1] = 2.0;
	r[2] = 0.5;
	r[3] = 1.0;
	r[4] = 2.5;

	d[0] = 2.0;
	d[1] = 3.0;
	d[2] = 2.0;
	d[3] = 4.0;
	d[4] = 2.0;

	decode(c, var, nvar, preci, liminf, limsup);

	a1 = (float) ( pow((var[0]-ce[0][0]), 2) + pow((var[1]-ce[0][1]), 2) );
	a2 = (float) ( pow((var[0]-ce[1][0]), 2) + pow((var[1]-ce[1][1]), 2) );
	a3 = (float) ( pow((var[0]-ce[2][0]), 2) + pow((var[1]-ce[2][1]), 2) );
	a4 = (float) ( pow((var[0]-ce[3][0]), 2) + pow((var[1]-ce[3][1]), 2) );
	a5 = (float) ( pow((var[0]-ce[4][0]), 2) + pow((var[1]-ce[4][1]), 2) );

	if ( a1 <= (r[0]*r[0]) )
	{
		a6 = (float) ( d[0] / (r[0]*r[0]) );
		a7 = (float) ( ( 2.0 - (a1 / (r[0]*r[0])) ) );
		return (float)( (a6 * a1 * a7) - d[0] );
	}
	else if ( a2 <= (r[1]*r[1]) )
	{
		a6 = (float) ( d[1] / (r[1]*r[1]) );
		a7 = (float) ( ( 2.0 - (a2 / (r[1]*r[1])) ) );
		return (float)( (a6 * a2 * a7) - d[1] );
	}
	else if ( a3 <= (r[2]*r[2]) )
	{
		a6 = (float) ( d[2] / (r[2]*r[2]) );
		a7 = (float) ( ( 2.0 - (a3 / (r[2]*r[2])) ) );
		return (float)( (a6 * a3 * a7) - d[2] );
	}
	else if ( a4 <= (r[3]*r[3]) )
	{
		a6 = (float) ( d[3] / (r[3]*r[3]) );
		a7 = (float) ( ( 2.0 - (a4 / (r[3]*r[3])) ) );
		return (float)( (a6 * a4 * a7) - d[3] );
	}
	else if ( a5 <= (r[4]*r[4]) )
	{
		a6 = (float) ( d[4] / (r[4]*r[4]) );
		a7 = (float) ( ( 2.0 - (a5 / (r[4]*r[4])) ) );
		return (float)( (a6 * a5 * a7) - d[4] );
	}
	else
	{
		return 0.0;
	}
}
/**********************************************************************/

float fitnessGriewangk(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	float a1, a2;

	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) ( (var[0]*var[0]) + (var[1]*var[1]) );
	a2 = (float) ( cos(var[0]) * cos(var[1]/sqrt(2.0)) );
	
	return (float)( 1.0 + (a1/4000.0) - a2 );
}
/**********************************************************************/

float fitnessShekelFoxholes(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	int i;
	float a1, a2, a3, sum;

	sum = 0.0f;
	decode(c, var, nvar, preci, liminf, limsup);

	for(i=0; i<=24; i++)
	{
		a1 = (float) ( 16.0 * ((i % 5) - 2.0) );
		a2 = (float) ( 16.0 * ((i/5.0) - 2.0) );
		a3 = (float) ( pow((var[0]-a1), 6.0) + pow((var[1]-a2), 6.0) );
		sum += (float) (1.0 / (1.0 + i + a3));
	}

	return (float)( 500.0 - (1.0 / (0.002 + sum)) );
}
/**********************************************************************/

float fitnessSixHumpCamelBack(cromosoma c, float *var, int nvar, int preci, 
					float liminf, float limsup)
{
	float a1, a2, a3, a4, a5;

	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) (var[0] * var[0]);
	a2 = (float) (var[1] * var[1]);
	a3 = (float) (var[0] * var[1]);
	a4 = (float) (4.0 - (2.1*a1) + (a1*a1/3));
	a5 = (float) ( -4 + (4*a2) );
	
	return (float)( (a4*a1) + a3 + (a5*a2) );
}
/**********************************************************************/

float fitnessHimmelblau(cromosoma c, float *var, int nvar, int preci, 
						float liminf, float limsup)
{	
	float a1, a2;

	decode(c, var, nvar, preci, liminf, limsup);
	a1 = (float) ( (var[0]*var[0]) + var[1] - 11.0 );
	a2 = (float) ( var[0] + (var[1]*var[1]) -  7.0 );
	
	return (float)( (2186.0 - (a1*a1) - (a2*a2)) / 2186.0 );
}
/**********************************************************************/
