
#include <stdlib.h>
#include <stdio.h>
#include "random.h"
#include "cromosoma.h"
#include "poblacion.h"


/**********************************************************************/

void crossoverUnPunto(cromosoma a, cromosoma b, cromosoma *c, cromosoma *d, float pbb)
{
    int i, punto;
    if (*c == NULL)
        *c = nuevoCromosoma(a->largo);
    if (*d == NULL)
        *d = nuevoCromosoma(a->largo);
	if ( ran3() <= pbb )
	{
	    punto = rndint(1, (a->largo-1));
		for(i=0; i<punto; ++i)
		{
			leerGen(*c, i) = leerGen(a, i);
			leerGen(*d, i) = leerGen(b, i);
		}
		for(i=punto; i<a->largo; ++i)
		{
			leerGen(*c, i) = leerGen(b, i);
			leerGen(*d, i) = leerGen(a, i);
		}
	}
	else
	{
		copiarCromosoma(*c, a);
		copiarCromosoma(*d, b);
	}
}
/**********************************************************************/

void crossoverDosPuntos(cromosoma a, cromosoma b, cromosoma *c, cromosoma *d, float pbb)
{
	int i, punto1, punto2;
    if (*c == NULL)
        *c = nuevoCromosoma(a->largo);
    if (*d == NULL)
        *d = nuevoCromosoma(a->largo);
	if ( ran3() <= pbb )
	{
		punto1 = (int)rndint( 1, (int)(0.75*a->largo) );
		punto2 = (int)rndint( punto1, (int)(a->largo-1) );
		copiarCromosoma(*c, a );
		copiarCromosoma(*d, b );
		for(i=punto1; i<punto2; ++i)
		{
			leerGen(*c, i) = leerGen(b, i);
			leerGen(*d, i) = leerGen(a, i);
		}
	}
	else
	{
		copiarCromosoma(*c, a);
		copiarCromosoma(*d, b);
	}
}
/**********************************************************************/

void crossoverUniforme(cromosoma a, cromosoma b, cromosoma *c, cromosoma *d, float pbb)
{
    int i;
	pbb = 0.5f;
    if (*c == NULL)
        *c = nuevoCromosoma(a->largo);
    if (*d == NULL)
        *d = nuevoCromosoma(a->largo);
    for(i=0; i<a->largo; ++i)
	{
        if (ran3() <= pbb)
        {
            leerGen(*c, i) = leerGen(b, i);
            leerGen(*d, i) = leerGen(a, i);
        }
        else
        {
            leerGen(*c, i) = leerGen(a, i);
            leerGen(*d, i) = leerGen(b, i);
        }
    }
}
/**********************************************************************/

void crossoverBinomial(cromosoma a, cromosoma b, cromosoma *c, cromosoma *d, float pbb)
{
    int i;
    if (*c == NULL)
        *c = nuevoCromosoma(a->largo);
    if (*d == NULL)
        *d = nuevoCromosoma(a->largo);
    for(i=0; i<a->largo; ++i)
	{
		pbb = ran3();
        if (ran3() <= pbb)
        {
            leerGen(*c, i) = leerGen(b, i);
            leerGen(*d, i) = leerGen(a, i);
        }
        else
        {
            leerGen(*c, i) = leerGen(a, i);
            leerGen(*d, i) = leerGen(b, i);
        }
    }
}
/**********************************************************************/

void crossoverPoblacion(poblacion p, poblacion *q, void (*func_crossover)
					   (cromosoma a, cromosoma b, cromosoma *c, cromosoma *d, float pbb), 
					   float pbb_crossover)
{
	int i;
	mezclarPoblacion(p);
	for(i=0; i < p->tamano; i+=2)
		func_crossover(leerIndividuo(p, i), leerIndividuo(p, i+1), &leerIndividuo((*q), i), &leerIndividuo((*q), i+1), pbb_crossover);
}
/**********************************************************************/
