
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include "random.h"
#include "cromosoma.h"


/**********************************************************************/

cromosoma nuevoCromosoma(int largo)
{
	int i;
	cromosoma c;

	c = (cromosoma) malloc(sizeof(*c));
	c->largo = largo;
	c->fitness = 0.0f;
	c->cromo = (unsigned *) calloc(largo, sizeof(unsigned)); 

	for (i=0; i<largo; ++i)
		c->cromo[i] = irbit2();
	
	return c;
}

/**********************************************************************/

cromosoma nuevoCromosomaRankingAMIFS(int largo, int *ranking, float pctje_bits)
{
	int i;
 	float Nf;
	cromosoma c;

	c = (cromosoma) malloc(sizeof(*c));
	c->largo = largo;
	c->fitness = 0.0f;
	c->cromo = (unsigned *) calloc(largo, sizeof(unsigned)); 

	for (i=0; i<largo; ++i)
		c->cromo[i] = irbit2();
		
	Nf = (pctje_bits * (float)largo);
	if( (Nf - (int)Nf) < 0.5f )
		Nf = (int)Nf;
	else
		Nf = (int)Nf + 1;

	for(i=0; i < (int)Nf; i++)
		c->cromo[ranking[i]] = 1;
	
	return c;
}

/**********************************************************************/

cromosoma nuevoCromosomaFromLastPopulation(FILE *fpop, int largo)
{
	int i;
	int aux;
	cromosoma c;

	c = (cromosoma) malloc(sizeof(*c));
	c->largo = largo;
	c->fitness = 0.0f;
	c->cromo = (unsigned *) calloc(largo, sizeof(unsigned)); 

	for (i=0; i < largo; ++i)
	{
		fscanf(fpop, "%d", &aux);
		c->cromo[i] = aux;
	}
	
	return c;
}

/**********************************************************************/

void destruirCromosoma(cromosoma c)
{
	free(c->cromo);
	free(c);
}
/**********************************************************************/

void copiarCromosoma(cromosoma d, cromosoma f)
{
	int i;
	free(d->cromo);
	d->cromo = (unsigned *) calloc(f->largo, sizeof(unsigned));	
	d->largo = f->largo;
	for(i=0; i<d->largo; i++)
		d->cromo[i] = f->cromo[i];
		d->fitness = f->fitness;
}
/**********************************************************************/

cromosoma duplicarCromosoma(cromosoma f)
{
	cromosoma d;
	
	d = nuevoCromosoma(f->largo);
	copiarCromosoma(d, f);
	return d;	
}
/**********************************************************************/

void swapGen(cromosoma a, cromosoma b, int n)
{
	int aux;
	
	aux = a->cromo[n];
	a->cromo[n] = b->cromo[n];
	b->cromo[n] = aux;
}
/**********************************************************************/

void cromosoma2string(cromosoma c, char *s)
{
    int i;
    for (i=0; i < c->largo; ++i) 
	{
        if (leerGen(c, i) == 0)
			s[i] = '0';
		else
			s[i] = '1';
	}
    s[c->largo] = '\0';
}
/**********************************************************************/

void decode(cromosoma c, float *var, int nvar, int preci, float liminf, float limsup)
{
	int i,j;
	float max;
	max = (float) pow(2, preci);
	for(i=0; i<nvar; i++)
		var[i] = 0.0f;
	/* Transformacion de base 2 a base 10 */
	for(i=0; i<nvar; i++)
	{
		for(j=0; j<preci; j++)
		{
			var[i] += (float)(leerGen(c, (i*preci+j)) * pow(2, (preci-1-j))); 
		}
	}
	/* Escalamiento al intervalo y transformacion a real */
	for(i=0; i<nvar; i++)
	{
		var[i] = liminf + (limsup-liminf)*(var[i]/max);
	}
}
/**********************************************************************/

float distanciaHamming(cromosoma a, cromosoma b, int nvar, int preci, 
					   float liminf, float limsup)
{
	int i, count;
	count = 0;
	for(i=0; i<a->largo; i++)
	{
		if (leerGen(a, i) != leerGen(b, i))
			count++;
	}
	return (float) count;
}

/**********************************************************************/

float distanciaHammingFeatureSelection(cromosoma a, cromosoma b)
{
	int i, count;
	count = 0;
	for(i=0; i < a->largo; i++)
	{
		if (leerGen(a, i) != leerGen(b, i))
			count++;
	}
	return (float) count;
}

/**********************************************************************/

float distanciaEuclidiana(cromosoma a, cromosoma b, int nvar, int preci,
						  float liminf, float limsup)
{
	int i;
	float dist, aux;
	float *vara, *varb;
	vara = (float *) calloc(nvar, sizeof(float));
	varb = (float *) calloc(nvar, sizeof(float));
	dist = 0.0f;
	decode(a, vara, nvar, preci, limsup, liminf);
	decode(b, varb, nvar, preci, limsup, liminf);
	for(i=0; i<nvar; i++)
	{
		aux = (float) fabs(vara[i]-varb[i]);
		dist += (float) (aux*aux); 
	}
	dist = (float) sqrt(dist);
	free(vara);
	free(varb);
	return (float) dist;
}
/**********************************************************************/

void swap(const void **a, const void **b)
{
	void *c;
	c = (void *) *a;
	*a = *b;
	*b = (void *) c;
}
/**********************************************************************/

int individuosPorNicho(float *var, float *puntos, float radio, int nvar)
{
	int i;
	float dist, aux;
	
	dist = 0.0f;
	for(i=0; i<nvar; i++)
	{
		aux = (float) fabs(var[i]-puntos[i]);
		dist += (float) (aux*aux); 
	}
	dist = (float) sqrt(dist);

	return (dist < radio);
}
/**********************************************************************/

int compara(const void *x, const void *y)
{
	cromosoma *a, *b;

	a = (cromosoma *) x;
	b = (cromosoma *) y;

	if((*a)->fitness > (*b)->fitness)
		return -1;
	else if((*a)->fitness < (*b)->fitness)
		return 1;
	else 
		return 0;
}
/**********************************************************************/
