/***********************************************************************
*                             "algoritmos_nichos.h"					   *
*				Implementacion de Algoritmos Geneticos de Nichos       *
***********************************************************************/


/* Implementacion del Algoritmo Determinstic Crowding */
void DeterministicCrowding(poblacion p, 
						   float (*func_fitness)(cromosoma c, float *var, 
						   int nvar, int preci, float liminf, float limsup), 
						   void (*func_crossover)(cromosoma a, cromosoma b,
						   cromosoma *c, cromosoma *d, float pbb_cross),
						   int (*func_mutacion)(cromosoma c, float pbb_mut),
						   float (*func_dist)(cromosoma a, cromosoma b,
						   int nvar, int preci, float liminf, float limsup),
						   int nvar, int preci, float liminf, float limsup,
						   float *var, float pcross, float pmut, int probtype);


/* Implementacion del Algoritmo Determinstic Crowding para el problema de
   seleccion de caracteristicas */
void DeterministicCrowdingFeatureSelection(poblacion p, float (*func_fitness)
                  (cromosoma c, float **Input_E, float **Target_E, float **Input_V,
                   float **Target_V, float **Weight_IH, float **Weight_HO,
                   int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                   int Epochs, int valStep, float Epsi, float minError,
                   float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                   float *clasiRateE, float *clasiRateV, int *targetIdxE,
                   int *targetIdxV, float *qele, char *SimId, float costRatio,
                   int *NewNinput),
                   void (*func_crossover)(cromosoma a, cromosoma b, 
				   cromosoma *c, cromosoma *d, float pbb_cross),
				   float (*func_dist)(cromosoma a, cromosoma b),
                   float **Input_E, float **Target_E, float **Input_V,
                   float **Target_V, float **Weight_IH, float **Weight_HO,
                   int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                   int Epochs, int valStep, float Epsi, float minError,
                   float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                   float *clasiRateE, float *clasiRateV, int *targetIdxE,
                   int *targetIdxV, float *qele, char *SimId, float costRatio,
                   int *NewNinput, float pcross, float *fitnessBestGen,
                   float *clasiRateBestGenE, float *clasiRateBestGenV,
                   int *NfitEvalBest, int *NinputBestGen, char *cromoBestGen,
                   int *fitIncCross, float *fitDifCross);
                  
                    
/* Implementacion del Algoritmo Determinstic Crowding para el problema de
   seleccion de caracteristicas (GAMIFS) */
void DeterministicCrowdingGAMIFS(poblacion p, float (*func_fitness)
                  (cromosoma c, float **Input_E, float **Target_E, float **Input_V,
                   float **Target_V, float **Weight_IH, float **Weight_HO,
                   int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                   int Epochs, int valStep, float Epsi, float minError,
                   float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                   float *clasiRateE, float *clasiRateV, int *targetIdxE,
                   int *targetIdxV, float *qele, char *SimId, float costRatio,
                   int *NewNinput),
                   void (*func_crossover)(cromosoma a, cromosoma b, 
				   cromosoma *c, cromosoma *d, float pbb_cross),
				   int (*func_mutacion)(cromosoma c, int *ranking, float **MIMatrix,
                   float *MIClases, float *Entropy, float *PbbMutVector,
                   float Pbbadd, float Pbbirrel, int *genmut),
				   float (*func_dist)(cromosoma a, cromosoma b),
                   float **Input_E, float **Target_E, float **Input_V,
                   float **Target_V, float **Weight_IH, float **Weight_HO,
                   int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                   int Epochs, int valStep, float Epsi, float minError,
                   float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                   float *clasiRateE, float *clasiRateV, int *targetIdxE,
                   int *targetIdxV, float *qele, char *SimId, float costRatio,
                   int *NewNinput, int mut_option, float *fitnessBestGen,
                   float *clasiRateBestGenE, float *clasiRateBestGenV,
                   int *NfitEvalBest, int *NinputBestGen, char *cromoBestGen,
                   int *fitIncCross, float *fitDifCross, int *fitIncMut,
                   float *fitDifMut, int *TotMut, int CrossRatioElit, int *ranking,
                   float **MIMatrix, float *MIClases, float *Entropy,
                   float *PbbMutVector, float Pbbadd, float Pbbirrel,
                   float fracFitMut, float **mut_eff);
                        
                                                    
