
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "memoria.h"
#include "cromosoma.h"
#include "poblacion.h"


/******************************************************************************/

void DeterministicCrowding(poblacion p, 
						   float (*func_fitness)(cromosoma c, float *var, 
						   int nvar, int preci, float liminf, float limsup), 
						   void (*func_crossover)(cromosoma a, cromosoma b,
						   cromosoma *c, cromosoma *d, float pbb_cross),
						   int (*func_mutacion)(cromosoma c, float pbb_mut),
						   float (*func_dist)(cromosoma a, cromosoma b,
						   int nvar, int preci, float liminf, float limsup),
						   int nvar, int preci, float liminf, float limsup,
						   float *var, float pcross, float pmut, int probtype)
{
	int i;
	poblacion q;
	q = nuevaPoblacion(2, p->largo);
	/* Randomiza el orden de la poblacion para poder parear 
	individuos consecutivos */
	mezclarPoblacion(p);

	for(i=0; i < p->tamano; i+=2)
	{
		/* Crossover entre padres seleccionados */
		func_crossover(leerIndividuo(p, i), leerIndividuo(p, i+1),
					   &leerIndividuo(q, 0), &leerIndividuo(q, 1), 
					   pcross);
		
		/* Muta los nuevos individuos (hijos) */
		func_mutacion(leerIndividuo(q, 0), pmut);
		func_mutacion(leerIndividuo(q, 1), pmut);

		/* Asigna el fitness a los hijos */
		leerFitness(leerIndividuo(q, 0)) = func_fitness(leerIndividuo(q, 0), var, 
														nvar, preci, liminf, limsup);
		leerFitness(leerIndividuo(q, 1)) = func_fitness(leerIndividuo(q, 1), var, 
														nvar, preci, liminf, limsup);


		/* Realiza la sustitucion en la poblacion de acuerdo a 
		al distancia entre padres e hijos y al fitness de estos */
		if( func_dist(leerIndividuo(p, i), leerIndividuo(q, 0), nvar, 
					  preci, liminf, limsup)
		  + func_dist(leerIndividuo(p, i+1), leerIndividuo(q, 1), nvar,
					  preci, liminf, limsup)
		  < func_dist(leerIndividuo(p, i), leerIndividuo(q, 1), nvar,
					  preci, liminf, limsup)
		  + func_dist(leerIndividuo(p, i+1), leerIndividuo(q, 0), nvar,
					  preci, liminf, limsup) )
		{
			if(probtype == 1)
			{
				if( leerFitness(leerIndividuo(q, 0)) > leerFitness(leerIndividuo(p, i)) )
					copiarCromosoma(leerIndividuo(p, i), leerIndividuo(q, 0));

				if( leerFitness(leerIndividuo(q, 1)) > leerFitness(leerIndividuo(p, i+1)) )
					copiarCromosoma(leerIndividuo(p, i+1), leerIndividuo(q, 1));
			}
			else
			{
				if( leerFitness(leerIndividuo(q, 0)) < leerFitness(leerIndividuo(p, i)) )
					copiarCromosoma(leerIndividuo(p, i), leerIndividuo(q, 0));

				if( leerFitness(leerIndividuo(q, 1)) < leerFitness(leerIndividuo(p, i+1)) )
					copiarCromosoma(leerIndividuo(p, i+1), leerIndividuo(q, 1));
			}
		}
		else
		{
			if(probtype == 1)
			{
				if( leerFitness(leerIndividuo(q, 0)) > leerFitness(leerIndividuo(p, i+1)) )
					copiarCromosoma(leerIndividuo(p, i+1), leerIndividuo(q, 0));

				if( leerFitness(leerIndividuo(q, 1)) > leerFitness(leerIndividuo(p, i)) )
					copiarCromosoma(leerIndividuo(p, i), leerIndividuo(q, 1));
			}
			else
			{
				if( leerFitness(leerIndividuo(q, 0)) < leerFitness(leerIndividuo(p, i+1)) )
					copiarCromosoma(leerIndividuo(p, i+1), leerIndividuo(q, 0));

				if( leerFitness(leerIndividuo(q, 1)) < leerFitness(leerIndividuo(p, i)) )
					copiarCromosoma(leerIndividuo(p, i), leerIndividuo(q, 1));
			}
		}
	}
	destruirPoblacion(q);
}

/******************************************************************************/

void DeterministicCrowdingFeatureSelection(poblacion p, float (*func_fitness)
                  (cromosoma c, float **Input_E, float **Target_E, float **Input_V,
                   float **Target_V, float **Weight_IH, float **Weight_HO,
                   int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                   int Epochs, int valStep, float Epsi, float minError,
                   float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                   float *clasiRateE, float *clasiRateV, int *targetIdxE,
                   int *targetIdxV, float *qele, char *SimId, float costRatio,
                   int *NewNinput),
                   void (*func_crossover)(cromosoma a, cromosoma b, 
				   cromosoma *c, cromosoma *d, float pbb_cross),
				   float (*func_dist)(cromosoma a, cromosoma b),
                   float **Input_E, float **Target_E, float **Input_V,
                   float **Target_V, float **Weight_IH, float **Weight_HO,
                   int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                   int Epochs, int valStep, float Epsi, float minError,
                   float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                   float *clasiRateE, float *clasiRateV, int *targetIdxE,
                   int *targetIdxV, float *qele, char *SimId, float costRatio,
                   int *NewNinput, float pcross, float *fitnessBestGen,
                   float *clasiRateBestGenE, float *clasiRateBestGenV,
                   int *NfitEvalBest, int *NinputBestGen, char *cromoBestGen,
                   int *fitIncCross, float *fitDifCross)
{
	int i;
	poblacion q;
	float fitnessBestAux;
	float clasiRateBestAuxE, clasiRateBestAuxV;
	int NinputBestAux;
	char *cromoBestAux;
	int NfitEval, NfitEvalAux, NfitEvalBestAux;
	int NewNinputq0, NewNinputq1;
	float clasiRateEq0, clasiRateVq0;
    float clasiRateEq1, clasiRateVq1;
		
	NfitEval       = 0;
	NfitEvalAux    = 0;
    fitnessBestAux = 0.0f;
    cromoBestAux   = (char *) malloc((p->largo+1) * sizeof(char));
	(*fitIncCross) = 0;
	(*fitDifCross) = 0.0f;

	
	q = nuevaPoblacion(2, p->largo);
	/* Randomiza el orden de la poblacion para poder parear 
	individuos consecutivos */
	mezclarPoblacion(p);

	for(i=0; i < p->tamano; i+=2)
	{
		/* Crossover entre padres seleccionados */
		func_crossover(leerIndividuo(p, i), leerIndividuo(p, i+1),
					   &leerIndividuo(q, 0), &leerIndividuo(q, 1), 
					   pcross);
			   
  		/* Fitness hijo q0 despues de crossover */
		leerFitness(leerIndividuo(q, 0)) = func_fitness(leerIndividuo(q, 0), Input_E,
                  Target_E, Input_V, Target_V, Weight_IH, Weight_HO, Ntrain, Nval,
                  Ninput, Nhidden, Noutput, Epochs, valStep, Epsi, minError,
                  lambdaMax, lambdaMin, SseE, SseV, clasiRateE, clasiRateV,
                  targetIdxE, targetIdxV, qele, SimId, costRatio, NewNinput);
       
		NewNinputq0   = *NewNinput;
		clasiRateEq0  = ( 100 * ((*clasiRateE) / (float)Ntrain) );
		clasiRateVq0  = ( 100 * ((*clasiRateV) / (float)Nval) );

		/* Fitness hijo q1 despues de crossover */
		leerFitness(leerIndividuo(q, 1)) = func_fitness(leerIndividuo(q, 1), Input_E,
                  Target_E, Input_V, Target_V, Weight_IH, Weight_HO, Ntrain, Nval,
                  Ninput, Nhidden, Noutput, Epochs, valStep, Epsi, minError,
                  lambdaMax, lambdaMin, SseE, SseV, clasiRateE, clasiRateV,
                  targetIdxE, targetIdxV, qele, SimId, costRatio, NewNinput);
      	
         NewNinputq1   = *NewNinput;
		 clasiRateEq1  = ( 100 * ((*clasiRateE) / (float)Ntrain) );
		 clasiRateVq1  = ( 100 * ((*clasiRateV) / (float)Nval) );           	
		
		/* N of fitness evaluations */
		NfitEval += 2;
		NfitEvalAux = (*NfitEvalBest) + NfitEval;
		
		/* Realiza la sustitucion en la poblacion de acuerdo a 
		al distancia entre padres e hijos y al fitness de estos */
		if( func_dist(leerIndividuo(p, i), leerIndividuo(q, 0)) + 
            func_dist(leerIndividuo(p, i+1), leerIndividuo(q, 1))
		  < func_dist(leerIndividuo(p, i), leerIndividuo(q, 1)) +
		    func_dist(leerIndividuo(p, i+1), leerIndividuo(q, 0)) )
		{
			if( leerFitness(leerIndividuo(q, 0)) > leerFitness(leerIndividuo(p, i)) )
			{
				/* Mejor individuo Generacion */
				isBestHijo(leerFitness(leerIndividuo(q, 0)), clasiRateEq0,
                           clasiRateVq0, NfitEvalAux, NewNinputq0, leerIndividuo(q, 0),
                           &fitnessBestAux, &clasiRateBestAuxE, &clasiRateBestAuxV,
                           &NfitEvalBestAux, &NinputBestAux, cromoBestAux);
				
                /* Eficiencia crossover */
				(*fitIncCross)++;
				(*fitDifCross) += (leerFitness(leerIndividuo(q, 0)) -
                                   leerFitness(leerIndividuo(p, i)));

    			/* Reemplazar individuo en la nueva poblacion */
				copiarCromosoma(leerIndividuo(p, i), leerIndividuo(q, 0));
			}

			if( leerFitness(leerIndividuo(q, 1)) > leerFitness(leerIndividuo(p, i+1)) )
			{
				/* Mejor individuo generacion */
				isBestHijo(leerFitness(leerIndividuo(q, 1)), clasiRateEq1,
                           clasiRateVq1, NfitEvalAux, NewNinputq1, leerIndividuo(q, 1),
                           &fitnessBestAux, &clasiRateBestAuxE, &clasiRateBestAuxV,
                           &NfitEvalBestAux, &NinputBestAux, cromoBestAux);
				
                /* Eficiencia crossover */
				(*fitIncCross)++;
				(*fitDifCross) += (leerFitness(leerIndividuo(q, 1)) -
                                   leerFitness(leerIndividuo(p, i+1)));
					
				/* Reemplazar individuo en la nueva poblacion */
				copiarCromosoma(leerIndividuo(p, i+1), leerIndividuo(q, 1));
			}
		}
		else
		{
			if( leerFitness(leerIndividuo(q, 0)) > leerFitness(leerIndividuo(p, i+1)) )
			{
				/* Mejor individuo generacion */
				isBestHijo(leerFitness(leerIndividuo(q, 0)), clasiRateEq0,
                           clasiRateVq0, NfitEvalAux, NewNinputq0, leerIndividuo(q, 0),
                           &fitnessBestAux, &clasiRateBestAuxE, &clasiRateBestAuxV,
                           &NfitEvalBestAux, &NinputBestAux, cromoBestAux);
                           
				/* Eficiencia crossover */
				(*fitIncCross)++;
				(*fitDifCross) += (leerFitness(leerIndividuo(q, 0)) -
                                   leerFitness(leerIndividuo(p, i+1)));
                                   			
				/* Reemplazar individuo en la nueva poblacion */
				copiarCromosoma(leerIndividuo(p, i+1), leerIndividuo(q, 0));
			}

			if( leerFitness(leerIndividuo(q, 1)) > leerFitness(leerIndividuo(p, i)) )
			{
				/* Mejor individuo generacion */
				isBestHijo(leerFitness(leerIndividuo(q, 1)), clasiRateEq1,
                           clasiRateVq1, NfitEvalAux, NewNinputq1, leerIndividuo(q, 1),
                           &fitnessBestAux, &clasiRateBestAuxE, &clasiRateBestAuxV,
                           &NfitEvalBestAux, &NinputBestAux, cromoBestAux);
                           
				/* Eficiencia crossover */
				(*fitIncCross)++;
				(*fitDifCross) += (leerFitness(leerIndividuo(q, 1)) -
                                   leerFitness(leerIndividuo(p, i)));
							
				/* Reemplazar individuo en la nueva poblacion */
				copiarCromosoma(leerIndividuo(p, i), leerIndividuo(q, 1));
			}
		}
	}

	/* Si Fitness_mejor_hijo > Fitness_mejor_padre, se copia como mejor de la
       generacion. Sino el mejor sera el mismo de la generacion anterior */
	if(fitnessBestAux > (*fitnessBestGen))
	{
		(*fitnessBestGen)    = fitnessBestAux;
		(*clasiRateBestGenE) = clasiRateBestAuxE;
		(*clasiRateBestGenV) = clasiRateBestAuxV;
		(*NinputBestGen)     = NinputBestAux;
		(*NfitEvalBest)      = NfitEvalBestAux;
		strcpy(cromoBestGen, cromoBestAux);	
 	}
 	else
    {
		(*NfitEvalBest) += NfitEval;
	}
	
	free(cromoBestAux);
	destruirPoblacion(q);
}

/******************************************************************************/

void DeterministicCrowdingGAMIFS(poblacion p, float (*func_fitness)
                  (cromosoma c, float **Input_E, float **Target_E, float **Input_V,
                   float **Target_V, float **Weight_IH, float **Weight_HO,
                   int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                   int Epochs, int valStep, float Epsi, float minError,
                   float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                   float *clasiRateE, float *clasiRateV, int *targetIdxE,
                   int *targetIdxV, float *qele, char *SimId, float costRatio,
                   int *NewNinput),
                   void (*func_crossover)(cromosoma a, cromosoma b, 
				   cromosoma *c, cromosoma *d, float pbb_cross),
				   int (*func_mutacion)(cromosoma c, int *ranking, float **MIMatrix,
                   float *MIClases, float *Entropy, float *PbbMutVector,
                   float Pbbadd, float Pbbirrel, int *genmut),
				   float (*func_dist)(cromosoma a, cromosoma b),
                   float **Input_E, float **Target_E, float **Input_V,
                   float **Target_V, float **Weight_IH, float **Weight_HO,
                   int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                   int Epochs, int valStep, float Epsi, float minError,
                   float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                   float *clasiRateE, float *clasiRateV, int *targetIdxE,
                   int *targetIdxV, float *qele, char *SimId, float costRatio,
                   int *NewNinput, int mut_option, float *fitnessBestGen,
                   float *clasiRateBestGenE, float *clasiRateBestGenV,
                   int *NfitEvalBest, int *NinputBestGen, char *cromoBestGen,
                   int *fitIncCross, float *fitDifCross, int *fitIncMut,
                   float *fitDifMut, int *TotMut, int CrossRatioElit, int *ranking,
                   float **MIMatrix, float *MIClases, float *Entropy,
                   float *PbbMutVector, float Pbbadd, float Pbbirrel,
                   float fracFitMut, float **mut_eff)
{
	int i, j;
	poblacion q;
	float fitnessBestAux;
	float clasiRateBestAuxE, clasiRateBestAuxV;
	int NinputBestAux;
	char *cromoBestAux;
	int NfitEval, NfitEvalAux, NfitEvalBestAux;
	int flagmutq0, flagmutq1;
	int NewNinputq0, NewNinputq1;
	float clasiRateEq0, clasiRateVq0;
    float clasiRateEq1, clasiRateVq1;
	float fitAntesMutq0, fitAntesMutq1;
	float fracMut;
	int flag_muttypeq0, flag_muttypeq1;
	int genmutq0, genmutq1;
		
	NfitEval       = 0;
	NfitEvalAux    = 0;
    fitnessBestAux = 0.0f;
    cromoBestAux   = (char *) malloc((p->largo+1) * sizeof(char));
	(*fitIncCross) = 0;
	(*fitDifCross) = 0.0f;
	(*fitIncMut)   = 0;
	(*fitDifMut)   = 0.0f;
	(*TotMut)      = 0;
	fracMut        = fracFitMut * (*fitnessBestGen);
	
	if(mut_option != 0)
	{
   		for(i=0; i < 4; i++)
	 		for(j=0; j < 3; j++)
	 			mut_eff[i][j] = 0.0f;
	}
	

	q = nuevaPoblacion(2, p->largo);
	/* Randomiza el orden de la poblacion para poder parear 
	individuos consecutivos */
	mezclarPoblacion(p);
	
	for(i=0; i < p->tamano; i+=2)
	{
		/* Crossover entre padres seleccionados */
		func_crossover(leerIndividuo(p, i), leerIndividuo(p, i+1),
					   &leerIndividuo(q, 0), &leerIndividuo(q, 1), 1.0f);
	   
  		/* Fitness hijo q0 despues de crossover */
		leerFitness(leerIndividuo(q, 0)) = func_fitness(leerIndividuo(q, 0), Input_E,
                  Target_E, Input_V, Target_V, Weight_IH, Weight_HO, Ntrain, Nval,
                  Ninput, Nhidden, Noutput, Epochs, valStep, Epsi, minError,
                  lambdaMax, lambdaMin, SseE, SseV, clasiRateE, clasiRateV,
                  targetIdxE, targetIdxV, qele, SimId, costRatio, NewNinput);

		NewNinputq0   = *NewNinput;
		clasiRateEq0  = ( 100 * ((*clasiRateE) / (float)Ntrain) );
		clasiRateVq0  = ( 100 * ((*clasiRateV) / (float)Nval) );
		fitAntesMutq0 = leerFitness(leerIndividuo(q, 0));

		/* Fitness hijo q1 despues de crossover */
		leerFitness(leerIndividuo(q, 1)) = func_fitness(leerIndividuo(q, 1), Input_E,
                  Target_E, Input_V, Target_V, Weight_IH, Weight_HO, Ntrain, Nval,
                  Ninput, Nhidden, Noutput, Epochs, valStep, Epsi, minError,
                  lambdaMax, lambdaMin, SseE, SseV, clasiRateE, clasiRateV,
                  targetIdxE, targetIdxV, qele, SimId, costRatio, NewNinput);

         NewNinputq1   = *NewNinput;
		 clasiRateEq1  = ( 100 * ((*clasiRateE) / (float)Ntrain) );
		 clasiRateVq1  = ( 100 * ((*clasiRateV) / (float)Nval) );           	
         fitAntesMutq1 = leerFitness(leerIndividuo(q, 1));		   
		
		/* Muta los nuevos individuos (hijos) */
		flagmutq0 = flagmutq1 = 0;
		if (mut_option != 0)
		{
			/* Mutacion si fitness_q0 >= (fracMut) */
			if( leerFitness(leerIndividuo(q, 0)) >= fracMut )
			{
				/* Mutacion hijo q0 */
				if( (flag_muttypeq0 = func_mutacion(leerIndividuo(q, 0), ranking,
                                           MIMatrix, MIClases, Entropy, PbbMutVector,
                                           Pbbadd, Pbbirrel, &genmutq0)) != 0 )
				{
					leerFitness(leerIndividuo(q, 0)) = func_fitness(leerIndividuo(q, 0),
	                            Input_E, Target_E, Input_V, Target_V, Weight_IH, Weight_HO,
	                            Ntrain, Nval, Ninput, Nhidden, Noutput, Epochs, valStep,
	                            Epsi, minError, lambdaMax, lambdaMin, SseE, SseV,
	                            clasiRateE, clasiRateV, targetIdxE, targetIdxV, qele,
	                            SimId, costRatio, NewNinput);
                    
                    (*TotMut)++;
                    (mut_eff[flag_muttypeq0][2])++;
                    /* Mantiene cromosoma mutado si Fit_After_Mut > Fit_Before_Mut */
                    if( fitAntesMutq0 < leerFitness(leerIndividuo(q, 0)) )
	                {
                 		NewNinputq0  = *NewNinput;
				        clasiRateEq0 = ( 100 * ((*clasiRateE) / (float)Ntrain) );
				        clasiRateVq0 = ( 100 * ((*clasiRateV) / (float)Nval) ); 
		          		flagmutq0 = 1;
          		    }
          		    else		/* Deshace mutacion */
          		    {
          		    	leerFitness(leerIndividuo(q, 0)) = fitAntesMutq0;
          		    	if(flag_muttypeq0 == 1)		/* Mutacion agrego caract */
          		    	{
          		    		((q)->individuos[(0)])->cromo[(genmutq0)] = 0;
                 		}
          		    	else if( (flag_muttypeq0 == 2) || (flag_muttypeq0 == 3) )
          		    	{
          		    		((q)->individuos[(0)])->cromo[(genmutq0)] = 1;
                 		}
                	}
	   			}
  			}
  			
  			/* Mutacion si fitness_q1 >= (fracMut) */
			if( leerFitness(leerIndividuo(q, 1)) >= fracMut )
			{
				/* Mutacion hijo q1 */
	            if( (flag_muttypeq1 = func_mutacion(leerIndividuo(q, 1), ranking,
                                           MIMatrix, MIClases, Entropy, PbbMutVector,
                                           Pbbadd, Pbbirrel, &genmutq1)) != 0 )
	            {
	            	leerFitness(leerIndividuo(q, 1)) = func_fitness(leerIndividuo(q, 1),
	                            Input_E, Target_E, Input_V, Target_V, Weight_IH, Weight_HO,
	                            Ntrain, Nval, Ninput, Nhidden, Noutput, Epochs, valStep,
	                            Epsi, minError, lambdaMax, lambdaMin, SseE, SseV,
	                            clasiRateE, clasiRateV, targetIdxE, targetIdxV, qele,
	                            SimId, costRatio, NewNinput);

                    (*TotMut)++;
                    (mut_eff[flag_muttypeq1][2])++;
                    /* Mantiene cromosoma mutado si Fit_After_Mut > Fit_Before_Mut */
                    if( fitAntesMutq1 < leerFitness(leerIndividuo(q, 1)) )
	                {
                 		NewNinputq1  = *NewNinput;
                 		clasiRateEq1 = ( 100 * ((*clasiRateE) / (float)Ntrain) );
                 		clasiRateVq1 = ( 100 * ((*clasiRateV) / (float)Nval) );
                 		flagmutq1 = 1;                 		
          		    }
          		    else		/* Deshace mutacion */
          		    {
          		    	leerFitness(leerIndividuo(q, 1)) = fitAntesMutq1;
          		    	if(flag_muttypeq1 == 1)		/* Mutacion agrego caract */
          		    	{
          		    		((q)->individuos[(1)])->cromo[(genmutq1)] = 0;
                 		}
          		    	else if( (flag_muttypeq1 == 2) || (flag_muttypeq1 == 3) )
          		    	{
          		    		((q)->individuos[(1)])->cromo[(genmutq1)] = 1;
                 		}
                	}
	            }  
            }
		}

		/* N of fitness evaluations */
		NfitEval += 2;
		NfitEvalAux = (*NfitEvalBest) + NfitEval;
		
		/* Realiza la sustitucion en la poblacion de acuerdo a 
		al distancia entre padres e hijos y al fitness de estos */
		if( func_dist(leerIndividuo(p, i), leerIndividuo(q, 0)) + 
            func_dist(leerIndividuo(p, i+1), leerIndividuo(q, 1))
		  < func_dist(leerIndividuo(p, i), leerIndividuo(q, 1)) +
		    func_dist(leerIndividuo(p, i+1), leerIndividuo(q, 0)) )
		{
			if( leerFitness(leerIndividuo(q, 0)) > leerFitness(leerIndividuo(p, i)) )
			{
				/* Mejor individuo Generacion */
				isBestHijo(leerFitness(leerIndividuo(q, 0)), clasiRateEq0,
                           clasiRateVq0, NfitEvalAux, NewNinputq0, leerIndividuo(q, 0),
                           &fitnessBestAux, &clasiRateBestAuxE, &clasiRateBestAuxV,
                           &NfitEvalBestAux, &NinputBestAux, cromoBestAux);
				/* Eficiencia crossover */
				if( fitAntesMutq0 > leerFitness(leerIndividuo(p, i)) )
				{
					(*fitIncCross)++;
					(*fitDifCross) += (fitAntesMutq0 - leerFitness(leerIndividuo(p, i)));
				}				
				/* Eficiencia mutacion */
				if(flagmutq0 == 1)
				{
					(*fitIncMut)++;
					(mut_eff[flag_muttypeq0][0])++;
					(*fitDifMut) += (leerFitness(leerIndividuo(q, 0)) - fitAntesMutq0);
     				mut_eff[flag_muttypeq0][1] += (leerFitness(leerIndividuo(q, 0)) - fitAntesMutq0);	
    			}
    			/* Reemplazar individuo en la nueva poblacion */
				copiarCromosoma(leerIndividuo(p, i), leerIndividuo(q, 0));
			}

			if( leerFitness(leerIndividuo(q, 1)) > leerFitness(leerIndividuo(p, i+1)) )
			{
				/* Mejor individuo generacion */
				isBestHijo(leerFitness(leerIndividuo(q, 1)), clasiRateEq1,
                           clasiRateVq1, NfitEvalAux, NewNinputq1, leerIndividuo(q, 1),
                           &fitnessBestAux, &clasiRateBestAuxE, &clasiRateBestAuxV,
                           &NfitEvalBestAux, &NinputBestAux, cromoBestAux);
				/* Eficiencia crossover */
				if( fitAntesMutq1 > leerFitness(leerIndividuo(p, i+1)) )
				{
					(*fitIncCross)++;
					(*fitDifCross) += (fitAntesMutq1 - leerFitness(leerIndividuo(p, i+1)));
				}				
				/* Eficiencia mutacion */
				if(flagmutq1 == 1)
				{
					(*fitIncMut)++;
					(mut_eff[flag_muttypeq1][0])++;
					(*fitDifMut) += (leerFitness(leerIndividuo(q, 1)) - fitAntesMutq1);	
					mut_eff[flag_muttypeq1][1] += (leerFitness(leerIndividuo(q, 1)) - fitAntesMutq1);
    			}			
				/* Reemplazar individuo en la nueva poblacion */
				copiarCromosoma(leerIndividuo(p, i+1), leerIndividuo(q, 1));
			}
		}
		else
		{
			if( leerFitness(leerIndividuo(q, 0)) > leerFitness(leerIndividuo(p, i+1)) )
			{
				/* Mejor individuo generacion */
				isBestHijo(leerFitness(leerIndividuo(q, 0)), clasiRateEq0,
                           clasiRateVq0, NfitEvalAux, NewNinputq0, leerIndividuo(q, 0),
                           &fitnessBestAux, &clasiRateBestAuxE, &clasiRateBestAuxV,
                           &NfitEvalBestAux, &NinputBestAux, cromoBestAux);
				/* Eficiencia crossover */
				if( fitAntesMutq0 > leerFitness(leerIndividuo(p, i+1)) )
				{
					(*fitIncCross)++;
					(*fitDifCross) += (fitAntesMutq0 - leerFitness(leerIndividuo(p, i+1)));
				}				
				/* Eficiencia mutacion */
				if(flagmutq0 == 1)
				{
					(*fitIncMut)++;
					(mut_eff[flag_muttypeq0][0])++;
					(*fitDifMut) += (leerFitness(leerIndividuo(q, 0)) - fitAntesMutq0);
     				mut_eff[flag_muttypeq0][1] += (leerFitness(leerIndividuo(q, 0)) - fitAntesMutq0);	
    			}			
				/* Reemplazar individuo en la nueva poblacion */
				copiarCromosoma(leerIndividuo(p, i+1), leerIndividuo(q, 0));
			}

			if( leerFitness(leerIndividuo(q, 1)) > leerFitness(leerIndividuo(p, i)) )
			{
				/* Mejor individuo generacion */
				isBestHijo(leerFitness(leerIndividuo(q, 1)), clasiRateEq1,
                           clasiRateVq1, NfitEvalAux, NewNinputq1, leerIndividuo(q, 1),
                           &fitnessBestAux, &clasiRateBestAuxE, &clasiRateBestAuxV,
                           &NfitEvalBestAux, &NinputBestAux, cromoBestAux);
				/* Eficiencia crossover */
				if( fitAntesMutq1 > leerFitness(leerIndividuo(p, i)) )
				{
					(*fitIncCross)++;
					(*fitDifCross) += (fitAntesMutq1 - leerFitness(leerIndividuo(p, i)));
				}				
				/* Eficiencia mutacion */
				if(flagmutq1 == 1)
				{
					(*fitIncMut)++;
					(mut_eff[flag_muttypeq1][0])++;
					(*fitDifMut) += (leerFitness(leerIndividuo(q, 1)) - fitAntesMutq1);	
			 		mut_eff[flag_muttypeq1][1] += (leerFitness(leerIndividuo(q, 1)) - fitAntesMutq1);
    			}						
				/* Reemplazar individuo en la nueva poblacion */
				copiarCromosoma(leerIndividuo(p, i), leerIndividuo(q, 1));
			}
		}
	}

	/* Si Fitness_mejor_hijo > Fitness_mejor_padre, se copia como mejor de la
       generacion. Sino el mejor sera el mismo de la generacion anterior */
	if(fitnessBestAux > (*fitnessBestGen))
	{
		(*fitnessBestGen)    = fitnessBestAux;
		(*clasiRateBestGenE) = clasiRateBestAuxE;
		(*clasiRateBestGenV) = clasiRateBestAuxV;
		(*NinputBestGen)     = NinputBestAux;
		(*NfitEvalBest)      = NfitEvalBestAux;
		strcpy(cromoBestGen, cromoBestAux);	
 	}
 	else
    {
		(*NfitEvalBest) += NfitEval;
	}
	
	free(cromoBestAux);
	destruirPoblacion(q);
}

/******************************************************************************/

