
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "fifoqueues.h"
#include "minfomodr.h"
#include "memoria.h"

#define ALG_AMIFS_TIME_SERIE		0
#define ALG_MIFS					1
#define ALG_IMIFS					2
#define ALG_AMIFS					3
#define ALG_AMIFS_NORM				4
#define ALG_TMIFS2					5
#define ALG_TMIFS3					6
#define ALG_TMIFS4					7
#define ALG_MIFSMODPO	 			8
#define ALG_AMIFS_NORM_TIME_SERIE	9

#define MATRIX_MI	"matrix_MI.txt"		/* matriz de MI */
#define MATRIX_QM	"matrix_QM.txt"		/* matriz de MI normalizada */
#define F_MICLASES	"mutinfo_CF.txt"	/* Vector I(C;F) */
#define F_ENTROPY	"entropy.txt"		/* Vector de entropias de caracts */


/**************************************************************/

FifoQueue mifs(FifoQueue FSet, int C[], float H[], int ne, int nc, int k,
			   float beta, int algoritmo, char *OutpFileName, char *DataFileName,
   			   char *ClssFileName, char *alg_name, int reporte, int *FeatType)
{
	FifoQueue F, S;
	int i, n;
	float Hc, Hnorm;				/* Entropia clase para casos de series de tiempo */

	int *f, *y;
	
	/* Elemento maximo de una caracteristica cuantificada*/
	int max;

	/* Datos para el algoritmo */
	float *MI;				/* Arreglo con la informacion */
							/* mutua entre caracteristica */
							/* y clase                    */
 	
	float minfoFF;			/* MI entre 2 caracteristicas */

	/* GENERALES : ULTIMO VECTOR SELECCIONADO DURANTE UNA PASADA */
	float *SUM;				/* Arreglo con la informacion */
							/* mutua acumulativa          */
	float  maxMIval;		/* mximo MI acumulado        */
	int   *maxMIvec;		/* ltimo vector de mximo MI */
	int    maxMIidx;		/* ndice en MI del mximo MI */

	/* INFORMACION SOBRE ULTIMO VECTOR SELECCIONADO */
	int    *lastMI;			/* ltimo vector seleccionado */
	int     lastIdx;		/* ultimo indice seleccionado */

	int countlast, count, Total;	/* variables para el reporte */
	
	/* Variables para calcular matriz de MI y MI normalizada */
    int j, cont;
	int **base;				/* Matriz de datos (N_features x M_examples) */
	int *f1, *f2;			/* Vectores auxiliars para el calculo de I(f_i;f_j) */
	float tirala1, tirala2;
	
	/* Archivos de salida */
	FILE *OutFile;			/* Ranking de caracteristicas */
	FILE *MiMatrix;			/* Archivo de salida, imprime matriz de MI (C-F) y F-F */
	FILE *MIClases;			/* Guarda I(C;F) */
	FILE *Entropy;			/* Guarda la entropia de las caracts */
	FILE *Troubles;			/* Archivo de salida, imprime las caracts
							   cuya MI es mayor a la menor entropia de ambas */ 					  
	Troubles = fopen("troubles.txt", "w");
	
    /* abrir archivos de salida */    						
	if ( (reporte == 2) || (reporte == 4) || (reporte == 6) )
		MiMatrix = fopen(MATRIX_MI, "w");
   	else if ( (reporte == 3) || (reporte == 5) )
    	MiMatrix = fopen(MATRIX_QM, "w");	
    	
   	if(reporte == 6)
	{
		MIClases = fopen(F_MICLASES, "w");
		Entropy  = fopen(F_ENTROPY, "w");
	}
	
	if( (reporte != 2) && (reporte != 3) )
		OutFile = fopen(OutpFileName, "w");

	/* Inicializacin */
	F	 = FSet;
	S    = MakeFifoQueue();
	n    = LengthFifoQueue(FSet);
	f    = (int *) malloc(sizeof(int) * (ne+1));
	MI   = (float *) malloc(sizeof(float) * (n+1));
	SUM  = (float *) malloc(sizeof(float) * (n+1));
	base = matrizInt(n, ne+1);
	

	/* Reporte */
	countlast = count = 0;
	Total = n - k * k / 2 + k * (2 * n + 1) / 2 - n;
	printf(" ---10---20---30---40---50---60---70---80---90--100 %%\n ");
	
	if( (reporte == 3) || (reporte == 5) )
		fprintf(MiMatrix, "Informacion Aportada a las Clases\n\n");
	
	
	/* Cmputo de I(C;F) */
	maxMIval = 0.0f;
	maxMIvec = NULL;
	for(i=1; i<=n; ++i)
	{
		int idx;
		y = (int *) GetObj(F);
		PutObj(F, (void*) y);
		idx = y[0];								/* y[0] = N de la caracteristica */
		
		/* Matriz de Caracteristicas */
		if( (reporte != 0) && (reporte != 1) )
		{
			for(j=0; j < ne+1; j++)
			{
				base[i-1][j] = y[j];
	  		}
  		}

		/* Modificacion MTT */
		if(FeatType[idx-1] == 0)				/* 0 -> Caracteristica Discreta */
		{
			MI[idx] = mutualInfoDD(y, C, ne);
			SUM[idx] = 0.0f;
		}
		else									/* 1 -> Caracteristica Continua */
		{
			if( (algoritmo == ALG_AMIFS_TIME_SERIE) || (algoritmo == ALG_AMIFS_NORM_TIME_SERIE) )
			{
				Hc = H[1];
				connFeat(y, C, f, ne);
				max = last(f, ne);
				MI[idx]  = mutualInfoFF(f, 1, ne, 0, max);
				SUM[idx] = 0.0f;
   			}
   			else
   			{
   				connFeat(y, C, f, ne);
   				MI[idx]  = mutualInfoCF(f, 1, ne, nc);
   				SUM[idx] = 0.0f;
      		}
		}
		
		/* Problemas con 0s */
		if( COMP(MI[idx], 0.0f) )
	   		MI[idx] = 0.0f;
	   		
		/* Problemas de inconsistencia */
		if( MI[idx] > H[idx] )
	 		fprintf(Troubles, "C - f%-2d\n", idx);
		
		/* Reporte */
		count++;
		while ((countlast + 2) * (Total / 100.0) < count)
		{
			printf(".");
			fflush(stdout);
			countlast += 2;
		}
			
		/* Reporte */
		if (reporte != 0)
		{
			if( (reporte == 3) || (reporte == 5) )
			{
  				fprintf(MiMatrix, "QM(C , f%-3d) = %5.2f\n", idx, 100*MI[idx]);
			}
			else if( (reporte == 1) || (reporte == 4) )
			{
				fprintf(OutFile, "I(C , f%-3d) = %5.5f \t H(f%-3d) = %5.5f\n",
    								  idx, MI[idx], idx, H[idx]);
		        if(reporte == 4)
		        	fprintf(MiMatrix, "I(C , f%-3d) = %5.5f \t H(f%-3d) = %5.5f\n",
    								  idx, MI[idx], idx, H[idx]);
   			}
   			else if(reporte == 2)
   			{
   				fprintf(MiMatrix, "I(C , f%-3d) = %5.5f \t H(f%-3d) = %5.5f\n",
    								  idx, MI[idx], idx, H[idx]);
		    }
		    else if(reporte == 6)
   			{
   				fprintf(MIClases, "%5.5f\n", MI[idx]);
		        fprintf(Entropy, "%5.5f\n", H[idx]);
		    }
		}

		if ( (maxMIval < MI[idx]) || (i == 1) )
		{
			maxMIval = MI[idx];
			maxMIvec = y;
			maxMIidx = idx;
		}
	}

	if( (reporte != 2) && (reporte != 3) )
	{
		/* maxMIvec es la mejor caracterstica  */
		/* sacarla de F, agregarla a S y borrar */
		/* su MI correspondiente del arreglo    */
		PutObj(S, (void*) maxMIvec);
		DeleteObj(F, (void*) maxMIvec);
	
		/* almacenar el vector y el indice de */
		/* la caracteristica seleccionada     */
		lastMI  = maxMIvec;
		lastIdx = maxMIidx;
	
		/* Reporte */
		if( (reporte == 1) || (reporte == 4) )
		{
  			fprintf(OutFile, "+-------------------+\n");
			fprintf(OutFile, "| Seleccionada f%-3d |\n", lastIdx);
			fprintf(OutFile, "+-------------------+\n\n");
		}
	}

	
	/* Reporte: Marices de MI y MI normalizada */
	if( (reporte != 0) && (reporte != 1) )
	{
		if(reporte != 6)
		{
			fprintf(MiMatrix, "\n");
			if( (reporte == 3) || (reporte == 5) )
				fprintf(MiMatrix, "\n\nRedundancia entre Variables\n\n");
			
			fprintf(MiMatrix, "Feat");
			for(i=1; i <= n; i++)
				fprintf(MiMatrix, "\tf%d", i);
			
			fprintf(MiMatrix, "\n");
		}
		
	 	/* Calculo MI entre caracteristicas */
	 	f1 = (int *) malloc( (ne+1) * sizeof(int) );
		f2 = (int *) malloc( (ne+1) * sizeof(int) );
	 	cont = 0;
		for(i=0; i < n; i++)
		{
			if(reporte == 6)
			{
				for(j=0; j < n; j++)
				{
					int k, idx1, idx2;
					idx1 = base[i][0];
					idx2 = base[j][0];
					
					for(k=0; k <= ne; k++)
					{
						f1[k] = base[i][k];
						f2[k] = base[j][k];
	    			}
	    			
		   			/* Calculo MI dependiendo naturaleza de las variables */
		    		if((FeatType[idx1-1] == 0) && (FeatType[idx2-1] == 0))
					{
						minfoFF = mutualInfoDD(f1, f2, ne);
					}
					/* La 1ra caracteristica discreta y la 2da continua */
					else if((FeatType[idx1-1] == 0) && (FeatType[idx2-1] == 1))
					{
						minfoFF = mutualInfoDF(f1, f2, ne);
					}
					/* La 1ra caracteristica continua y la 2da discreta */
					else if((FeatType[idx1-1] == 1) && (FeatType[idx2-1] == 0))
					{
						minfoFF = mutualInfoDF(f1, f2, ne);
					}
					/* Ambas caracteristicas continuas */
					else
					{
						connFeat(f1, f2, f, ne);
						max = last(f, ne);
						minfoFF = mutualInfoFF(f, 1, ne, 0, max);
					}
					
					if( COMP(minfoFF, 0.0f) )
		   				minfoFF = 0.0f;
		         	
             		/* Escritura de matriz */	
       		        fprintf(MiMatrix, "%5.5f ", minfoFF);
	     			    		
		    		/* Troubles */
		      		if( ((minfoFF > H[idx1]) && (H[idx1] > 0))
	     			 	|| ((minfoFF > H[idx2]) && (H[idx2] > 0)) )
	 			 	{
		 				fprintf(Troubles, "f%-2d - f%-2d\n", idx1, idx2);
					}
		 		}
   			}
			else
			{
				fprintf(MiMatrix, "f%d", i+1);
				
	   			for(j=0; j <= cont; j++)
	   				fprintf(MiMatrix, "\t");
			    cont++;
					
				for(j=i+1; j < n; j++)
				{
					int k, idx1, idx2;
					idx1 = base[i][0];
					idx2 = base[j][0];
					
					for(k=0; k <= ne; k++)
					{
						f1[k] = base[i][k];
						f2[k] = base[j][k];
	    			}
	    			
		   			/* Calculo MI dependiendo naturaleza de las variables */
		    		if((FeatType[idx1-1] == 0) && (FeatType[idx2-1] == 0))
					{
						minfoFF = mutualInfoDD(f1, f2, ne);
					}
					/* La 1ra caracteristica discreta y la 2da continua */
					else if((FeatType[idx1-1] == 0) && (FeatType[idx2-1] == 1))
					{
						minfoFF = mutualInfoDF(f1, f2, ne);
					}
					/* La 1ra caracteristica continua y la 2da discreta */
					else if((FeatType[idx1-1] == 1) && (FeatType[idx2-1] == 0))
					{
						minfoFF = mutualInfoDF(f1, f2, ne);
					}
					/* Ambas caracteristicas continuas */
					else
					{
						connFeat(f1, f2, f, ne);
						max = last(f, ne);
						minfoFF = mutualInfoFF(f, 1, ne, 0, max);
					}
					
					if( COMP(minfoFF, 0.0f) )
		   				minfoFF = 0.0f;
		         		
	              	if( (reporte == 2) || (reporte == 4) )		
	              	{
		    			fprintf(MiMatrix, "\t%5.5f", minfoFF);
	 				}
	     			else
		    		{	
		    			if( H[idx1] < H[idx2] )
			    			fprintf( MiMatrix, "\t%5.2f", 100*(minfoFF / H[idx1]) );
						else
			    			fprintf( MiMatrix, "\t%5.2f", 100*(minfoFF / H[idx2]) );
	  				}
		    		
		    		/* Troubles */
		      		if( ((minfoFF > H[idx1]) && (H[idx1] > 0))
	     			 	|| ((minfoFF > H[idx2]) && (H[idx2] > 0)) )
	 			 	{
		 				fprintf(Troubles, "f%-2d - f%-2d\n", idx1, idx2);
					}
		 		}
	 		}
			printf("%d ", i+1);
		 	fprintf(MiMatrix, "\n");	
	 	}
	 	free(f1);
	 	free(f2);
 	}
	

	/* Seleccion de Caracteristicas */
	if( (reporte != 2) && (reporte != 3) )
	{
  		while(LengthFifoQueue(S) < k)
		{
			/* Calcular los discriminantes para seleccionar */
			/* la proxima caracteristica a incluir en S     */
	
			int nF, nS;
			nF = LengthFifoQueue(F);
			nS = n - nF;

			for(i=1; i<=nF; ++i)
			{
				int idx;
				float dependency;
	
				y = (int *) GetObj(F);
				PutObj(F, (void*) y);
				idx = y[0];
				
				/* Calculo de MI segun el tipo de caracteristica */
				/* Ambas caracteristicas discretas */
				if((FeatType[idx-1] == 0) && (FeatType[lastMI[0]-1] == 0))
				{
					minfoFF = mutualInfoDD(lastMI, y, ne);
				}
				/* La 1ra caracteristica discreta y la 2da continua */
				else if((FeatType[idx-1] == 0) && (FeatType[lastMI[0]-1] == 1))
				{
					minfoFF = mutualInfoDF(y, lastMI, ne);
				}
				/* La 1ra caracteristica continua y la 2da discreta */
				else if((FeatType[idx-1] == 1) && (FeatType[lastMI[0]-1] == 0))
				{
					minfoFF = mutualInfoDF(lastMI, y, ne);
				}
				/* Ambas caracteristicas continuas */
				else
				{
					connFeat(lastMI, y, f, ne);
					max = last(f, ne);
					minfoFF = mutualInfoFF(f, 1, ne, 0, max);
				}
				
				if( COMP(minfoFF, 0.0f) )
	   				minfoFF = 0.0f;
	
				/* BIFURCACION SEGUN ALGORITMO : CALCULAR SUMATORIA */
				if (algoritmo == ALG_MIFS)
				{
					dependency = minfoFF;
					SUM[idx]  += dependency;
				}
				else if (algoritmo == ALG_IMIFS)
				{
					dependency = (MI[lastIdx] / H[lastIdx]) * minfoFF;
					SUM[idx]  += dependency; 
				}
				else if ( (algoritmo == ALG_AMIFS) || (algoritmo == ALG_AMIFS_TIME_SERIE)
                          || (algoritmo == ALG_AMIFS_NORM) || (algoritmo == ALG_AMIFS_NORM_TIME_SERIE) )
				{
				    if (H[lastIdx] < H[idx])
						dependency = minfoFF / (nS * H[lastIdx]);
					else
						dependency = minfoFF / (nS * H[idx]);

					SUM[idx] += dependency; 
				}
				else if (algoritmo == ALG_TMIFS2)
				{
				    dependency = minfoFF / (nS);
				//	dependency = minfoFF / (nS * H[lastIdx]);
					SUM[idx] += dependency; 
				}
				else if (algoritmo == ALG_TMIFS3)
				{
					dependency = minfoFF / (nS * H[lastIdx] * H[idx]);
					SUM[idx] += dependency; 
				}
				else if (algoritmo == ALG_TMIFS4)
				{
					dependency = (MI[idx] * minfoFF) / H[lastIdx];
					SUM[idx] += dependency; 
				}
				else if (algoritmo == ALG_MIFSMODPO)
				{
					/* Evitar division por 0 */
	   				if( COMP(MI[idx], 0.0f) )
	   					MI[idx] = 0.00001f;
				
					dependency = (MI[lastIdx] / (nS * H[lastIdx] * MI[idx])) * minfoFF;
					SUM[idx] += dependency; 
				}
				
				/* Normalizacion clases */
				if(algoritmo == ALG_AMIFS_NORM)
				{
					Hnorm = log(nc) * 1.4426f;
    			}
    			else if(algoritmo == ALG_AMIFS_NORM_TIME_SERIE)
    			{
  					if(Hc <= H[idx])
     				{
     					Hnorm = Hc;
  					}
  					else
  					{
  						Hnorm = H[idx];
       				}
       			}
								
				/* Reporte */
				count++;
				while ((countlast + 2) * (Total / 100.0) < count)
				{
					printf(".");
					fflush(stdout);
					countlast += 2;
				}
	
				if ( (reporte == 1) || (reporte == 4) )
				{
					if( (algoritmo == ALG_AMIFS_NORM) || (algoritmo == ALG_AMIFS_NORM_TIME_SERIE) )
					{
						fprintf(OutFile, "I(f%-3d, f%-3d) = %5.5f \t"
      									 " (I(C, F)/max_I(C, F)) - %5.2f * sum I(S, f%-3d) = %5.5f\n",
								 		 lastIdx, idx, minfoFF, beta, idx,
            							 ((MI[idx] / Hnorm) - beta * SUM[idx]) );
         			}
     				else
     				{
						fprintf(OutFile, "I(f%-3d, f%-3d) = %5.5f \t"
      									 " I(C, F) - %5.2f * sum I(S, f%-3d) = %5.5f\n",
								 		 lastIdx, idx, minfoFF, beta, idx,
            							 (MI[idx] - beta * SUM[idx]) );
				    }
				}
				
				if( (algoritmo == ALG_AMIFS_NORM) || (algoritmo == ALG_AMIFS_NORM_TIME_SERIE) )
				{
					if( ( (maxMIval < ((MI[idx] / Hnorm) - beta*SUM[idx]))
	                       && !COMP(maxMIval, ((MI[idx] / Hnorm) - beta*SUM[idx])) ) || (i == 1) )
					{
								maxMIval = (MI[idx] / Hnorm) - beta*SUM[idx];
								maxMIvec = y;
								maxMIidx = idx;
					}
    			}
    			else
    			{
					if( ( (maxMIval < (MI[idx] - beta*SUM[idx]))
	                       && !COMP(maxMIval, (MI[idx] - beta*SUM[idx])) ) || (i == 1) )
					{
								maxMIval = MI[idx] - beta*SUM[idx];
								maxMIvec = y;
								maxMIidx = idx;
					}
				}
			}
	
			PutObj(S, (void*) maxMIvec);
			DeleteObj(F, (void*) maxMIvec);
	
			lastMI  = maxMIvec;
			lastIdx = maxMIidx;
	
			/* Reporte */
			if( (reporte == 1) || (reporte == 4) )
   			{
      			fprintf(OutFile, "+-------------------+\n");
				fprintf(OutFile, "| Seleccionada f%-3d |\n", lastIdx);
				fprintf(OutFile, "+-------------------+\n\n");
			}
		}
	}
	/* Reporte */
	printf(".\n");
	
		
	if( (reporte != 2) && (reporte != 3) )
	{
		fprintf(OutFile, "\nArchivo de Datos:     %s\n", DataFileName);
		fprintf(OutFile, "Archivo de Etiquetas: %s\n\n", ClssFileName);
		fprintf(OutFile, "Beta: %2.2f\n\n", beta);
		fprintf(OutFile, "Resultados:\nCaractersticas Seleccionadas"
  						 " (en Orden) por %s\n", alg_name);
		fprintf(OutFile, "---------------------------------------------\n");
		for (i=0; i < k; ++i)
		{
			if(i % 5  == 0)
				fprintf(OutFile, "\t");
			if(i % 10 == 0)
				fprintf(OutFile, "\n");
		
   			y = (int *) GetObj(S);
			PutObj(S, (void *) y);
			
			fprintf(OutFile, " %3d", y[0]);
		}
		fprintf(OutFile, "\n\n---------------------------------------------\n");
		fclose(OutFile);
	}
	
	fclose(Troubles);	
	if( (reporte != 0) && (reporte != 1) )
		fclose(MiMatrix);
	if(reporte == 6)
	{
		fclose(MIClases);
		fclose(Entropy);
 	}
	
	return S;
}

/**************************************************************/

