#include <stdlib.h>
#include <stdio.h>
#include "fifoqueues.h"

/*************************************************************
 * Implementacion del manejo de colas FIFO
 *
 * Pura fuerza bruta, no es necesario mirar este codigo
 *
 *************************************************************/

typedef struct FifoQueueElem
{
  struct FifoQueueElem* next;
  void* obj;
} FifoQueueElem;

FifoQueue MakeFifoQueue() /* Puede ser llamada de cualquier parte */
{
  FifoQueue queue= (FifoQueue) malloc(sizeof(*queue));
  queue->first= NULL;
  queue->last= &queue->first;
  queue->len= 0;

  return queue;
}

void PutObj(FifoQueue queue, void* obj)
{
  FifoQueueElem* elem= (FifoQueueElem*)malloc(sizeof *elem);

  elem->obj= obj;
  elem->next= NULL;

  if (*(queue->last)!=NULL)
    printf("PutObj - Inconsistencia, last no es el ultimo\n");
  *(queue->last)= elem;
  queue->last= &elem->next;

  queue->len++;
}

void PushObj(FifoQueue queue, void* obj)
{
  FifoQueueElem* elem= (FifoQueueElem*)malloc(sizeof *elem);
  elem->obj= obj;
  elem->next= queue->first;
  queue->first= elem;
  if (elem->next==NULL) queue->last= &elem->next;

  queue->len++;
}

void* GetObj(FifoQueue queue)
{
  FifoQueueElem* elem;
  void* obj;

  elem= queue->first;
  if (elem==NULL) return NULL;

  queue->first= elem->next;
  if (queue->first==NULL) queue->last= &queue->first;

  obj= elem->obj;
  free(elem);

  queue->len--;

  return obj;
}

int QueryObj(FifoQueue queue, void* obj)
{
  FifoQueueElem* elem= queue->first;
  while (elem!=NULL && elem->obj!=obj)
    elem= elem->next;
  return elem!=NULL;
}

void DeleteObj(FifoQueue queue, void* obj)
{
  FifoQueueElem** pelem= &queue->first;

  while (*pelem!=NULL && (*pelem)->obj!=obj)
    pelem= &(*pelem)->next;

  if (*pelem!=NULL)
  {
    FifoQueueElem* elem= *pelem;
    *pelem= elem->next;
    if (elem->next==NULL)
    {
      if (queue->last!=&elem->next)
        printf("DeleteObj - Inconsistencia, next es nulo y no es el ultimo\n");
      queue->last= pelem;
    }
    else if (queue->last==&elem->next)
      printf("DeleteObj - Inconsistencia, elem no es el ultimo\n");
    free(elem);
    queue->len--;
  }
}

int EmptyFifoQueue(FifoQueue queue)
{
  return queue->first==NULL;
}

int LengthFifoQueue(FifoQueue queue)
{
  return queue->len;
}

void DestroyFifoQueue(FifoQueue queue)
{
  if (!EmptyFifoQueue(queue))
    printf("DestroyFifoQueue - Se destruye una cola con tareas pendientes\n");

  free(queue); /* Se supone que no hay procesos colgando */
}
