/***********************************************************************
*                             "mutacion.h"	   						   *
*				Implementacion de distintos tipos de mutaciones		   *
***********************************************************************/

/* Crea un vector de probabilidades decrecientes "linealmente" a partir
   de un ranking de caracts */
void pbbMutacionLineal(int *ranking, float *pbbMutVector, float Pb, float Pw,
                       int Nfeatures);

/* Crea un vector de probabilidades decrecientes "exponencialmente" a partir
   de un ranking de caracts */
void pbbMutacionExponencial(int *ranking, float *pbbMutVector, float Pb, float Pw,
                            int Nfeatures);

/* Crea un vector de probabilidades decrecientes "exponencialmente por partes"
   a partir de un ranking de caracts */
void pbbMutacionExponencialPartes(int *ranking, float *pbbMutVector, float Pb,
                                  float Pm, float Pw, int Nfeatures);

/* Muta cada gen de un cromosoma con probabilidad pbb */
int mutacionAleatoriaCromosoma(cromosoma c, float pbb);

/* Mutacion AMIFS dinamico */
int mutacionAMIFS(cromosoma c, int *ranking, float **MIMatrix, float *MIClases,
                  float *Entropy, float *PbbMutVector, float Pbbadd,
                  float Pbbirrel, int *genmut);
                                
/* Mutacion definiendo pbb de mutacion mediante ranking entregado por AMIFS */
int mutacionRankingAMIFS(cromosoma c, int *ranking, float **MIMatrix,
                         float *MIClases, float *Entropy, float *PbbMutVector,
                         float Pbbadd, float Pbbirrel, int *genmut);
                                
/* Mutacion definiendo pbb de mutacion mediante ranking I(C;F) */
int mutacionRankingMI(cromosoma c, int *ranking, float **MIMatrix,
                      float *MIClases, float *Entropy, float *PbbMutVector,
                      float Pbbadd, float Pbbirrel, int *genmut);

/* Muta cada gen de cada cromosoma de la poblacion con probabilidad pbb */
void mutacionAleatoriaPoblacion(poblacion p, float pbb);
