/************************************************************************
 *                                                                      *
 *                                                                      *
 *            By Rodrigo Caballero C. (rocaball@dim.uchile.cl),         *
 *                                                                      *
 *                        Universidad de Chile                          *
 *             Facultad de Ciencias Fisicas y Matematicas               *
 *                Departamento de Ingenieria Electrica                  *
 *                          Santiago, CHILE.                            *
 *                                1997                                  *
 * Modificaciones: MFY marcadas con "modificacion"			*
 ************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <stddef.h>
#include <malloc.h>
#include <time.h>
#include <float.h>

void load_fmatrix(filename,A,row,col)
char *filename;
float **A;
int row;
int col;
{
	int i, j;
	float x;
	FILE *file_pointer;

	if ((file_pointer=fopen(filename,"r"))==NULL)
	{
		printf("NM run time error\n");
		printf("Cannot open file: %s\n",filename);
		printf("...now exiting\n");
		exit(0);
	}
	else
	{
		for(i=0;i<row;i++)
		{
			for(j=0;j<col;j++)
			{
				fscanf(file_pointer,"%f",&x);
				A[i][j]=x;
			}
			fscanf(file_pointer,"\n");
		}
		fclose(file_pointer);
	}
}
/* modificacion */
void delete_file(filename)
char *filename;
{
	FILE *file_pointer;

	if ((file_pointer=fopen(filename,"w"))==NULL)
	{
		printf("Archivo: %s no puede ser borrado.\n",filename);
	}
	else
	{
		fclose(file_pointer);
	}
}	
void load_fvector(filename,A,row)
char *filename;
float *A;
int row;
{
        int i;
        float x;
        FILE *file_pointer;

        if ((file_pointer=fopen(filename,"r"))==NULL)
        {
                printf("NM run time error\n");
                printf("Cannot open file: %s\n",filename);
                printf("...now exiting\n");
                exit(0);
        }
        else
        {
                for(i=0;i<row;i++)
                {
                        fscanf(file_pointer,"%f",&x);
                        A[i]=x;
                        fscanf(file_pointer,"\n");
                }
                fclose(file_pointer);
        }
}
void save_fvector(filename,V,dim)
char *filename;
float *V;
int dim;
{
	int i;
	FILE *file_pointer;

	if ( (file_pointer=fopen(filename,"w"))==NULL )
	{
		printf("NM runtime error\n");
		printf("Cannot open file: %s\n",filename);
		printf("...now exiting\n");
		exit(0);
	}
	else
	{
		for(i=0;i<dim;i++)
		{
			fprintf(file_pointer,"%i\t%f\n",i,V[i]);
		}
	fclose(file_pointer);
	}
}
void save_fmatrix(filename,A,row,col)
char *filename;
float **A;
int row;
int col;
{
        int i, j;
        FILE *file_pointer;
 
        if ((file_pointer=fopen(filename,"w"))==NULL)
        {
                printf("NM run time error\n");
                printf("Cannot open file: %s\n",filename);
                printf("...now exiting\n");
                exit(0);
        }
        else
        {
                for(i=0;i<row;i++)
                {
                        for(j=0;j<col;j++)
                        {
                                fprintf(file_pointer,"%f ",A[i][j]);
                        }
                        fprintf(file_pointer,"\n");
                }
                fclose(file_pointer);
        }
}
/* modificacion */
void save_imatrix(filename,A,row,col)
char *filename;
int **A;
int row;
int col;
{
        int i, j;
        FILE *file_pointer;

        if ((file_pointer=fopen(filename,"w"))==NULL)
        {
                printf("NM run time error\n");
                printf("Cannot open file: %s\n",filename);
                printf("...now exiting\n");
                exit(0);
        }
        else
        {
                for(i=0;i<row;i++)
                {
                        for(j=0;j<col;j++)
                        {
                                fprintf(file_pointer,"%5d ",A[i][j]);
                        }
                        fprintf(file_pointer,"\n");
                }
                fclose(file_pointer);
        }
}
void save_ivector(filename,vector,dim)
char *filename;
int  *vector;
int  dim;
{
	int i;
	FILE *file_pointer;

	if((file_pointer=fopen(filename,"w"))==NULL)
	{
		printf("NM run time error\n");
		printf("Cannot open file %s\n",filename);
		printf("Now exiting...\n");
		exit(0);
	}
	else
	{
		for(i=0;i<dim;i++)
		{
			fprintf(file_pointer,"%d ",vector[i]);
		}
		fclose(file_pointer);
	}
}
void save_tira(filename,vector,dim)
char *filename;
int  *vector;
int  dim;
{
	int i;
	FILE *file_pointer;

	if((file_pointer=fopen(filename,"w"))==NULL)
	{
		printf("NM run time error\n");
		printf("Cannot open file %s\n",filename);
		printf("Now exiting...\n");
		exit(0);
	}
	else
	{
		for(i=0;i<dim;i++)
		{
			fprintf(file_pointer,"%d",vector[i]);
		}
		fclose(file_pointer);
	}
}
/* fin modificacion */

/* modificacion */
void save_imatrix_app(filename,A,row,col)
/* graba en formato append */
char *filename;
int **A;
int row;
int col;
{
        int i, j;
        FILE *file_pointer;

        if ((file_pointer=fopen(filename,"a"))==NULL)
        {
                printf("NM run time error\n");
                printf("Cannot open file: %s\n",filename);
                printf("...now exiting\n");
                exit(0);
        }
        else
        {
                for(i=0;i<row;i++)
                {
                        for(j=0;j<col;j++)
                        {
                                fprintf(file_pointer,"%5d ",A[i][j]);
                        }
                        fprintf(file_pointer,"\n");
                }
                fclose(file_pointer);
        }
}
/* fin modificacion */
void load_imatrix(filename,A,row,col)
char *filename;
int **A;
int row;
int col;
{
        int i, j;
        int x;
        FILE *file_pointer;
 
        if ((file_pointer=fopen(filename,"r"))==NULL)
        {
                printf("NM run time error\n");
                printf("Cannot open file: %s\n",filename);
                printf("...now exiting\n");
                exit(0);
        }
        else
        {
                for(i=0;i<row;i++)
                {
                        for(j=0;j<col;j++)
                        {
                                fscanf(file_pointer,"%d",&x);
                                A[i][j]=x;
                        }
                        fscanf(file_pointer,"\n");
                }
                fclose(file_pointer);
        }
}

void load_ivector(filename,V,len)
char *filename;
int *V;
int len;
{
        int i;
        int x;
        FILE *file_pointer;
 
        if ((file_pointer=fopen(filename,"r"))==NULL)
        {
                printf("NM run time error\n");
                printf("Cannot open file: %s\n",filename);
                printf("...now exiting\n");
                exit(0);
        }
        else
        {
                for(i=0;i<len;i++)
                {
                        fscanf(file_pointer,"%d\n",&x);
                        V[i]=x;
                }
                fclose(file_pointer);
        }
}
