
#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include "cromosoma.h"
#include "memoria.h"
#include "random.h"
#include "bpqgausql.h"

/* Constantes Algoritmo BPQ */
#define INPUT_BIAS		1
#define HIDDEN_BIAS		1
#define LINEAL_OUT		0
#define S				5
#define NODAL_ERROR 	0.01f
#define PENALTY_TERM	1.0f
			

/**********************************************************************/

void rebuildBase(cromosoma c, int Ntrain, int Nval, int Ninput, int Nhidden, 
                 float **Input_E, float **Input_V, float **NewInput_E,
                 float **NewInput_V, float **Weight_IH, float **NewWeight_IH)
{
	int i, j, idx;
	   
    idx = 0;
    for(i=0; i < Ninput; i++)
    {
    	if(c->cromo[i] == 1)
    	{
    		for(j=0; j < Ntrain; j++)
    		{
    			NewInput_E[j][idx] = Input_E[j][i];
      		}
      		for(j=0; j < Nval; j++)
    		{
    			NewInput_V[j][idx] = Input_V[j][i];
      		}
      		for(j=0; j < Nhidden; j++)
			{
				NewWeight_IH[idx][j] = Weight_IH[i][j];
			}
      		idx++;
     	}
    } 
    
    for(j=0; j < Nhidden; j++)
	{
		NewWeight_IH[idx][j] = Weight_IH[Ninput][j];
	}                
}

/**********************************************************************/

float gamifsFitness(cromosoma c, float **Input_E, float **Target_E, float **Input_V,
                    float **Target_V, float **Weight_IH, float **Weight_HO,
                    int Ntrain, int Nval, int Ninput, int Nhidden, int Noutput,
                    int Epochs, int valStep, float Epsi, float minError,
                    float lambdaMax, float lambdaMin, float *SseE, float *SseV,
                    float *clasiRateE, float *clasiRateV, int *targetIdxE,
                    int *targetIdxV, float *qele, char *SimId, float costRatio,
                    int *NewNinput)
{
	int i;	
	float fitness;
    float **NewInput_E;			/* Cjto Train con caracts seleccionadas por el GA */
    float **NewInput_V;			/* Cjto Val con caracts seleccionadas por el GA */
    float **NewWeight_IH;
    
    /* N de caracts seleccionadas */
	*NewNinput = 0;
	for(i=0; i < Ninput; i++)
		(*NewNinput) += c->cromo[i];
   	
   	/* Reserva de memoria */
//  NewInput_E = matrizFloat(Ntrain, (*NewNinput));
//  NewInput_V = matrizFloat(Nval, (*NewNinput));
//	Weight_IH  = matrizFloat( ((*NewNinput)+INPUT_BIAS), Nhidden );
   	NewInput_E   = matrizFloat(Ntrain, Ninput);
    NewInput_V   = matrizFloat(Nval, Ninput);
	NewWeight_IH = matrizFloat( (Ninput+INPUT_BIAS), Nhidden );
	qele         = vectorFloat( ((*NewNinput)+INPUT_BIAS)*Nhidden +
                              (Nhidden+HIDDEN_BIAS)*Noutput );
	/* Fin reserva de memoria */
	
	/* Inicializacion de pesos aleatoriamente */
//	initFloatMatrixRnd(Weight_IH, ((*NewNinput)+INPUT_BIAS), Nhidden);
	initFloatMatrixRnd(Weight_IH, (Ninput+INPUT_BIAS), Nhidden);
	initFloatMatrixRnd(Weight_HO, (Nhidden+HIDDEN_BIAS), Noutput);
	/* Fin incializacion de pesos */
	 
	/* Rearmado de bases de entrenamiento y validacion */
	rebuildBase(c, Ntrain, Nval, Ninput, Nhidden, Input_E, Input_V, NewInput_E,
                NewInput_V, Weight_IH, NewWeight_IH);
	 
    /* Entrenamiento red neuronal */
    bpq_gauss_learning(NewInput_E, Target_E, NewInput_V, Target_V, NewWeight_IH,
                       Weight_HO, Ntrain, Nval, (*NewNinput), Nhidden, Noutput,
                       INPUT_BIAS, HIDDEN_BIAS, Epochs, valStep, LINEAL_OUT, Epsi,
                       minError, S, NODAL_ERROR, PENALTY_TERM, lambdaMax, lambdaMin,
                       SseE, SseV, clasiRateE, clasiRateV, targetIdxE, targetIdxV,
                       qele, SimId);
    /* Fin red neuronal */

    fitness = ((*clasiRateV) / (float)Nval) -
              costRatio*((float)(*NewNinput) / (float)Ninput);
   
	borrarMatrizFloat(NewInput_E, Ntrain);
    borrarMatrizFloat(NewInput_V, Nval);
	free(qele);
	
	return fitness;
}
/**********************************************************************/

int **par3Optimos(char *filename, int Noptimos, int Nfeatures)
{
	int i, j, aux;
 	int **optimos;
  	FILE *fp;
  	optimos = matrizInt(Noptimos, Nfeatures);
  	
  	fp = fopen(filename, "r");
  	for(i=0; i < Noptimos; i++)
  	{
  		for(j=0; j < Nfeatures; j++)
  		{
  			fscanf(fp, "%d", &aux);
			optimos[i][j] = aux;	
    	}
    }
  	fclose(fp);
  	
  	return optimos;
}

/**********************************************************************/

