/************************************************************************
 *                                                                      *
 *              BPQ-Gauss Neural Network Learning Algorithm             *
 *                                                                      *
 *            By Rodrigo Caballero C. (rocaball@dim.uchile.cl),         *
 *                                                                      *
 *                        Universidad de Chile                          *
 *             Facultad de Ciencias Fisicas y Matematicas               *
 *                Departamento de Ingenieria Electrica                  *
 *                          Santiago, CHILE.                            *
 *                                1997                                  *
 *                                                                      *
 ************************************************************************/

#define TEST_FEATURE_SELECTION

#include <stdio.h>
#include <stdlib.h>
#include <math.h>
#include <malloc.h>
#include <stddef.h>
#include <time.h>
#include <float.h>
#include <string.h>
#include "alloca.h"
#include "loadfile.h"
#include "random.h"


void fmatrix_init(matrix,i_max,j_max,value)
float **matrix;
int i_max;
int j_max;
float value;
{
	int i, j;
	for(i=0;i<i_max;i++)
		for(j=0;j<j_max;j++)
			matrix[i][j] = (float)value;
}	

void fmatrix_init_rnd(matrix,i_max,j_max,seed)
float **matrix;
int i_max;
int j_max;
long *seed;
{
	int i, j;
	for(i=0;i<i_max;i++)
		for(j=0;j<j_max;j++)
		{
			matrix[i][j] = (float)(ran3() - 0.5);
		}
}

void fvector_init(vector,i_max,value)
float *vector;
int i_max;
float value;
{
        int i;
        for(i=0;i<i_max;i++)
		vector[i] = (float)value;
}


void fmatrix_identity(matrix,i_max)
float **matrix;
int i_max;
{
        int i, j;
        for(i=0;i<i_max;i++)
                for(j=0;j<i_max;j++)
		{
			if(i!=j)
                        	matrix[i][j]=0;
			else if(i==j)
				matrix[i][j]=1;
			else
			{
				nerror("fmatrix_identity");
				exit(0);
			}
		}
}

void get_vector(matrix,position,vector,vector_size)
float **matrix;
int position;
float *vector;
int vector_size;
{
	int vec_pos;
 
	for(vec_pos=0;vec_pos<vector_size;vec_pos++)
		/* [row][columm] */
		vector[vec_pos]=matrix[position][vec_pos];
}

void put_vector(matrix,position,vector,vector_size)
float **matrix;
int position;
float *vector;
int vector_size;
{
	int vec_pos;
 
	for(vec_pos=0;vec_pos<vector_size;vec_pos++)
		/* [row][columm] */
                matrix[position][vec_pos]=vector[vec_pos];
}

void show_fmatrix(matrix,i_max,j_max)
float **matrix;
int i_max, j_max;
{
	int i, j;
	for(i=0;i<i_max;i++)
	{
		for(j=0;j<j_max;j++)
			printf("%f ",matrix[i][j]);
		printf("\n");
	}
}

void show_fvector(vector,i_max)
float *vector;
int i_max;
{
	int i;
	for(i=0;i<i_max;i++)
	{
		printf("%f ",vector[i]);
	}
	printf("\n");
}

void copy_fmatrix(src,dst,i_max,j_max)
float **src;
float **dst;
int i_max, j_max;
{
	int i, j;
	for(i=0;i<i_max;i++)
	{
		for(j=0;j<j_max;j++)
		{
			dst[i][j]=src[i][j];
		}
	}
}

float sign(x)
float x;
{
	if(x<0)
		return(-1);
	else if(x>0)
		return(1);
	else if(x==0)
		return(0);
	else
	{
		nerror("sign function");
		exit(0);
	}
}

int rem(x,y)
int x;
int y;
{
	div_t result;

	result=div(x,y);	
	return(result.rem);
}

void forward_step(ww1,vv,ibias,hbias,ninp,nh1,nout,x,y,h1,linealo)
float **ww1;	/* input->hidden layer weights */	
float **vv;	/* hidden->output layer weights */
float *x;       /* Input vector */
float *y;       /* Output vector */
float *h1;	/* Hidden layer output */
int ninp, nh1, nout;
int ibias, hbias;
int linealo;	/* =1 => lineal output */
{
        float sum=0.0;
        int i=0, j=0;		/* auxiliary index */
	if(ibias==1)
		x[ninp]=1.0;
	if(hbias==1)
		h1[nh1]=1.0;
 
        for (j=0;j<nh1;j++)
        {
                sum=0.0;
                for (i=0;i<(ninp+ibias);i++)
                {
                        sum=sum+ww1[i][j]*x[i];
                }
                h1[j] = (float)(1 / (1+exp(-sum)));
        }
        for (j=0;j<nout;j++)
        {
                sum=0.0;
                for (i=0;i<(nh1+hbias);i++)
                {
                        sum=sum+vv[i][j]*h1[i];
                }
                if (linealo==0)
		{
                        y[j] = (float)(1 / (1+exp(-sum)));	/* lineal output */
		}
                else y[j]=sum;
        }
}


void bpq_gauss_learning(INPUT_MATRIX,TARGET_MATRIX,INPUT_MX_VALI,TARGET_MX_VALI,W1,V,
			N_EXAMPLES,N_EXAM_VALI,N_INP,N_H1,N_OUT,INPUT_BIAS,
			HIDDE_BIAS,MAX_EPOCH,STEP_VALIDATION,LINEAL_OUT,EPSI,MIN_ERROR,
			S,NODAL_ERROR,PENALTY_TERM,LAMBDA_MAX,LAMBDA_MIN,MSE,MSE_VALI,
			PCT,PCT_VALI,TARGET_INDEX,TARGET_VALI_INDEX,qele_best,exp_ext) 

float **INPUT_MATRIX;	/* Matrix of input vectors */
float **TARGET_MATRIX;	/* Matrix of output vectors */
float **INPUT_MX_VALI;	/* Matrix of input vectors for validation */
float **TARGET_MX_VALI;	/* Matrix of output vectors for validation */
float **W1;		/* Input->Hidden layer1 weights */
float **V;		/* Hidden->output layer weight */
float *qele_best;
int N_EXAMPLES;		/* Number of examples = npat*/
int N_EXAM_VALI;	/* Number of examples for validation = npat2 */
int N_INP;		/* Number of inputs */
int N_H1;		/* Number of hidden units */
int N_OUT;		/* Number of outputs */
int INPUT_BIAS;		/* =1 if there is bias en the input layer */
int HIDDE_BIAS;		/* =1 if there is bias in the hidden layer */
int MAX_EPOCH;		/* Training cycles */
int STEP_VALIDATION;	/* Steps between validations */
int LINEAL_OUT;		/* =1 if output is lineal */
float EPSI;		/* Forgetting amount */		
float MIN_ERROR;	/* umbral de dife de error */ 
int S;			/* Memory */
float NODAL_ERROR;	/* Error per pattern */
float PENALTY_TERM;	/* =1 squared, =0 absolute */
float LAMBDA_MAX;	/* lambda max */
float LAMBDA_MIN;	/* lambda min */
float *MSE;		/* Training Mean Square Error */
float *MSE_VALI;	/* Generalization Mean Square Error */
float *PCT;		/* % of correct clasification in training set */
float *PCT_VALI;
int *TARGET_INDEX;	/* Index of the target active neuron */
int *TARGET_VALI_INDEX;
char *exp_ext;
{
	/* Variables definitions */

	int N_WEIGHT;
	float **W_best;
	float **V_best;
	float *X;		/* NN input vector */
	float *Y;		/* NN output vector */
	float *T;		/* NN target vector */
	float **y_1;		/* y' */
	float **y_2;		/* y'' */
	float *h1;		/* Hidden layer output */
	float **H1;		/* Hidden layer output matrix */
	float *h1p;
	float *h2p;
	float **d_out;		/* output layer deltha */
	float *d_h1;		/* hidden layer deltha */
	float **Dw1;		/* W1 weight's update */
	float **Dv;		/* V weight's update */
	float **grad_w1;	/* gradiente */
	float **grad_v;		/* gradiente */
	float **DV11;
	float **D11;
	float *FI;		/* model's parameters vector (V & W1) */
	float *qele;
	float *grad_FI;		/* gradiente */
	float *old_grad_FI;	/* gradiente */
	float *d_FI;
	float **error;		/* Error per class */
	float **pk;
	float **qk;
	float **rk;
	float *rk_aux;
	float *aux_pqr;		/* Aux variable for operations with p,q o r*/
	float sse=0.0;		/* error */
	float sse_vali=0.0;	/* validation error */
	float ssetot=0.0;
	float old_ssetot=0.0;
	float dife=0;
	float ssetot_vali=0.0;
	float **H;		/* Hessian matrix */
	float **H_aux;		/* Hessian matrix aux */
	float *alfa;
	float *beta;
	float omega;				/* Omega */
	float gomega1;				/* Omega' */
	float gomega2;				/* Omega'' */
	float lambda=0;				/* Lambda */
	float lambda_aux=0;			/* Lambda aux */
	float lambda_old=0;
	float max_error=0;
	float err=0;
	float sum_aux;				/* aux */
	float sum_aaux;				/* aux */
	float z1p=0;
	float z2p=0;
	float xaux=0;
	float xaux1=0;
	float xaux2=0;
	float *z1p2;
	float *y1p2;
	float x10=0;
	float x20=0;
	float x201=0;
	float x202=0;
	float x10t=0;
	float x20t=0;
	float x20t1=0;
	float x20t2=0;
	float *sigw;

	/* Control Variables */

	int current_epoch=0;	/* current epoch */
	int epoch_aux=0;
	int k=0;		/* ??? */
	int inp_pos;		/* input position */
	int h1_pos;		/* hidden layer position */
	int out_pos;		/* output layer position */
	int fi_pos;		/* FI vector position */
	int fi_ppos;
	int example_pos;        /* examples index */
	int s_pos;              /* S index */

	/* Flags */

	int training_flag=1;	/* =1 training, =0 NO */	
	int validation_flag=1;	/* =1 validarion, =0 NO */

	int stop_flag=0;	/* =1 stop, =0 NO */
	int lambda_flag=0;	/* =flag2 */

	#ifdef FEATURE_SELECTION
	int trace_epoch_flag=0;
	int save_best_criterion=1;	/* 0=min(sse); 1=max(pct) */
	int save_sse_flag=0;
	int save_sse_vali_flag=0;
	int save_lambda_flag=0;
	int save_pct_flag=0;
	int save_clasification=0;
	#endif

	#ifdef TEST_FEATURE_SELECTION
	int trace_epoch_flag=0;
	int save_best_criterion=1;      /* 0=min(sse); 1=max(pct) */
	int save_sse_flag=0;
	int save_sse_vali_flag=0;
	int save_lambda_flag=0;
	int save_pct_flag=0;
	int save_clasification=1;
	#endif

	#ifdef TAREA_EM753
	int trace_epoch_flag=1;
	int save_best_criterion=1;      /* 0=min(sse); 1=max(pct) */
	int save_sse_flag=1;
	int save_sse_vali_flag=1;
	int save_lambda_flag=0;
	int save_pct_flag=1;
	int save_clasification=1;
	#endif

	/* Save Best */

	float sse_best=1E10;
	float sse_vali_best=1E10;
	int pct=0;		/* % of correct classifications */
	int *pct_class;
	int pct_best=0;
	int pct_vali=0;
	int *pct_vali_class;
	int pct_vali_best=0;
	int epoch_best=-1;
	int epoch_vali_best=-1;
	float active_out=0;
	int active_out_pos=0;

	/* Output FILES */

	FILE *sse_fp;
	FILE *sse_vali_fp;
	FILE *lambda_fp;
	FILE *pctclasif_fp;
	FILE *clasif1_fp;
	FILE *clasif2_fp;
	char archivo[20];

	/* Memory Allocation */

	N_WEIGHT= (int)N_OUT*(N_H1+HIDDE_BIAS)+N_H1*(N_INP+INPUT_BIAS);
	W_best 	= fmatrix((N_INP+INPUT_BIAS),N_H1);
	V_best 	= fmatrix((N_H1+HIDDE_BIAS),N_OUT);
	X       = fvector(N_INP+INPUT_BIAS);
	Y       = fvector(N_OUT);
	T       = fvector(N_OUT);
	y_1     = fmatrix(N_EXAMPLES,N_OUT);
	y_2     = fmatrix(N_EXAMPLES,N_OUT);
	h1      = fvector(N_H1+HIDDE_BIAS);
	H1	    = fmatrix(N_EXAMPLES,N_H1+HIDDE_BIAS); 
	h1p     = fvector(N_H1);
	h2p     = fvector(N_H1);
	d_out   = fmatrix(N_EXAMPLES,N_OUT);
	d_h1    = fvector(N_H1+HIDDE_BIAS); /* deberia se dim=N_H1... */
	Dw1     = fmatrix((N_INP+INPUT_BIAS),N_H1);
	Dv      = fmatrix((N_H1+HIDDE_BIAS),N_OUT);
	grad_w1 = fmatrix((N_INP+INPUT_BIAS),N_H1);
	grad_v  = fmatrix((N_H1+HIDDE_BIAS),N_OUT);
	DV11    = fmatrix((N_H1+HIDDE_BIAS),N_OUT);
	D11     = fmatrix((N_INP+INPUT_BIAS),N_H1);
	H       = fmatrix(N_WEIGHT,N_WEIGHT);
	H_aux   = fmatrix(N_WEIGHT,N_WEIGHT);
	FI      = fvector(N_WEIGHT);
	qele	= fvector(N_WEIGHT);
	sigw	= fvector(N_WEIGHT);
	grad_FI = fvector(N_WEIGHT);
	old_grad_FI = fvector(N_WEIGHT);
	d_FI    = fvector(N_WEIGHT);
	error   = fmatrix(N_EXAMPLES,N_OUT);
	alfa	= fvector(S);
	beta	= fvector(S);
	pk      = fmatrix(N_WEIGHT,S);
	qk      = fmatrix(N_WEIGHT,S);
	rk      = fmatrix(N_WEIGHT,S);
	rk_aux	= fvector(N_WEIGHT);
	aux_pqr = fvector(N_WEIGHT);
	z1p2    = fvector(N_OUT);
	y1p2    = fvector(N_OUT);

	pct_class=ivector(N_OUT);
	pct_vali_class=ivector(N_OUT);

	/* Initializations */

	fvector_init(FI,N_WEIGHT,0);
	fvector_init(alfa,S,0);
	fvector_init(beta,S,0);
	fmatrix_init(H_aux,N_WEIGHT,N_WEIGHT,0);
	fmatrix_init(Dw1,(N_INP+INPUT_BIAS),N_H1,0);
	fmatrix_init(Dv,(N_H1+HIDDE_BIAS),N_OUT,0);
	fmatrix_identity(H,N_WEIGHT);
	fvector_init(grad_FI,N_WEIGHT,0);
	
	if(save_sse_flag==1)
	{
		strcpy(archivo,"sse.");
		strcat(archivo,exp_ext);
		if ((sse_fp=fopen(archivo,"w"))==NULL)
		{
			printf("NM run time error\n");
			printf("Cannot open file: %s\n",archivo);
			printf("...now exiting\n");
			exit(0);
		}
	}
	if(save_sse_vali_flag==1)
	{
		strcpy(archivo,"ssevali.");
		strcat(archivo,exp_ext);
		if ((sse_vali_fp=fopen(archivo,"w"))==NULL)
		{
			printf("NM run time error\n");
			printf("Cannot open file: %s\n",archivo);
			printf("...now exiting\n");
			exit(0);
		}
	}
	if(save_lambda_flag==1)
	{
		strcpy(archivo,"lambda.");
		strcat(archivo,exp_ext);
		if ((lambda_fp=fopen(archivo,"w"))==NULL)
		{
			printf("NM run time error\n");
			printf("Cannot open file: %s\n",archivo);
			printf("...now exiting\n");
			exit(0);
		}
	}
	if(save_pct_flag==1)
	{
		strcpy(archivo,"pctclasi.");
		strcat(archivo,exp_ext);
		if ((pctclasif_fp=fopen(archivo,"w"))==NULL)
		{
			printf("NM run time error\n");
			printf("Cannot open file: %s\n",archivo);
			printf("...now exiting\n");
			exit(0);
		}
	}
	
	for(current_epoch=0;current_epoch<MAX_EPOCH;current_epoch++)
	{
		if(trace_epoch_flag==1)
		{
			printf("(%d/%d) mse=%f  pct_t=%0.3f  pct_v=%0.3f\n",current_epoch,MAX_EPOCH,sse,
				(float)pct/N_EXAMPLES,(float)pct_vali/N_EXAM_VALI);
		}
		if(save_pct_flag==1)
		{
			fprintf(pctclasif_fp,"%f %f\n",(float)pct/N_EXAMPLES,(float)pct_vali/N_EXAM_VALI);
		}
		training_flag=1;
		lambda_flag=0;
		if((rem(current_epoch,STEP_VALIDATION)==0)||(current_epoch==0))
			validation_flag=1;
		else
			validation_flag=0;	
		epoch_aux=current_epoch;
		
		while(training_flag==1)
		{
			fmatrix_init(DV11,(N_H1+HIDDE_BIAS),N_OUT,0);
			fmatrix_init(D11,(N_INP+INPUT_BIAS),N_H1,0);
			sse=0.0;
			max_error=0;
			
			for(example_pos=0;example_pos<N_EXAMPLES;example_pos++)
			{
				get_vector(INPUT_MATRIX,example_pos,X,N_INP);
				get_vector(TARGET_MATRIX,example_pos,T,N_OUT);

				/* Forward Step */
				forward_step(W1,V,INPUT_BIAS,HIDDE_BIAS,N_INP,N_H1,N_OUT,X,Y,h1,LINEAL_OUT);	
				/* END -- Forward Step */

				put_vector(H1,example_pos,h1,N_H1+HIDDE_BIAS);
				for(out_pos=0;out_pos<N_OUT;out_pos++)
				{
					if(LINEAL_OUT==0)
					{
						y_1[example_pos][out_pos]=Y[out_pos]*(1-Y[out_pos]);
						y_2[example_pos][out_pos]=y_1[example_pos][out_pos]*(1-2*Y[out_pos]);
					}
					else if(LINEAL_OUT==1)
					{
						y_1[example_pos][out_pos]=1.0;
						y_2[example_pos][out_pos]=0.0;
					}
					else
					{
						nerror("output differentiation");
						exit(0);
					}
					error[example_pos][out_pos]=(T[out_pos]-Y[out_pos]);
					d_out[example_pos][out_pos]=error[example_pos][out_pos]*y_1[example_pos][out_pos];
					sse = (float)(sse+0.5*error[example_pos][out_pos]*error[example_pos][out_pos]);
					err=(float)fabs((double)error[example_pos][out_pos]);
					if(err>max_error)
						max_error=err;
				}
				for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
				{
					for(out_pos=0;out_pos<N_OUT;out_pos++)
					{
						DV11[h1_pos][out_pos]=DV11[h1_pos][out_pos]+d_out[example_pos][out_pos]*h1[h1_pos];	
					}
				}
				for(h1_pos=0;h1_pos<N_H1;h1_pos++)
				{
					sum_aux=0.0;
					for(out_pos=0;out_pos<N_OUT;out_pos++)
					{
						sum_aux=sum_aux+V[h1_pos][out_pos]*d_out[example_pos][out_pos];
					}
					d_h1[h1_pos]=sum_aux*h1[h1_pos]*(1-h1[h1_pos]);
					for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
					{
						D11[inp_pos][h1_pos]=D11[inp_pos][h1_pos]+d_h1[h1_pos]*X[inp_pos];
					}
				}
			} /* END -- example's cycles */
			/* FI & omega definition */
			fi_pos=0;
			omega=0.0;
			for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
				for(out_pos=0;out_pos<N_OUT;out_pos++)
				{
                                        FI[fi_pos]=V[h1_pos][out_pos];
                                        if(PENALTY_TERM==1)     /* =1 squared, =0 absolute */
                                                omega = (float)(omega+0.5*FI[fi_pos]*FI[fi_pos]);
                                        else if(PENALTY_TERM==0)
                                                omega=omega+(float)fabs((double)FI[fi_pos]);
                                        else
                                                nerror("FI definition");
                                        fi_pos++;
				}
			for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
				for(h1_pos=0;h1_pos<N_H1;h1_pos++)
				{
					FI[fi_pos]=W1[inp_pos][h1_pos];
					if(PENALTY_TERM==1)	/* =1 squared, =0 absolute */
						omega = (float)(omega+0.5*FI[fi_pos]*FI[fi_pos]);
					else if(PENALTY_TERM==0)
						omega=omega+(float)fabs((double)FI[fi_pos]);
					else
						nerror("FI definition");
					fi_pos++;
				}
			if(epoch_aux==current_epoch)
			{
				old_ssetot=ssetot;
			}
			ssetot = (float)(sse+EPSI*omega);
			/* End -- FI & omega definition */

			/* Chequear F(FI+lambda*dFI)<F(FI) */
			if(current_epoch>0)
			{
				dife=ssetot-old_ssetot;
				if(dife>MIN_ERROR)	/* crece el error */
				{
					epoch_aux++;
					lambda_aux=lambda;
					if(lambda_flag==0)
					{
						if(lambda_aux>1.0)
						{
							lambda=1.0;
						}
						else
						{
							lambda=-(x10t*lambda_aux*lambda_aux)/
								(2*(dife-x10t*lambda_aux));
						}
						lambda_flag=1;
					}
					else
					{
						lambda=-(x10t*lambda_aux*lambda_aux)/
							(2*(dife-x10t*lambda_aux));
					}
					fi_pos=0;
					for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
					{
						for(out_pos=0;out_pos<N_OUT;out_pos++)
						{
							FI[fi_pos]=FI[fi_pos]-lambda_aux*d_FI[fi_pos]+lambda*d_FI[fi_pos];
							V[h1_pos][out_pos]=FI[fi_pos];
							fi_pos++;
						}
					}
					for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
					{
						for(h1_pos=0;h1_pos<N_H1;h1_pos++)
						{
							FI[fi_pos]=FI[fi_pos]-lambda_aux*d_FI[fi_pos]+lambda*d_FI[fi_pos];
							W1[inp_pos][h1_pos]=FI[fi_pos];
							fi_pos++;
						}
					}
					lambda_aux=lambda;
					if(lambda<=LAMBDA_MIN)	/* lambda=0 */
					{
						break;
					}
				}
				else
				{
					training_flag=0;
				}
			}
			else if(current_epoch==0)
			{
				training_flag=0;
			}
			else
			{
				nerror("training_flag error in Check");
			}
			/* END -- Chequear F(FI+lambda*dFI)<F(FI) */

		} /* END -- While */
		if(save_sse_flag==1)
		{
			fprintf(sse_fp,"%f\n",sse/N_EXAMPLES);
		}

		/* Gradiente Batch */
		if(PENALTY_TERM==1)     /* =1 squared, =0 absolute */
		{
			fi_pos=0;
			for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
				for(out_pos=0;out_pos<N_OUT;out_pos++)
				{
					grad_v[h1_pos][out_pos]=-DV11[h1_pos][out_pos]+EPSI*V[h1_pos][out_pos];	
					if((current_epoch==0)||(S==0))
					{
						Dv[h1_pos][out_pos]=-grad_v[h1_pos][out_pos];
						d_FI[fi_pos]=Dv[h1_pos][out_pos];
					}
					if((current_epoch>0)&&(S>0))
					{
						old_grad_FI[fi_pos]=grad_FI[fi_pos];
					}
					grad_FI[fi_pos]=grad_v[h1_pos][out_pos];
					fi_pos++;
				}
			for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
				for(h1_pos=0;h1_pos<(N_H1);h1_pos++)
				{
					grad_w1[inp_pos][h1_pos]=-D11[inp_pos][h1_pos]+EPSI*W1[inp_pos][h1_pos];
					if((current_epoch==0)||(S==0))
					{
						Dw1[inp_pos][h1_pos]=-grad_w1[inp_pos][h1_pos];
						d_FI[fi_pos]=Dw1[inp_pos][h1_pos];
					}
					if((current_epoch>0)&&(S>0))
					{
						old_grad_FI[fi_pos]=grad_FI[fi_pos];
					}
					grad_FI[fi_pos]=grad_w1[inp_pos][h1_pos];
					fi_pos++;
				}
		}
		else if(PENALTY_TERM==0)
		{
			for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
				for(out_pos=0;out_pos<N_OUT;out_pos++)
				{
					grad_v[h1_pos][out_pos]=-DV11[h1_pos][out_pos]+EPSI*sign(V[h1_pos][out_pos]); 
					if((current_epoch==0)||(S==0))
					{
						Dv[h1_pos][out_pos]=-grad_v[h1_pos][out_pos];
						d_FI[fi_pos]=Dv[h1_pos][out_pos];
					}
					else
					{
						old_grad_FI[fi_pos]=grad_FI[fi_pos];
					}
					grad_FI[fi_pos]=grad_v[h1_pos][out_pos];
					fi_pos++;
				}
			for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
				for(h1_pos=0;h1_pos<(N_H1);h1_pos++)
				{
					grad_w1[inp_pos][h1_pos]=-D11[inp_pos][h1_pos]+EPSI*sign(W1[inp_pos][h1_pos]);
					if((current_epoch==0)||(S==0))
					{
						Dw1[inp_pos][h1_pos]=-grad_w1[inp_pos][h1_pos];
						d_FI[fi_pos]=Dw1[inp_pos][h1_pos];
					}
					else    
					{
						old_grad_FI[fi_pos]=grad_FI[fi_pos];
					}
					grad_FI[fi_pos]=grad_w1[inp_pos][h1_pos];
					fi_pos++;
				}
		}
		else
		{
			nerror("gradiente batch");
			exit(0);
		}
		/* END -- Gradiente Batch */

		/* New descent direction */
		if((current_epoch>0)&&(S>0))
		{
			if((S==1)||(rem(current_epoch,S)==0))	
			{
				s_pos=(S-1);
				k=0;
			}
			else
			{
				k=rem(current_epoch,S);
				s_pos=k-1;
			}
			for(fi_pos=0;fi_pos<N_WEIGHT;fi_pos++)
			{
				pk[fi_pos][k]=lambda*d_FI[fi_pos];
				qk[fi_pos][k]=grad_FI[fi_pos]-old_grad_FI[fi_pos];
				for(fi_ppos=0;fi_ppos<N_WEIGHT;fi_ppos++)
				{
					H_aux[fi_pos][fi_ppos]=H_aux[fi_pos][fi_ppos]-alfa[s_pos]*pk[fi_pos][s_pos]*
						rk[fi_ppos][s_pos]-alfa[s_pos]*rk[fi_pos][s_pos]*pk[fi_ppos][s_pos]+
						beta[s_pos]*pk[fi_pos][s_pos]*pk[fi_ppos][s_pos];
					/* H=I+H_aux */
					if(fi_pos!=fi_ppos)
						H[fi_pos][fi_ppos]=H_aux[fi_pos][fi_ppos];
					else if(fi_pos==fi_ppos)
						H[fi_pos][fi_ppos]=H_aux[fi_pos][fi_ppos]+1;
					else
						nerror("new descent direction");
				}
			}
			sum_aux=0.0;
			for(fi_pos=0;fi_pos<N_WEIGHT;fi_pos++)
			{
				sum_aux=sum_aux+pk[fi_pos][k]*qk[fi_pos][k];
				sum_aaux=0.0;
				for(fi_ppos=0;fi_ppos<N_WEIGHT;fi_ppos++)
				{
					sum_aaux=sum_aaux+H[fi_pos][fi_ppos]*qk[fi_ppos][k];
				}
				rk[fi_pos][k]=sum_aaux;
			}
			/* Division by Cero */
			if(fabs((double)sum_aux)>(double)FLT_EPSILON)
				alfa[k]=1/(sum_aux);
			else
				alfa[k]=1/(sum_aux+FLT_EPSILON);
			/* END -- Division by Cero */
			sum_aux=0.0;
			for(fi_pos=0;fi_pos<N_WEIGHT;fi_pos++)
				sum_aux=sum_aux+qk[fi_pos][k]*rk[fi_pos][k];
			beta[k]=alfa[k]*(1+alfa[k]*sum_aux);	
			for(fi_ppos=0;fi_ppos<N_WEIGHT;fi_ppos++)
			{
				sum_aux=0.0;
                        	for(fi_pos=0;fi_pos<N_WEIGHT;fi_pos++)
				{
                                	sum_aux=sum_aux+rk[fi_pos][k]*grad_FI[fi_pos];
				}
				sum_aaux=0.0;
				for(fi_pos=0;fi_pos<N_WEIGHT;fi_pos++)
				{
					sum_aaux=sum_aaux+pk[fi_pos][k]*grad_FI[fi_pos];
				}
				d_FI[fi_ppos]=-rk[fi_ppos][k]+d_FI[fi_ppos]+alfa[k]*(sum_aux*pk[fi_ppos][k]+
					sum_aaux*rk[fi_ppos][k])-beta[k]*pk[fi_ppos][k]*sum_aaux;
			}
			/* Extract Dv & Dw1 from d_FI */
			fi_pos=0;
			for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
                                for(out_pos=0;out_pos<N_OUT;out_pos++)
                                {
                                        Dv[h1_pos][out_pos]=d_FI[fi_pos];
                                        fi_pos++;
                                }
			for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
                                for(h1_pos=0;h1_pos<N_H1;h1_pos++)
                                {
					Dw1[inp_pos][h1_pos]=d_FI[fi_pos];
					fi_pos++;
				}	
			/* END -- Extract Dv & Dw1 from d_FI */
		}
		/* END -- descent direction */

		gomega1=0.0;
		gomega2=0.0;
		if(PENALTY_TERM==1)     /* =1 squared, =0 absolute */
		{
			for(fi_pos=0;fi_pos<N_WEIGHT;fi_pos++)
			{
				gomega1=gomega1+FI[fi_pos]*d_FI[fi_pos];
				gomega2=gomega2+d_FI[fi_pos]*d_FI[fi_pos];
			}
		}
		else if(PENALTY_TERM==0)
		{
			for(fi_pos=0;fi_pos<N_WEIGHT;fi_pos++)
				gomega1=gomega1+sign(FI[fi_pos])*d_FI[fi_pos];
			gomega2=0.0;
		}
		else
			nerror("penalty term");

		/* Stop criterion */
		if(max_error<NODAL_ERROR)
			/* Error per pattern is OK (Nodal error) */
			stop_flag=1;
		sum_aux=0.0;
		for(fi_pos=0;fi_pos<N_WEIGHT;fi_pos++)
			sum_aux=sum_aux+grad_FI[fi_pos]*grad_FI[fi_pos];
		sum_aux=sum_aux/N_WEIGHT;
		/* Early stop */
		if(sum_aux<1E-10)
			stop_flag=1;
		/* END -- Stop criterion */

		/* Stepwise elimination */
		for(fi_pos=0;fi_pos<N_WEIGHT;fi_pos++)
		{
			sigw[fi_pos]=(float)sqrt((float)2*sse*H[fi_pos][fi_pos]/N_EXAMPLES);
			qele[fi_pos]=FI[fi_pos]/sigw[fi_pos];
		}
		/* END -- Stepwise elimination */

		/* Step-Length calculation */
		x10=0;
		x20=0;
		x201=0;
		x202=0;

		for(example_pos=0;example_pos<N_EXAMPLES;example_pos++)
		{
			get_vector(INPUT_MATRIX,example_pos,X,N_INP);
			get_vector(H1,example_pos,h1,(N_H1+HIDDE_BIAS));
			for(h1_pos=0;h1_pos<N_H1;h1_pos++)
			{
				sum_aux=0;
				for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
				{
					sum_aux=sum_aux+Dw1[inp_pos][h1_pos]*X[inp_pos];
				}
				h1p[h1_pos]=h1[h1_pos]*(1-h1[h1_pos])*sum_aux;
			}
			for(out_pos=0;out_pos<N_OUT;out_pos++)
			{
				sum_aux=0;
                        	sum_aaux=0;
				for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
                        	{
                                	sum_aux=sum_aux+Dv[h1_pos][out_pos]*h1[h1_pos];
                                	sum_aaux=sum_aaux+V[h1_pos][out_pos]*h1p[h1_pos];
                        	}
				z1p=sum_aux+sum_aaux;
				z1p2[out_pos]=z1p*z1p;
				y1p2[out_pos]=y_1[example_pos][out_pos]*y_1[example_pos][out_pos];
				x10=x10-d_out[example_pos][out_pos]*z1p;
			}
			for(h1_pos=0;h1_pos<N_H1;h1_pos++)
			{
				sum_aux=0;
				for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++) 
				{
					sum_aux=sum_aux+(Dw1[inp_pos][h1_pos]*X[inp_pos]);
				}
				h2p[h1_pos]=h1p[h1_pos]*(1-2*h1[h1_pos])*sum_aux*sum_aux;
			}
			for(out_pos=0;out_pos<N_OUT;out_pos++)
			{
				sum_aux=0;
				sum_aaux=0;
				for(h1_pos=0;h1_pos<N_H1;h1_pos++)
				{
					sum_aux=sum_aux+Dv[h1_pos][out_pos]*h1p[h1_pos];
					sum_aaux=sum_aaux+V[h1_pos][out_pos]*h2p[h1_pos];
				}
				z2p=2*sum_aux+sum_aaux;		
				xaux=z1p2[out_pos]*y1p2[out_pos]-error[example_pos][out_pos]*y_2[example_pos][out_pos]*
					z1p2[out_pos]-error[example_pos][out_pos]*y_1[example_pos][out_pos]*z2p;
				xaux1=z1p2[out_pos]*y1p2[out_pos]-error[example_pos][out_pos]*y_2[example_pos][out_pos]*z1p2[out_pos];
				xaux2=z1p2[out_pos]*y1p2[out_pos];
			}
			x20=x20+xaux;
			x201=x201+xaux1;
			x202=x202+xaux2;
		}
		x10t = (float)(x10+EPSI*gomega1);
		x20t = (float)(x20+EPSI*gomega2);
		x20t1= (float)(x201+EPSI*gomega2);
		x20t2= (float)(x202+EPSI*gomega2);
		if(x10t>0)	/* Derivada positiva */
		{
			if(S>1)
			{
				fvector_init(alfa,S,0);
				fvector_init(beta,S,0);
				fmatrix_init(H_aux,N_WEIGHT,N_WEIGHT,0);
			}
			fi_pos=0;
			sum_aux=0;
			for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
			{
				for(out_pos=0;out_pos<N_OUT;out_pos++)
				{
					Dv[h1_pos][out_pos]=-grad_v[h1_pos][out_pos];
					d_FI[fi_pos]=-grad_FI[fi_pos];
					sum_aux=sum_aux-d_FI[fi_pos]*d_FI[fi_pos];
					fi_pos++;
				}
			}
			for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
			{
				for(h1_pos=0;h1_pos<N_H1;h1_pos++)
				{
					Dw1[inp_pos][h1_pos]=-grad_w1[inp_pos][h1_pos];
					d_FI[fi_pos]=-grad_FI[fi_pos];
					sum_aux=sum_aux-d_FI[fi_pos]*d_FI[fi_pos];
					fi_pos++;
				}
			}
			x10t=sum_aux;
		}
		if(x20t<=0)
		{
			if(x20t1>0)
			{
				x20t=x20t1;
			}
			else
			{
				/* falla aproximacion */
				x20t=x20t2;
			}
		}
		lambda=-x10t/x20t;
		sum_aux=0;
		sum_aaux=0;
		for(fi_pos=0;fi_pos<N_WEIGHT;fi_pos++)
		{
			sum_aux=sum_aux+(lambda*d_FI[fi_pos])*(lambda*d_FI[fi_pos]);
			sum_aaux=sum_aaux+d_FI[fi_pos]*d_FI[fi_pos];
		}
		if(sqrt(sum_aux)>LAMBDA_MAX)	/* lambda too big */
		{
			lambda = (float)(1 / sqrt(sum_aaux));
		}
		if(save_lambda_flag==1)
		{
			fprintf(lambda_fp,"%f\n",lambda);
		}
		/* END -- Step-Length calculation */	

		/* Validation */
		if(validation_flag==1)
		{
			sse_vali=0.0;
			pct_vali=0;
			for(out_pos=0;out_pos<N_OUT;out_pos++)
			{
				pct_vali_class[out_pos]=0;
			}
			for(example_pos=0;example_pos<N_EXAM_VALI;example_pos++)
			{
				get_vector(INPUT_MX_VALI,example_pos,X,N_INP);
				get_vector(TARGET_MX_VALI,example_pos,T,N_OUT);
 
                                /* Forward Step */
                                forward_step(W1,V,INPUT_BIAS,HIDDE_BIAS,N_INP,N_H1,N_OUT,X,Y,h1,LINEAL_OUT);
                                /* END -- Forward Step */

				active_out=0.0;
				for(out_pos=0;out_pos<N_OUT;out_pos++)
                                {
                                        error[example_pos][out_pos]=(T[out_pos]-Y[out_pos]);
                                        sse_vali = (float)(sse_vali+0.5*error[example_pos][out_pos]*error[example_pos][out_pos]);
					if(Y[out_pos]>active_out)
					{
						active_out_pos=out_pos;
						active_out=Y[out_pos];
					}
                                }
				if(N_OUT==1)
				{
					if(((Y[0]>=0.6)&&(T[0]==1))||((Y[0]<=0.4)&&(T[0]==0)))
					{
						pct_vali++;
					}
				}
				else
				{
					if(active_out_pos==TARGET_VALI_INDEX[example_pos])
					{
						pct_vali++;
						pct_vali_class[active_out_pos]=pct_vali_class[active_out_pos]+1;
					}	
				}
			}
			omega=0.0;
			for(fi_pos=0;fi_pos<N_WEIGHT;fi_pos++)
			{
   				if(PENALTY_TERM==1)     /* =1 squared, =0 absolute */
					omega = (float)(omega+0.5*FI[fi_pos]*FI[fi_pos]);
   				else if(PENALTY_TERM==0)
   					omega = (float)(omega+abs(FI[fi_pos]));
   				else
					nerror("FI definition in validation");
			}
			ssetot_vali = (float)(sse_vali+EPSI*omega);	

			pct=0;
			for(out_pos=0;out_pos<N_OUT;out_pos++)
			{
				pct_class[out_pos]=0;
			}
			for(example_pos=0;example_pos<N_EXAMPLES;example_pos++)
			{
				get_vector(INPUT_MATRIX,example_pos,X,N_INP);
				get_vector(TARGET_MATRIX,example_pos,T,N_OUT);
				forward_step(W1,V,INPUT_BIAS,HIDDE_BIAS,N_INP,N_H1,N_OUT,X,Y,h1,LINEAL_OUT);
				active_out=0.0;
				for(out_pos=0;out_pos<N_OUT;out_pos++)
				{
					if(Y[out_pos]>active_out)
					{
						active_out_pos = out_pos;
						active_out = Y[out_pos];
					}
				}
				if(N_OUT==1)
				{
					if(((Y[0]>=0.6)&&(T[0]==1))||((Y[0]<=0.4)&&(T[0]==0)))
					{
						pct++;
					}
				}
				else
				{
					if(active_out_pos==TARGET_INDEX[example_pos])
					{
						pct++;
						pct_class[active_out_pos]=pct_class[active_out_pos]+1;
					}
				}
			}
		}
		
		/* Save Best Validation */
		if(save_best_criterion==0)
		{
			if(sse_vali<=sse_vali_best)
			{
				sse_vali_best=sse_vali;
				sse_best=sse;
				pct_best=pct;
				pct_vali_best=pct_vali;
				epoch_vali_best=current_epoch;
				fi_pos=0;
				for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
				{
					for(h1_pos=0;h1_pos<N_H1;h1_pos++)
					{
						W_best[inp_pos][h1_pos]=W1[inp_pos][h1_pos];
						qele_best[fi_pos]=qele[fi_pos];
						fi_pos++;
					}
				}
				for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
				{
					for(out_pos=0;out_pos<N_OUT;out_pos++)
					{
						V_best[h1_pos][out_pos]=V[h1_pos][out_pos];
						qele_best[fi_pos]=qele[fi_pos];
						fi_pos++;
					}
				}
			}
		}
		else
		{
			if(pct_vali>=pct_vali_best)
			{
				pct_best=pct;
				pct_vali_best=pct_vali;
				sse_best=sse;
				sse_vali_best=sse_vali;
				epoch_vali_best=current_epoch;
				fi_pos=0;
				for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
				{
					for(h1_pos=0;h1_pos<N_H1;h1_pos++)
					{
						W_best[inp_pos][h1_pos]=W1[inp_pos][h1_pos];
						qele_best[fi_pos]=qele[fi_pos];
						fi_pos++;
					}
				}
				for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
				{
					for(out_pos=0;out_pos<N_OUT;out_pos++)
					{
						V_best[h1_pos][out_pos]=V[h1_pos][out_pos];
						qele_best[fi_pos]=qele[fi_pos];
						fi_pos++;
					}
				}
			}
		}
		if(save_sse_vali_flag==1)
		{
			fprintf(sse_vali_fp,"%f\n",sse_vali/N_EXAM_VALI);
		}
		/* END -- Validation */

		/* Weight update */
		for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
		{
			for(h1_pos=0;h1_pos<N_H1;h1_pos++)
			{
				W1[inp_pos][h1_pos]=W1[inp_pos][h1_pos]+lambda*Dw1[inp_pos][h1_pos];	
			}
		}
		for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
		{
			for(out_pos=0;out_pos<N_OUT;out_pos++)
			{
				V[h1_pos][out_pos]=V[h1_pos][out_pos]+lambda*Dv[h1_pos][out_pos];
			}
		}
		if(stop_flag==1)
		{
			break;
		}
	}
	
	/* Clasificaciones entregadas por la red */
	if(save_clasification==1)
	{
		strcpy(archivo,"clasif1.");
		strcat(archivo,exp_ext);
		if ((clasif1_fp=fopen(archivo,"w"))==NULL)
		{
			printf("NM run time error\n");
			printf("Cannot open file: %s\n",archivo);
			printf("...now exiting\n");
			exit(0);
		}
		else
		{
			for(example_pos=0;example_pos<N_EXAMPLES;example_pos++)
			{
				active_out=0.0;
				get_vector(INPUT_MATRIX,example_pos,X,N_INP);
				get_vector(TARGET_MATRIX,example_pos,T,N_OUT);
				forward_step(W_best,V_best,INPUT_BIAS,HIDDE_BIAS,N_INP,N_H1,N_OUT,X,Y,h1,LINEAL_OUT);
				if(N_OUT==1)
				{
					if(Y[0]>=0.5)
						fprintf(clasif1_fp,"1\n");
					else
						fprintf(clasif1_fp,"0\n");
				}
				else
				{
					for(out_pos=0;out_pos<N_OUT;out_pos++)
					{
						if(Y[out_pos]>active_out)
						{
							active_out_pos=out_pos;
							active_out=Y[out_pos];
						}
					}
					for(out_pos=0;out_pos<N_OUT;out_pos++)
					{
						if(out_pos==active_out_pos)
							fprintf(clasif1_fp,"1 ");
						else
							fprintf(clasif1_fp,"0 ");
					}
					fprintf(clasif1_fp,"\n");
				}
			}
		}
		fclose(clasif1_fp);
		strcpy(archivo,"clasif2.");
		strcat(archivo,exp_ext);
		if ((clasif2_fp=fopen(archivo,"w"))==NULL)
		{
			printf("NM run time error\n");
			printf("Cannot open file: %s\n",archivo);
			printf("...now exiting\n");
			exit(0);
		}
		else
		{
			for(example_pos=0;example_pos<N_EXAM_VALI;example_pos++)
			{
				active_out=0.0;
				get_vector(INPUT_MX_VALI,example_pos,X,N_INP);
				get_vector(TARGET_MX_VALI,example_pos,T,N_OUT);
				forward_step(W_best,V_best,INPUT_BIAS,HIDDE_BIAS,N_INP,N_H1,N_OUT,X,Y,h1,LINEAL_OUT);
				if(N_OUT==1)
				{
					if(Y[0]>=0.5)
						fprintf(clasif1_fp,"1\n");
					else
						fprintf(clasif1_fp,"0\n");
				}
				else
				{
					for(out_pos=0;out_pos<N_OUT;out_pos++)
					{
						if(Y[out_pos]>active_out)
						{
							active_out_pos=out_pos;
							active_out=Y[out_pos];
						}
					}
					for(out_pos=0;out_pos<N_OUT;out_pos++)
					{
						if(out_pos==active_out_pos)
							fprintf(clasif2_fp,"1 ");
						else
							fprintf(clasif2_fp,"0 ");
					}
					fprintf(clasif2_fp,"\n");
				}
			}
		}
		fclose(clasif2_fp);
	}
	
	free(X);	
	free(Y);
	free(T);
	free(h1);
	free(h1p);
	free(h2p);
	free(d_h1);
	free(FI);
	free(qele);
	free(grad_FI);
	free(old_grad_FI);
	free(d_FI);
	free(rk_aux);
	free(aux_pqr);
	free(z1p2);
	free(y1p2);
	free(alfa);
	free(beta);
	free_fmatrix(y_1,N_EXAMPLES,N_OUT);
	free_fmatrix(y_2,N_EXAMPLES,N_OUT);
	free_fmatrix(H1,N_EXAMPLES,N_H1+HIDDE_BIAS);
	free_fmatrix(d_out,N_EXAMPLES,N_OUT);
	free_fmatrix(Dw1,(N_INP+INPUT_BIAS),N_H1);
	free_fmatrix(Dv,(N_H1+HIDDE_BIAS),N_OUT);
	free_fmatrix(grad_w1,(N_INP+INPUT_BIAS),N_H1);
	free_fmatrix(grad_v,(N_H1+HIDDE_BIAS),N_OUT);
	free_fmatrix(DV11,(N_H1+HIDDE_BIAS),N_OUT);
	free_fmatrix(D11,(N_INP+INPUT_BIAS),N_H1);
	free_fmatrix(H,N_WEIGHT,N_WEIGHT);
	free_fmatrix(H_aux,N_WEIGHT,N_WEIGHT);
	free_fmatrix(error,N_EXAMPLES,N_OUT);
	free_fmatrix(pk,N_WEIGHT,S);
	free_fmatrix(qk,N_WEIGHT,S);
	free_fmatrix(rk,N_WEIGHT,S);
	
	for(inp_pos=0;inp_pos<(N_INP+INPUT_BIAS);inp_pos++)
	{
		for(h1_pos=0;h1_pos<N_H1;h1_pos++)
		{
			W1[inp_pos][h1_pos]=W_best[inp_pos][h1_pos];
		}
	}
	for(h1_pos=0;h1_pos<(N_H1+HIDDE_BIAS);h1_pos++)
	{
		for(out_pos=0;out_pos<N_OUT;out_pos++)
		{
			V[h1_pos][out_pos]=V_best[h1_pos][out_pos];
		}
	}
	free_fmatrix(W_best,(N_INP+INPUT_BIAS),N_H1);
	free_fmatrix(V_best,(N_H1+HIDDE_BIAS),N_OUT);
	/* OJO Si hay errores !!! */
	/*
	free_fmatrix(W1,(N_INP+INPUT_BIAS),N_H1);
	free_fmatrix(V,(N_H1+HIDDE_BIAS),N_OUT);
	W1=W_best;
	V=V_best;
	*/
	/* END -- Ojo */
	
	if(save_sse_flag==1)
		fclose(sse_fp);
	if(save_sse_vali_flag==1)
		fclose(sse_vali_fp);
	if(save_pct_flag==1)
		fclose(pctclasif_fp);
	(*MSE)=sse_best;
	(*MSE_VALI)=sse_vali_best;
	(*PCT)=(float)pct_best;
	(*PCT_VALI)=(float)pct_vali_best;
	free(pct_class);
	free(pct_vali_class);
	
}
